/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.promptsupport;

import org.eclipse.nebula.widgets.opal.promptsupport.BaseFocusControlListener;
import org.eclipse.nebula.widgets.opal.promptsupport.FocusControlListenerFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PromptSupport {
    private static final String KEY = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport";
    static final String BACKGROUND = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.background";
    static final String FOREGROUND = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.foreground";
    static final String STYLE = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.style";
    static final String BEHAVIOR = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.behavior";
    static final String PROMPT = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.prompt";
    static final String SET = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.set";
    static final String IS_PROMPT_DISPLAYED = "org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport.displayed";

    public static void init(String promptText, Color promptForeground, Color promptBackground, Control control) {
        if (promptText != null && promptText.length() > 0) {
            PromptSupport.setPrompt(promptText, control);
        }
        if (promptForeground != null) {
            PromptSupport.setForeground(promptForeground, control);
        }
        if (promptBackground != null) {
            PromptSupport.setBackground(promptBackground, control);
        }
    }

    public static Color getBackground(Control control) {
        Color temp = (Color)control.getData(BACKGROUND);
        return temp == null ? control.getBackground() : temp;
    }

    public static void setBackground(Color color, Control control) {
        PromptSupport.checkControl(control);
        control.setData(BACKGROUND, (Object)color);
    }

    public static FocusBehavior getFocusBehavior(Control control) {
        FocusBehavior temp = (FocusBehavior)((Object)control.getData(BEHAVIOR));
        return temp == null ? FocusBehavior.HIDE_PROMPT : temp;
    }

    public static void setFocusBehavior(FocusBehavior focusBehavior, Control control) {
        PromptSupport.checkControl(control);
        control.setData(BEHAVIOR, (Object)focusBehavior);
    }

    public static int getFontStyle(Control control) {
        Integer temp = (Integer)control.getData(STYLE);
        return temp == null ? 2 : temp;
    }

    public static void setFontStyle(int fontStyle, Control control) {
        PromptSupport.checkControl(control);
        control.setData(STYLE, (Object)fontStyle);
    }

    public static Color getForeground(Control control) {
        Color temp = (Color)control.getData(FOREGROUND);
        return temp == null ? control.getForeground() : temp;
    }

    public static void setForeground(Color color, Control control) {
        PromptSupport.checkControl(control);
        control.setData(FOREGROUND, (Object)color);
    }

    public static String getPrompt(Control control) {
        return (String)control.getData(PROMPT);
    }

    public static void setPrompt(String promptText, Control control) {
        boolean alreadySet;
        PromptSupport.checkControl(control);
        boolean bl = alreadySet = control.getData(SET) == null ? false : (Boolean)control.getData(SET);
        if (alreadySet) {
            throw new IllegalArgumentException("A prompt has already been set on this control !");
        }
        control.setData(PROMPT, (Object)promptText);
        BaseFocusControlListener focusControlListener = FocusControlListenerFactory.getFocusControlListenerFor(control);
        control.addFocusListener((FocusListener)focusControlListener);
        control.addControlListener((ControlListener)focusControlListener);
        control.setData(SET, (Object)true);
    }

    private static void checkControl(Control control) {
        if (!(control instanceof Text || control instanceof Combo || control instanceof StyledText || control instanceof CCombo)) {
            throw new IllegalArgumentException("PromptSupport can only be used on a Text, a Combo, a StyledText or a CCombo widget.");
        }
    }

    static boolean isPromptDisplayed(Control control) {
        return (Boolean)control.getData(IS_PROMPT_DISPLAYED);
    }

    static void setPromptDisplayed(Control control, boolean newValue) {
        control.setData(IS_PROMPT_DISPLAYED, (Object)newValue);
    }

    public static enum FocusBehavior {
        HIGHLIGHT_PROMPT,
        HIDE_PROMPT;

    }
}

