/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.promptsupport;

import org.eclipse.nebula.widgets.opal.promptsupport.BaseFocusControlListener;
import org.eclipse.nebula.widgets.opal.promptsupport.PromptSupport;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

class TextFocusControlListener
extends BaseFocusControlListener {
    public TextFocusControlListener(Text control) {
        super((Control)control);
    }

    @Override
    protected void hidePrompt() {
        ((Text)this.control).setText("");
    }

    @Override
    protected void highLightPrompt() {
        this.control.getDisplay().asyncExec(() -> ((Text)this.control).selectAll());
    }

    @Override
    protected void fillPromptText() {
        String promptText = PromptSupport.getPrompt(this.control);
        if (promptText != null) {
            ((Text)this.control).setText(promptText);
        }
    }

    @Override
    protected boolean isFilled() {
        String promptText = PromptSupport.getPrompt(this.control);
        String trimmedText = ((Text)this.control).getText().trim();
        if (promptText != null && promptText.equals(trimmedText) && !PromptSupport.isPromptDisplayed(this.control)) {
            return false;
        }
        return !"".equals(trimmedText);
    }
}

