/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.passwordrevealer;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.passwordrevealer.PasswordRevealer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

class EyeButton
extends Canvas {
    private static final int CIRCLE_RAY = 4;
    private boolean mouseIn;
    private boolean pressed;
    private final Color color;

    EyeButton(Composite parent, int style) {
        super(parent, 0x20000000);
        this.addListeners();
        this.color = new Color((Device)parent.getDisplay(), 0, 127, 222);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.color);
        this.setBackground(this.getDisplay().getSystemColor(1));
    }

    private void addListeners() {
        this.addPaintListener(e -> this.paintControl(e));
        this.addListener(6, event -> {
            this.mouseIn = true;
            this.redraw();
        });
        this.addListener(7, event -> {
            this.mouseIn = false;
            this.pressed = false;
            this.redraw();
        });
        this.addListener(3, event -> {
            this.pressed = true;
            ((PasswordRevealer)this.getParent()).revealPassword();
            this.redraw();
        });
        this.addListener(4, event -> {
            this.pressed = false;
            ((PasswordRevealer)this.getParent()).hidePassword();
            this.redraw();
        });
    }

    private void paintControl(PaintEvent e) {
        GC gc = e.gc;
        if (!this.mouseIn && !this.pressed) {
            this.drawEye(gc, this.getDisplay().getSystemColor(15));
            return;
        }
        if (this.mouseIn && !this.pressed) {
            this.drawEye(gc, this.color);
            return;
        }
        Rectangle rect = this.getClientArea();
        gc.setBackground(this.color);
        gc.fillRectangle(rect);
        this.drawEye(gc, this.getDisplay().getSystemColor(1));
    }

    private void drawEye(GC gc, Color clr) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        gc.setLineWidth(2);
        Rectangle rect = this.getClientArea();
        int eyeWidth = (int)((double)rect.width * 0.7);
        int eyeHeight = (int)((double)rect.height * 0.5);
        gc.setForeground(clr);
        gc.drawOval((int)((double)rect.width * 0.15), (int)((double)rect.height * 0.25), eyeWidth, eyeHeight);
        gc.setBackground(clr);
        gc.fillOval(rect.width / 2 - 2, rect.height / 2 - 2, 4, 4);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        PasswordRevealer parent = (PasswordRevealer)this.getParent();
        int preferred = parent.passwordField.computeSize((int)-1, (int)hHint, (boolean)changed).y;
        return super.computeSize(Math.max(preferred, 20), Math.max(preferred, 20), changed);
    }
}

