/*******************************************************************************
 * Copyright (c) 2004, 2007 Boeing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Boeing - initial API and implementation
 *******************************************************************************/
package org.eclipse.nebula.widgets.xviewer.example.styledExample;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerContentProvider;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask.RunDb;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask.TaskType;
import org.eclipse.nebula.widgets.xviewer.example.model.SomeTask;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * Example implementation of XViewer that shows usage of styled string label provider
 *
 * @author Andrew M. Finkbeiner
 */
public class XViewerStyledStringLableProviderTest extends XViewer {
   private final Set<ISomeTask> runList = new HashSet<ISomeTask>();

   public XViewerStyledStringLableProviderTest(Composite parent, int style) {
      super(parent, style, new MyXViewerFactory());
   }

   public boolean isScheduled(ISomeTask autoRunTask) {
      return true;
   }

   public boolean isRun(ISomeTask autoRunTask) {
      return runList.contains(autoRunTask);
   }

   public void setRun(ISomeTask autoRunTask, boolean run) {
      if (run) {
         runList.add(autoRunTask);
      } else {
         runList.remove(autoRunTask);
      }
   }

   public static void main(String[] args) {
      Display Display_1 = Display.getDefault();
      Shell Shell_1 = new Shell(Display_1, SWT.SHELL_TRIM);
      Shell_1.setText("XViewer Styled Text Test");
      Shell_1.setBounds(0, 0, 1000, 500);
      Shell_1.setLayout(new GridLayout());
      Shell_1.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.HORIZONTAL_ALIGN_BEGINNING));

      XViewerStyledStringLableProviderTest xViewerTest =
         new XViewerStyledStringLableProviderTest(Shell_1, SWT.MULTI | SWT.BORDER | SWT.FULL_SELECTION);
      xViewerTest.getTree().setLayoutData(new GridData(GridData.FILL_BOTH));
      xViewerTest.setContentProvider(new MyXViewerContentProvider());
      xViewerTest.setLabelProvider(new XViewerTestStyledStringLabelProvider(xViewerTest));

      List<Object> tasks = new ArrayList<Object>();
      for (int x = 0; x < 1; x++) {
         tasks.addAll(getTestTasks());
      }
      /**
       * Note: setInputXViewer must be called instead of setInput for XViewer to operate properly
       */
      xViewerTest.setInputXViewer(tasks);
      Shell_1.open();
      while (!Shell_1.isDisposed()) {
         if (!Display_1.readAndDispatch()) {
            Display_1.sleep();
         }
      }

      Display_1.dispose();
   }

   private static List<ISomeTask> getTestTasks() {
      List<ISomeTask> tasks = new ArrayList<ISomeTask>();
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Backup, "org.eclipse.osee.test1", "10:03", "run to test this",
         "Suite A", "mark", 99));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Data_Exchange, "org.eclipse.osee.test2", "9:22",
         "run to test that", "Suite B", "john", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Backup, "org.eclipse.osee.test4", "8:23", "in this world",
         "Suite A", "john", 50));
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Backup, "org.eclipse.osee.test3", "23:01", "now is the time",
         "Suite B", "mike", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Db_Health, "org.eclipse.osee.test5", "7:32", "may be never",
         "Suite A", "steve", 100));
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Data_Exchange, "org.eclipse.osee.test14", "6:11",
         "how can this solve the problem", "Suite A", "steve", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Backup, "org.eclipse.osee.test6", "5:13",
         "run to test this", "Suite B", "john", 50));
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Db_Health, "org.eclipse.osee.test12", "23:15", "run to test this",
         "Suite A", "mike", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Backup, "org.eclipse.osee.test13", "4:01",
         "run to test this", "Suite B", "steve", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Data_Exchange, "org.eclipse.osee.test11", "3:16",
         "run to test this", "Suite A", "steve", 70));
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Backup, "org.eclipse.osee.test10", "5:01", "run to test this",
         "Suite C", "mike", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Data_Exchange, "org.eclipse.osee.test9", "4:27",
         "run to test this", "Suite C", "steve", 50));
      tasks.add(new SomeTask(RunDb.Production_Db, TaskType.Regression, "org.eclipse.osee.test7", "2:37",
         "run to test this", "Suite C", "john", 50));
      tasks.add(new SomeTask(RunDb.Test_Db, TaskType.Db_Health, "org.eclipse.osee.test8", "24:00", "run to test this",
         "Suite C", "mike", 20));
      return tasks;
   }
}
