/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerGradient;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;
import org.eclipse.nebula.widgets.xviewer.action.TableCustomizationAction;
import org.eclipse.nebula.widgets.xviewer.action.TableCustomizationDropDownAction;
import org.eclipse.nebula.widgets.xviewer.column.XViewerDaysTillTodayColumn;
import org.eclipse.nebula.widgets.xviewer.column.XViewerDiffsBetweenColumnsColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.customize.ColumnFilterDataUI;
import org.eclipse.nebula.widgets.xviewer.customize.CustomizeManager;
import org.eclipse.nebula.widgets.xviewer.customize.FilterDataUI;
import org.eclipse.nebula.widgets.xviewer.customize.SearchDataUI;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerEditAdapter;
import org.eclipse.nebula.widgets.xviewer.util.Pair;
import org.eclipse.nebula.widgets.xviewer.util.internal.ElapsedTime;
import org.eclipse.nebula.widgets.xviewer.util.internal.HtmlUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLib;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerMenuDetectListener;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerMouseListener;
import org.eclipse.nebula.widgets.xviewer.util.internal.dialog.HtmlDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class XViewer
extends TreeViewer {
    public static final String MENU_GROUP_PRE = "XVIEWER MENU GROUP PRE";
    public static final String MENU_GROUP_POST = "XVIEWER MENU GROUP POST";
    private Label statusLabel;
    private final MenuManager menuManager;
    private static boolean ctrlKeyDown = false;
    private static boolean altKeyDown = false;
    protected final IXViewerFactory xViewerFactory;
    private final FilterDataUI filterDataUI;
    private final SearchDataUI searchDataUI;
    private final ColumnFilterDataUI columnFilterDataUI;
    private static boolean ctrlKeyListenersSet = false;
    private XViewerGradient xViewerGradient = null;
    private XViewerEditAdapter editAdapter = null;
    private boolean columnMultiEditEnabled = false;
    private CustomizeManager customizeMgr;
    private TreeColumn rightClickSelectedColumn = null;
    private Integer rightClickSelectedColumnNum = null;
    private TreeItem rightClickSelectedItem = null;
    private Color searchColor;
    private boolean forcePend = false;
    private static final Map<Composite, Composite> parentToTopComposites = new HashMap<Composite, Composite>();
    private boolean debugLoading = "true".equals(System.getProperty("DebugLoading"));
    private final Map<String, Long> preComputeElapsedTime = new HashMap<String, Long>();
    private static List<XViewerComputedColumn> computedColumns = new ArrayList<XViewerComputedColumn>();
    Listener displayKeysListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.keyCode == 262144) {
                if (event.type == 1) {
                    ctrlKeyDown = true;
                } else if (event.type == 2) {
                    ctrlKeyDown = false;
                }
            }
            if (event.keyCode == 65536) {
                if (event.type == 1) {
                    altKeyDown = true;
                } else if (event.type == 2) {
                    altKeyDown = false;
                }
            }
        }
    };
    Listener displayFocusListener = new Listener(){

        public void handleEvent(Event event) {
            ctrlKeyDown = false;
            altKeyDown = false;
        }
    };
    private Composite searchComp;
    private XViewerMouseListener mouseListener;
    private boolean loading;

    public XViewer(Composite parent, int style, IXViewerFactory xViewerFactory) {
        this(parent, style, xViewerFactory, false, false);
    }

    public XViewer(Tree tree, IXViewerFactory xViewerFactory) {
        this(tree, xViewerFactory, false, false);
    }

    public XViewer(Composite parent, int style, IXViewerFactory xViewerFactory, boolean filterRealTime, boolean searchRealTime) {
        this(new Tree(XViewer.createTopComposite(xViewerFactory, parent), style), xViewerFactory, filterRealTime, searchRealTime);
    }

    private static Composite createTopComposite(IXViewerFactory xViewerFactory, Composite parent) {
        if (xViewerFactory.isSearhTop()) {
            Composite topComposite = new Composite(parent, 0);
            topComposite.setLayout((Layout)XViewerLib.getZeroMarginLayout(11, false));
            topComposite.setLayoutData((Object)new GridData(4, 0, true, false));
            parentToTopComposites.put(parent, topComposite);
        } else {
            parentToTopComposites.put(parent, parent);
        }
        return parent;
    }

    public XViewer(Tree tree, IXViewerFactory xViewerFactory, boolean filterRealTime, boolean searchRealTime) {
        super(tree);
        this.xViewerFactory = xViewerFactory;
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.createContextMenu((Control)tree.getParent());
        this.filterDataUI = xViewerFactory.isFilterUiAvailable() ? new FilterDataUI(this, filterRealTime) : null;
        this.searchDataUI = xViewerFactory.isSearchUiAvailable() ? new SearchDataUI(this, searchRealTime) : null;
        this.columnFilterDataUI = new ColumnFilterDataUI(this);
        try {
            this.customizeMgr = new CustomizeManager(this, xViewerFactory);
        }
        catch (Exception ex) {
            XViewerLog.logAndPopup(Activator.class, Level.SEVERE, ex);
        }
        this.createSupportWidgets(parentToTopComposites.get(tree.getParent()));
        parentToTopComposites.remove(tree.getParent());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.setUseHashlookup(true);
        this.setupCtrlKeyListener();
        if (xViewerFactory.isCellGradientOn()) {
            this.xViewerGradient = new XViewerGradient(this);
        }
    }

    protected ColumnViewerEditor createViewerEditor() {
        return super.createViewerEditor();
    }

    public Collection<XViewerComputedColumn> getComputedColumns() {
        if (computedColumns.size() == 0) {
            computedColumns.add(new XViewerDaysTillTodayColumn());
            computedColumns.add(new XViewerDiffsBetweenColumnsColumn());
        }
        return computedColumns;
    }

    public Collection<XViewerComputedColumn> getComputedColumns(XViewerColumn xCol) {
        ArrayList<XViewerComputedColumn> matchCols = new ArrayList<XViewerComputedColumn>();
        for (XViewerColumn xViewerColumn : this.getComputedColumns()) {
            if (!((XViewerComputedColumn)xViewerColumn).isApplicableFor(xCol)) continue;
            matchCols.add((XViewerComputedColumn)xViewerColumn);
        }
        return matchCols;
    }

    public void dispose() {
        if (this.statusLabel != null && !this.statusLabel.isDisposed()) {
            this.statusLabel.dispose();
        }
        if (this.searchComp != null && !this.searchComp.isDisposed()) {
            this.searchComp.dispose();
        }
        Display.getCurrent().removeFilter(1, this.displayKeysListener);
        Display.getCurrent().removeFilter(2, this.displayKeysListener);
        Display.getCurrent().removeFilter(16, this.displayFocusListener);
        if (this.menuManager != null) {
            this.menuManager.removeAll();
            this.menuManager.dispose();
        }
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (!(labelProvider instanceof IXViewerLabelProvider)) {
            throw new IllegalArgumentException("Label Provider must extend XViewerLabelProvider or XViewerStyledTextLabelProvider");
        }
        super.setLabelProvider(labelProvider);
    }

    public void addCustomizeToViewToolbar(ViewPart viewPart) {
        this.addCustomizeToViewToolbar(viewPart.getViewSite().getActionBars().getToolBarManager());
    }

    public void updateMenuActionsForTable() {
    }

    public void updateMenuActionsForHeader() {
    }

    public Action getCustomizeAction() {
        return new TableCustomizationDropDownAction(this);
    }

    public Action getCustomizeActionWithoutDropDown() {
        return new TableCustomizationAction(this);
    }

    public void addCustomizeToViewToolbar(IToolBarManager toolbarManager) {
        toolbarManager.add((IAction)new TableCustomizationDropDownAction(this));
    }

    protected void createSupportWidgets(Composite parent) {
        this.searchColor = Display.getDefault().getSystemColor(7);
        this.searchComp = null;
        if (this.searchDataUI != null || this.filterDataUI != null || this.xViewerFactory.isLoadedStatusLabelAvailable()) {
            GridData gd;
            this.searchComp = new Composite(parent, 0);
            this.searchComp.setLayout((Layout)XViewerLib.getZeroMarginLayout(11, false));
            this.searchComp.setLayoutData((Object)new GridData(4, 0, true, false));
            if (this.filterDataUI != null) {
                this.filterDataUI.createWidgets(this.searchComp);
                Label sep1 = new Label(this.searchComp, 2);
                gd = new GridData(131072, 0, false, false);
                gd.heightHint = 16;
                sep1.setLayoutData((Object)gd);
            }
            if (this.searchDataUI != null) {
                this.searchDataUI.createWidgets(this.searchComp);
                Label sep2 = new Label(this.searchComp, 2);
                gd = new GridData(131072, 0, false, false);
                gd.heightHint = 16;
                sep2.setLayoutData((Object)gd);
            }
            if (this.xViewerFactory.isLoadedStatusLabelAvailable()) {
                this.statusLabel = new Label(this.searchComp, 0);
                this.statusLabel.setText(" ");
                this.statusLabel.setLayoutData((Object)new GridData(4, 0, true, false));
                this.statusLabel.addMouseListener((MouseListener)this.getCustomizationMouseListener());
            }
        }
        this.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XViewer.this.handleDoubleClick();
            }
        });
        this.mouseListener = new XViewerMouseListener(this);
        this.getTree().addMouseListener((MouseListener)this.mouseListener);
        this.getTree().addListener(35, (Listener)new XViewerMenuDetectListener(this));
        this.getTree().setMenu(this.getMenuManager().getMenu());
        this.columnFilterDataUI.createWidgets();
        this.customizeMgr.loadCustomization();
    }

    public void handleDoubleClick(TreeColumn col, TreeItem item) {
    }

    public void handleDoubleClick() {
    }

    public int getCurrentColumnWidth(XViewerColumn xCol) {
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn col = treeColumnArray[n2];
            if (col.getText().equals(xCol.getName())) {
                return col.getWidth();
            }
            ++n2;
        }
        return 0;
    }

    public final void setInputXViewer(Object input) {
        this.refreshColumnsWithPreCompute(input);
    }

    private void superInputChanged(Object input) {
        if (this.getTree() != null && !this.getTree().isDisposed()) {
            super.setInput(input);
        }
    }

    private List<Object> getInputObjects(Object input) {
        LinkedList<Object> objects;
        block3: {
            Object[] arr;
            block2: {
                objects = new LinkedList<Object>();
                if (!(input instanceof Collection)) break block2;
                Collection collection = (Collection)input;
                for (Object obj : collection) {
                    objects.add(obj);
                }
                break block3;
            }
            if (!(input instanceof Object[])) break block3;
            Object[] objectArray = arr = (Object[])input;
            int n = arr.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                objects.add(obj);
                ++n2;
            }
        }
        return objects;
    }

    public void refreshColumnsWithPreCompute() {
        this.refreshColumnsWithPreCompute(this.getInput());
    }

    public void refreshColumnsWithPreCompute(final Object input) {
        final List<Object> inputObjects = this.getInputObjects(input);
        final XViewer xViewer = this;
        this.loading = true;
        if (!inputObjects.isEmpty()) {
            if (this.forcePend) {
                this.performPreCompute(inputObjects);
                this.performLoad(inputObjects, xViewer);
            } else {
                Job job = new Job("Refreshing Columns"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ElapsedTime time = new ElapsedTime("performPreCompute");
                        XViewer.this.performPreCompute(inputObjects);
                        time.end(ElapsedTime.Units.SEC);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(false);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ElapsedTime time = new ElapsedTime("performLoad");
                                XViewer.this.performLoad(input, xViewer);
                                time.end(ElapsedTime.Units.SEC);
                            }
                        });
                    }
                });
                job.schedule();
            }
        }
    }

    private void performPreCompute(List<Object> inputObjects) {
        List<XViewerColumn> currentVisibleTableColumns = this.getCustomizeMgr().getCurrentVisibleTableColumns();
        for (XViewerColumn column : currentVisibleTableColumns) {
            if (!(column instanceof IXViewerPreComputedColumn)) continue;
            IXViewerPreComputedColumn preComputedColumn = (IXViewerPreComputedColumn)column;
            if (column.getPreComputedValueMap() == null) {
                column.setPreComputedValueMap(new HashMap(inputObjects.size()));
            } else {
                column.getPreComputedValueMap().clear();
            }
            if (inputObjects.isEmpty()) continue;
            try {
                Long startTime = this.isDebugLoading() ? new Date().getTime() : 0L;
                preComputedColumn.populateCachedValues(inputObjects, column.getPreComputedValueMap());
                if (!this.isDebugLoading()) continue;
                Long elapsedTime = this.preComputeElapsedTime.get("PRE - " + column.getName());
                elapsedTime = elapsedTime == null ? Long.valueOf(new Date().getTime() - startTime) : Long.valueOf(elapsedTime + (new Date().getTime() - startTime));
                this.preComputeElapsedTime.put("PRE - " + column.getName(), elapsedTime);
            }
            catch (Exception ex) {
                XViewerLog.log(Activator.class, Level.SEVERE, String.format("Error performing pre-compute for column %s", column), ex);
            }
        }
    }

    private void performLoad(Object input, XViewer xViewer) {
        if (xViewer.getTree() != null && !xViewer.getTree().isDisposed()) {
            xViewer.superInputChanged(input);
            this.loading = false;
            this.updateStatusLabel();
        }
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn.getData() instanceof XViewerColumn && (XViewerColumn)treeColumn.getData() instanceof IAltLeftClickProvider) {
            return ((IAltLeftClickProvider)((XViewerColumn)treeColumn.getData())).handleAltLeftClick(treeColumn, treeItem);
        }
        return false;
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        return false;
    }

    public boolean handleLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        return false;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (treeColumn.getData() instanceof XViewerColumn && (XViewerColumn)treeColumn.getData() instanceof IMultiColumnEditProvider) {
            ((IMultiColumnEditProvider)((XViewerColumn)treeColumn.getData())).handleColumnMultiEdit(treeColumn, treeItems);
        }
    }

    public boolean isColumnMultiEditable(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (!this.isColumnMultiEditEnabled()) {
            return false;
        }
        return ((XViewerColumn)treeColumn.getData()).isMultiColumnEditable();
    }

    public boolean isRemoveItemsMenuOptionEnabled() {
        return true;
    }

    public XViewerColumn getXTreeColumn(int columnIndex) {
        return (XViewerColumn)this.getTree().getColumn(columnIndex).getData();
    }

    private void setupCtrlKeyListener() {
        if (!ctrlKeyListenersSet) {
            ctrlKeyListenersSet = true;
            Display.getCurrent().addFilter(1, this.displayKeysListener);
            Display.getCurrent().addFilter(2, this.displayKeysListener);
            Display.getCurrent().addFilter(16, this.displayFocusListener);
        }
    }

    public void resetDefaultSorter() {
        this.customizeMgr.resetDefaultSorter();
    }

    public void remove(Collection<Object> objects) {
        Object input = this.getInput();
        if (input instanceof Collection) {
            Collection inputObj = (Collection)this.getInput();
            for (Object obj : objects) {
                super.remove(obj);
                inputObj.remove(obj);
            }
        }
    }

    @Deprecated
    public void load(Collection<Object> objects) {
        this.setInputXViewer(objects);
    }

    public void setSorter(ViewerSorter sorter) {
        super.setSorter(sorter);
        this.updateStatusLabel();
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public int getVisibleItemCount(TreeItem[] items) {
        int cnt = items.length;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getExpanded()) {
                cnt += this.getVisibleItemCount(item.getItems());
            }
            ++n2;
        }
        return cnt;
    }

    public int getVisibleItemCount() {
        TreeItem[] items = this.getTree().getItems();
        int cnt = items.length;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getExpanded()) {
                cnt += this.getVisibleItemCount(item.getItems());
            }
            ++n2;
        }
        return cnt;
    }

    public List<TreeItem> getVisibleItems() {
        ArrayList<TreeItem> toReturn = new ArrayList<TreeItem>();
        this.getVisibleItems(toReturn, this.getTree().getItems());
        return toReturn;
    }

    private void getVisibleItems(List<TreeItem> toReturn, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            toReturn.add(item);
            if (item.getExpanded()) {
                this.getVisibleItems(toReturn, item.getItems());
            }
            ++n2;
        }
    }

    public void refresh() {
        if (this.getTree() == null || this.getTree().isDisposed()) {
            return;
        }
        super.refresh();
    }

    public boolean isFiltered() {
        return this.getFilters().length > 0;
    }

    public void refresh(boolean updateLabels) {
        super.refresh(updateLabels);
    }

    public void refresh(Object element, boolean updateLabels) {
        super.refresh(element, updateLabels);
        this.updateStatusLabel();
    }

    public void refresh(Object element) {
        super.refresh(element);
        this.updateStatusLabel();
    }

    public String getStatusString() {
        return "";
    }

    public void updateStatusLabel() {
        if (!this.xViewerFactory.isLoadedStatusLabelAvailable()) {
            return;
        }
        if (this.getTree().isDisposed() || this.statusLabel.isDisposed()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        boolean allItemsFiltered = false;
        if (this.loading) {
            sb.append("Loading...");
        } else {
            int loadedNum = 0;
            int visibleNum = this.getVisibleItemCount(this.getTree().getItems());
            if (this.getRoot() != null && (ITreeContentProvider)this.getContentProvider() != null) {
                loadedNum = ((ITreeContentProvider)this.getContentProvider()).getChildren(this.getRoot()).length;
            }
            boolean bl = allItemsFiltered = loadedNum > 0 && visibleNum == 0;
            if (allItemsFiltered) {
                sb.append(XViewerText.get("status.all_filtered"));
            }
            sb.append(MessageFormat.format(XViewerText.get("status"), loadedNum, visibleNum, ((IStructuredSelection)this.getSelection()).size()));
            this.customizeMgr.appendToStatusLabel(sb);
            if (this.filterDataUI != null) {
                this.filterDataUI.appendToStatusLabel(sb);
            }
            this.columnFilterDataUI.appendToStatusLabel(sb);
            sb.append(this.getStatusString());
            if (sb.length() > 0) {
                sb.append("\n");
            }
            this.customizeMgr.getSortingStr(sb);
        }
        String str = sb.toString();
        this.statusLabel.setText(str);
        this.statusLabel.getParent().getParent().layout();
        this.statusLabel.setToolTipText(str);
        if (this.loading) {
            this.statusLabel.setForeground(Display.getCurrent().getSystemColor(9));
        } else if (allItemsFiltered) {
            this.statusLabel.setForeground(Display.getCurrent().getSystemColor(3));
        } else {
            this.statusLabel.setForeground(Display.getCurrent().getSystemColor(2));
        }
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
        this.updateStatusLabel();
    }

    private MouseAdapter getCustomizationMouseListener() {
        return new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3 && mouseEvent.count == 1) {
                    CustomizeData custData = XViewer.this.getCustomizeMgr().getCurrentCustomizeData();
                    List<XViewerColumn> currentVisibleTableColumns = XViewer.this.getCustomizeMgr().getCurrentVisibleTableColumns();
                    custData.getColumnData().getColumns().clear();
                    custData.getColumnData().getColumns().addAll(currentVisibleTableColumns);
                    String custStr = custData.toString();
                    custStr = custStr.replaceAll("XView", "\nXView");
                    custStr = custStr.replaceFirst("guid", "\nguid");
                    String html = HtmlUtil.simplePage(HtmlUtil.getPreData(custStr));
                    String title = String.format("Customization [%s]-[%s]", custData.getName(), custData.getGuid());
                    new HtmlDialog(title, title, html).open();
                }
            }
        };
    }

    public String getViewerNamespace() {
        return this.getXViewerFactory().getNamespace();
    }

    public IXViewerFactory getXViewerFactory() {
        return this.xViewerFactory;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public FilterDataUI getFilterDataUI() {
        return this.filterDataUI;
    }

    public boolean isColumnMultiEditEnabled() {
        return this.columnMultiEditEnabled;
    }

    public void setColumnMultiEditEnabled(boolean columnMultiEditEnabled) {
        this.columnMultiEditEnabled = columnMultiEditEnabled;
    }

    public void setEnabled(boolean arg) {
        this.getControl().setEnabled(arg);
    }

    public TreeColumn getRightClickSelectedColumn() {
        return this.rightClickSelectedColumn;
    }

    public TreeItem getRightClickSelectedItem() {
        return this.rightClickSelectedItem;
    }

    public Integer getRightClickSelectedColumnNum() {
        return this.rightClickSelectedColumnNum;
    }

    public CustomizeManager getCustomizeMgr() {
        return this.customizeMgr;
    }

    public boolean isCtrlKeyDown() {
        return ctrlKeyDown;
    }

    public boolean isAltKeyDown() {
        return altKeyDown;
    }

    boolean searchMatch(String text) {
        if (this.searchDataUI == null) {
            return false;
        }
        return this.searchDataUI.match(text);
    }

    Color getSearchMatchColor() {
        return this.searchColor;
    }

    public boolean isSearch() {
        if (this.searchDataUI == null) {
            return false;
        }
        return this.searchDataUI.isSearch();
    }

    public String getColumnText(Object element, int col) {
        return ((IXViewerLabelProvider)this.getLabelProvider()).getColumnText(element, col);
    }

    public void processRightClickMouseEvent(Point point) {
        this.rightClickSelectedColumn = null;
        this.rightClickSelectedColumnNum = null;
        this.rightClickSelectedItem = null;
        this.rightClickSelectedItem = this.getItemUnderMouseClick(point);
        this.rightClickSelectedColumn = this.getColumnUnderMouseClick(point);
        this.rightClickSelectedColumnNum = this.getColumnNumberUnderMouseClick(point);
    }

    public TreeColumn getColumnUnderMouseClick(Point point) throws ArrayIndexOutOfBoundsException {
        Integer columnNumber = this.getColumnNumberUnderMouseClick(point);
        if (columnNumber == null) {
            return null;
        }
        return this.getTree().getColumn(columnNumber.intValue());
    }

    public Integer getColumnNumberUnderMouseClick(Point point) {
        int[] columnOrder = this.getTree().getColumnOrder();
        int sum = 0;
        int columnCount = 0;
        int[] nArray = columnOrder;
        int n = columnOrder.length;
        int n2 = 0;
        while (n2 < n) {
            int column = nArray[n2];
            TreeColumn col = this.getTree().getColumn(column);
            if ((sum += col.getWidth()) > point.x) break;
            ++columnCount;
            ++n2;
        }
        if (columnCount > columnOrder.length - 1) {
            return null;
        }
        return columnOrder[columnCount];
    }

    public TreeItem getItemUnderMouseClick(Point point) throws ArrayIndexOutOfBoundsException {
        TreeItem itemToReturn = this.getTree().getItem(point);
        if (itemToReturn == null) {
            TreeItem[] allItems;
            int sum = 0;
            TreeItem[] treeItemArray = allItems = this.getTree().getItems();
            int n = allItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if ((sum += this.getTree().getItemHeight()) > point.y) {
                    itemToReturn = item;
                    break;
                }
                ++n2;
            }
        }
        return itemToReturn;
    }

    public void refreshColumn(XViewerColumn column) {
        this.refreshColumn(column.getId());
    }

    public void refreshColumn(String columnId) {
        Pair<XViewerColumn, Integer> column = this.getCustomizeMgr().getColumnNumFromXViewerColumn(columnId);
        IBaseLabelProvider baseLabelProvider = this.getLabelProvider();
        if (baseLabelProvider instanceof XViewerLabelProvider) {
            TreeItem[] items;
            XViewerLabelProvider labelProvider = (XViewerLabelProvider)baseLabelProvider;
            TreeItem[] treeItemArray = items = this.getTree().getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                ViewerRow viewerRow = this.getViewerRowFromItem((Widget)item);
                if (viewerRow != null) {
                    try {
                        ViewerCell cell = viewerRow.getCell(column.getSecond().intValue());
                        String value = null;
                        try {
                            value = labelProvider.getColumnText(item.getData(), column.getSecond());
                        }
                        catch (Exception ex) {
                            value = String.format("Exception getting value from column [%s][%s]", column.getFirst().getId(), ex.getLocalizedMessage());
                        }
                        if (value != null) {
                            cell.setText(value);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }

    public XViewerTextFilter getXViewerTextFilter() {
        return new XViewerTextFilter(this);
    }

    public XViewerGradient getxViewerGradient() {
        return this.xViewerGradient;
    }

    public void setxViewerGradient(XViewerGradient xViewerGradient) {
        this.xViewerGradient = xViewerGradient;
    }

    public void setXViewerEditAdapter(XViewerEditAdapter editAdapter) {
        this.editAdapter = editAdapter;
        this.editAdapter.activate(this);
    }

    public ColumnFilterDataUI getColumnFilterDataUI() {
        return this.columnFilterDataUI;
    }

    public XViewerMouseListener getMouseListener() {
        return this.mouseListener;
    }

    public boolean isForcePend() {
        return this.forcePend;
    }

    public void setForcePend(boolean forcePend) {
        this.forcePend = forcePend;
    }

    public boolean isDebugLoading() {
        return this.debugLoading;
    }

    public void setDebugLoading(boolean debugLoading) {
        this.debugLoading = debugLoading;
    }

    public Map<String, Long> getPreComputeElapsedTime() {
        return this.preComputeElapsedTime;
    }
}

