/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerHtmlReport;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.util.XViewerException;
import org.eclipse.nebula.widgets.xviewer.util.internal.HtmlUtil;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerTreeReport
extends XViewerHtmlReport {
    protected final XViewer xViewer;
    protected final String title;
    private Map<XViewerColumn, Integer> xColToColumnIndex = null;

    public XViewerTreeReport(String title, XViewer treeViewer) {
        super(title);
        this.title = title;
        this.xViewer = treeViewer;
    }

    public XViewerTreeReport(XViewer xViewer) {
        this(XViewerText.get("XViewerTreeReport.title"), xViewer);
    }

    @Override
    public void open(String defaultFilename) {
        super.open(defaultFilename);
    }

    @Override
    public String getHtml() throws XViewerException {
        return this.getHtml(this.xViewer.getTree().getItems());
    }

    public String getHtml(TreeItem[] items) throws XViewerException {
        StringBuffer sb = new StringBuffer("<html><body>");
        sb.append(HtmlUtil.beginMultiColumnTable(100, 1));
        List<XViewerColumn> columns = this.xViewer.getCustomizeMgr().getCurrentTableColumnsInOrder();
        ArrayList<String> headerStrs = new ArrayList<String>(50);
        ArrayList<XViewerColumn> showCols = new ArrayList<XViewerColumn>(50);
        this.xColToColumnIndex = this.xViewer.getCustomizeMgr().getCurrentTableColumnsIndex();
        for (XViewerColumn xCol : columns) {
            if (!xCol.isShow()) continue;
            showCols.add(xCol);
            headerStrs.add(xCol.getName());
        }
        sb.append(HtmlUtil.addHeaderRowMultiColumnTable(headerStrs.toArray(new String[headerStrs.size()])));
        IXViewerLabelProvider labelProv = (IXViewerLabelProvider)this.xViewer.getLabelProvider();
        ArrayList<String[]> list = new ArrayList<String[]>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.addRow(item, list, labelProv, showCols, 1);
            ++n2;
        }
        for (String[] strs : list) {
            sb.append(HtmlUtil.addRowMultiColumnTable(strs));
        }
        sb.append(HtmlUtil.endMultiColumnTable());
        sb.append("</body></html>");
        return sb.toString();
    }

    private void addRow(TreeItem item, List<String[]> rowData, IXViewerLabelProvider labelProv, List<XViewerColumn> showCols, int level) throws XViewerException {
        ArrayList<String> cellData = new ArrayList<String>(showCols.size());
        boolean firstCell = true;
        for (XViewerColumn xCol : showCols) {
            StringBuffer str = new StringBuffer();
            if (firstCell) {
                int y = 1;
                while (y < level) {
                    str.append("__INSERT_TAB_HERE__");
                    ++y;
                }
                firstCell = false;
            }
            str.append(labelProv.getColumnText(item.getData(), this.xColToColumnIndex.get(xCol)));
            String html = HtmlUtil.textToHtml(str.toString());
            html = html.replaceAll("__INSERT_TAB_HERE__", "&nbsp;&nbsp;&nbsp;&nbsp;");
            cellData.add(html);
        }
        rowData.add(cellData.toArray(new String[cellData.size()]));
        if (item.getExpanded()) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem i = treeItemArray[n2];
                this.addRow(i, rowData, labelProv, showCols, level + 1);
                ++n2;
            }
        }
    }
}

