/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.edit;

import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.edit.CellEditDescriptor;
import org.eclipse.nebula.widgets.xviewer.edit.ExtendedViewerColumn;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerConverter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerEditAdapter {
    XViewer xv;
    ViewerCell klickedCell;
    TreeColumn klickedColumn;
    int orientationStyle;
    final XViewerControlFactory factory;
    final XViewerConverter converter;
    private int swtEvent = 0;
    private MyMouseListener mouseListener = null;
    private static boolean InInput = false;

    public XViewerEditAdapter(XViewerControlFactory factory, XViewerConverter converter) {
        this.factory = factory;
        this.converter = converter;
        this.orientationStyle = 131072;
        this.swtEvent = 3;
    }

    public void activate(XViewer xv) {
        this.xv = xv;
        this.mouseListener = new MyMouseListener(this.swtEvent);
        xv.getTree().addMouseListener((MouseListener)this.mouseListener);
        xv.getTree().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XViewerEditAdapter.this.handleEditEvent(event);
            }
        });
    }

    private void doHandleEvent(Event event) {
        this.handleEditEvent(event);
    }

    boolean handleEditEvent(Event event) {
        Control c;
        block14: {
            block9: {
                block10: {
                    CellEditDescriptor ced;
                    block13: {
                        block12: {
                            block11: {
                                if (this.klickedColumn == null || this.klickedCell == null) {
                                    return false;
                                }
                                try {
                                    XViewerColumn xColumn = this.xv.getXViewerFactory().getDefaultXViewerColumn(((XViewerColumn)this.klickedColumn.getData()).getId());
                                    if (!(xColumn instanceof ExtendedViewerColumn)) break block9;
                                    ExtendedViewerColumn extendedColumn = (ExtendedViewerColumn)xColumn;
                                    ced = extendedColumn.getCellEditDescriptorMap().get(this.klickedCell.getElement().getClass());
                                    if (ced == null) break block10;
                                    if (ced.getControl() != null) break block11;
                                    return false;
                                }
                                catch (Exception ex) {
                                    return false;
                                }
                            }
                            if (ced.getAction() == null || ced.getAction().isEnabled()) break block12;
                            return false;
                        }
                        if (this.converter.isValid(ced, this.klickedCell.getElement())) break block13;
                        return false;
                    }
                    c = this.factory.createControl(ced, this.xv);
                    if (c == null) {
                        return false;
                    }
                    break block14;
                }
                return false;
            }
            return false;
        }
        if ((TreeItem)event.item != null) {
            Listener myListener = new Listener(){

                public void handleEvent(Event e) {
                    block0 : switch (e.type) {
                        case 16: {
                            XViewerEditAdapter.this.getInput(c);
                            c.dispose();
                            break;
                        }
                        case 25: {
                            c.setBounds(XViewerEditAdapter.this.klickedCell.getBounds());
                            break;
                        }
                        case 31: {
                            boolean neighbor = false;
                            switch (e.detail) {
                                case 4: {
                                    XViewerEditAdapter.this.getInput(c);
                                }
                                case 2: {
                                    c.dispose();
                                    e.doit = false;
                                    break block0;
                                }
                                case 16: {
                                    XViewerEditAdapter.this.getInput(c);
                                    neighbor = XViewerEditAdapter.this.getNeighbor(ViewerCell.RIGHT, true);
                                    e.doit = false;
                                    c.dispose();
                                    Event eN = new Event();
                                    eN.type = 13;
                                    eN.widget = XViewerEditAdapter.this.xv.getTree();
                                    if (neighbor) {
                                        eN.item = XViewerEditAdapter.this.klickedCell.getItem();
                                    }
                                    XViewerEditAdapter.this.doHandleEvent(eN);
                                    break block0;
                                }
                                case 8: {
                                    XViewerEditAdapter.this.getInput(c);
                                    neighbor = XViewerEditAdapter.this.getNeighbor(ViewerCell.LEFT, true);
                                    e.doit = false;
                                    c.dispose();
                                    Event eP = new Event();
                                    eP.type = 13;
                                    eP.widget = XViewerEditAdapter.this.xv.getTree();
                                    if (neighbor) {
                                        eP.item = XViewerEditAdapter.this.klickedCell.getItem();
                                    }
                                    XViewerEditAdapter.this.doHandleEvent(eP);
                                }
                            }
                        }
                    }
                }
            };
            c.addListener(16, myListener);
            c.addListener(31, myListener);
            c.addListener(25, myListener);
            this.setInput(c);
            c.setFocus();
            return true;
        }
        return false;
    }

    private boolean getNeighbor(int directionMask, boolean sameLevel) {
        block7: {
            try {
                if (this.klickedCell != null) break block7;
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
        Point cellPosition = new Point(this.klickedCell.getBounds().x, this.klickedCell.getBounds().y);
        this.klickedCell = this.xv.getCell(cellPosition).getNeighbor(directionMask, sameLevel);
        this.klickedColumn = this.xv.getColumnUnderMouseClick(new Point(this.klickedCell.getBounds().x, this.klickedCell.getBounds().y));
        XViewerColumn xColumn = this.xv.getXViewerFactory().getDefaultXViewerColumn(((XViewerColumn)this.klickedColumn.getData()).getId());
        if (xColumn instanceof ExtendedViewerColumn) {
            ExtendedViewerColumn extendedColumn = (ExtendedViewerColumn)xColumn;
            CellEditDescriptor ced = extendedColumn.getCellEditDescriptorMap().get(this.klickedCell.getElement().getClass());
            if (ced == null) {
                return this.getNeighbor(directionMask, sameLevel);
            }
            if (ced.getControl() == null) {
                return this.getNeighbor(directionMask, sameLevel);
            }
        } else {
            return this.getNeighbor(directionMask, sameLevel);
        }
        return true;
    }

    void getInput(Control c) {
        block10: {
            if (InInput) {
                return;
            }
            if (this.klickedCell == null) {
                return;
            }
            XViewerColumn xCol = this.xv.getXViewerFactory().getDefaultXViewerColumn(((XViewerColumn)this.klickedColumn.getData()).getId());
            if (xCol instanceof ExtendedViewerColumn) {
                ExtendedViewerColumn extendedCol = (ExtendedViewerColumn)xCol;
                CellEditDescriptor ced = extendedCol.getCellEditDescriptorMap().get(this.klickedCell.getElement().getClass());
                if (ced == null || ced.getControl() == null) {
                    return;
                }
                InInput = true;
                try {
                    try {
                        Object toModify = this.getInputToModify();
                        Object obj = this.converter.getInput(c, ced, toModify);
                        if (obj == null) {
                            this.refreshElement(toModify);
                            break block10;
                        }
                        this.refreshElement(obj);
                    }
                    catch (Exception exception) {
                        InInput = false;
                    }
                }
                finally {
                    InInput = false;
                }
            }
        }
    }

    void refreshElement(Object toRefresh) {
        this.xv.refresh(toRefresh);
    }

    Object getInputToModify() {
        return this.klickedCell.getElement();
    }

    void setInput(Control c) {
        Rectangle bounds;
        if (this.klickedCell == null) {
            return;
        }
        boolean fitInCell = true;
        XViewerColumn xCol = this.xv.getXViewerFactory().getDefaultXViewerColumn(((XViewerColumn)this.klickedColumn.getData()).getId());
        if (xCol instanceof ExtendedViewerColumn) {
            ExtendedViewerColumn extendedCol = (ExtendedViewerColumn)xCol;
            CellEditDescriptor ced = extendedCol.getCellEditDescriptorMap().get(this.klickedCell.getElement().getClass());
            if (ced == null || ced.getControl() == null) {
                return;
            }
            this.converter.setInput(c, ced, this.klickedCell.getElement());
            fitInCell = ced.isFitInCell();
        }
        if (fitInCell) {
            if (this.klickedCell.getImage() != null) {
                bounds = this.klickedCell.getBounds();
                bounds.x += 18;
                c.setBounds(bounds);
            } else {
                c.setBounds(this.klickedCell.getBounds());
            }
        } else {
            bounds = this.klickedCell.getBounds();
            Point point = c.getSize();
            if (this.orientationStyle == 0x4000000 || this.orientationStyle == 131072) {
                bounds.x = bounds.x + bounds.width - point.x;
            }
            bounds.width = point.x;
            bounds.height = point.y;
            c.setBounds(bounds);
        }
    }

    public void setInputControlOrientation(int style) {
        this.orientationStyle = style;
    }

    private class MyMouseListener
    implements MouseListener {
        private int swtStyle = 0;

        public MyMouseListener(int swtStyle) {
            this.swtStyle = swtStyle;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (this.swtStyle == 8) {
                XViewerEditAdapter.this.klickedColumn = XViewerEditAdapter.this.xv.getColumnUnderMouseClick(new Point(e.x, e.y));
                XViewerEditAdapter.this.klickedCell = XViewerEditAdapter.this.xv.getCell(new Point(e.x, e.y));
            }
        }

        public void mouseDown(MouseEvent e) {
            if (this.swtStyle == 3) {
                XViewerEditAdapter.this.klickedColumn = XViewerEditAdapter.this.xv.getColumnUnderMouseClick(new Point(e.x, e.y));
                XViewerEditAdapter.this.klickedCell = XViewerEditAdapter.this.xv.getCell(new Point(e.x, e.y));
            }
        }

        public void mouseUp(MouseEvent e) {
            if (this.swtStyle == 4) {
                XViewerEditAdapter.this.klickedColumn = XViewerEditAdapter.this.xv.getColumnUnderMouseClick(new Point(e.x, e.y));
                XViewerEditAdapter.this.klickedCell = XViewerEditAdapter.this.xv.getCell(new Point(e.x, e.y));
            }
        }
    }
}

