/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.badgedlabel;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class BadgedLabel
extends Canvas {
    private static final int PADDING = 8;
    private static final int MARGIN = 7;
    private static final int CIRCLE_DIAMETER = 18;
    private static final int MAX_BADGE_TEXT_SIZE = 11;
    private Image image;
    private String text;
    private String badgeValue;
    private Color textColor;
    private Color backgroundColor;
    private Color borderColor;
    private Color badgeForeground;
    private Color badgeBackground;
    private final Font badgeFont = SWTGraphicUtil.buildFontFrom((Control)this, (int)0, (int)8);
    private Font boldFont;
    private int horizontalLocation;
    private int verticalLocation;
    private GC gc;
    private int left;
    private int top;
    private Point buttonSize;
    private Point textSizeCache;
    private Point badgeTextSizeCache;

    public BadgedLabel(Composite parent, int style) {
        super(parent, BadgedLabel.checkStyle(style) | 0x20000000);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.badgeFont);
        this.boldFont = SWTGraphicUtil.buildFontFrom((Control)this, (int)1);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.boldFont);
        this.horizontalLocation = (this.getStyle() & 0x4000) != 0 ? 16384 : 131072;
        this.verticalLocation = (this.getStyle() & 0x80) != 0 ? 128 : 1024;
        this.initDefaultColors();
        this.addListener(9, e -> this.onPaint(e));
    }

    private static int checkStyle(int style) {
        int mask = 150656;
        int newStyle = style & 0x24C80;
        return newStyle |= 0x20000000;
    }

    private void initDefaultColors() {
        this.textColor = this.getDisplay().getSystemColor(2);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.textColor);
        this.backgroundColor = new Color((Device)this.getDisplay(), 247, 247, 247);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.backgroundColor);
        this.borderColor = new Color((Device)this.getDisplay(), 204, 204, 204);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.borderColor);
        this.badgeForeground = this.getDisplay().getSystemColor(1);
        this.badgeBackground = new Color((Device)this.getDisplay(), 0, 123, 255);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.badgeBackground);
    }

    private void onPaint(Event e) {
        this.gc = e.gc;
        this.gc.setAntialias(1);
        this.gc.setAdvanced(true);
        Color previousForeground = this.getForeground();
        Color previousBackground = this.getBackground();
        this.drawButton();
        this.drawBadge();
        this.gc.setForeground(previousForeground);
        this.gc.setBackground(previousBackground);
    }

    private void drawButton() {
        this.drawShape();
        this.drawImageAndText();
    }

    private void drawShape() {
        this.buttonSize = this.computeButtonSize();
        Rectangle area = this.getClientArea();
        this.left = 7;
        if (this.horizontalLocation == 16384) {
            this.left += 7;
        }
        this.top = 7;
        if (this.verticalLocation == 128) {
            this.top += 7;
        }
        this.gc.setBackground(this.backgroundColor);
        this.gc.fillRoundRectangle(this.left, this.top, Math.max(this.buttonSize.x, area.width - 14) - this.left, Math.max(this.buttonSize.y, area.height - 14) - this.top, 3, 3);
        this.gc.setForeground(this.borderColor);
        this.gc.drawRoundRectangle(this.left, this.top, Math.max(this.buttonSize.x, area.width - 14) - this.left, Math.max(this.buttonSize.y, area.height - 14) - this.top, 3, 3);
    }

    private void drawImageAndText() {
        int textWidth = this.getTextSizeInPixels().x;
        int textDelta = 0;
        Rectangle area = this.getClientArea();
        int width = Math.max(this.buttonSize.x, area.width - 14) - this.left;
        int height = Math.max(this.buttonSize.y, area.height - 14) - this.top;
        if (this.image != null) {
            Point imageSize = new Point(this.image.getBounds().width, this.image.getBounds().height);
            int wholeLength = imageSize.x;
            if (textWidth != 0) {
                wholeLength += 4 + this.getTextSizeInPixels().x;
            }
            int x = this.left + (width - wholeLength) / 2;
            this.gc.drawImage(this.image, x, this.top + (height - imageSize.y) / 2);
            textDelta = x + imageSize.x + 4;
        }
        if (textWidth == 0) {
            return;
        }
        int x = textDelta == 0 ? this.left + (width - textWidth) / 2 : textDelta;
        this.gc.setFont(this.boldFont);
        this.gc.setForeground(this.isEnabled() ? this.textColor : this.getDisplay().getSystemColor(15));
        this.gc.drawText(this.text, x, this.top + (height - this.getTextSizeInPixels().y) / 2, false);
    }

    private Point getTextSizeInPixels() {
        if (this.text == null || this.text.equals("")) {
            return new Point(0, 0);
        }
        if (this.textSizeCache != null) {
            return this.textSizeCache;
        }
        GC gc = new GC((Drawable)this);
        gc.setFont(this.boldFont);
        this.textSizeCache = gc.stringExtent(this.text);
        gc.dispose();
        return this.textSizeCache;
    }

    private void drawBadge() {
        int y;
        int x;
        if (this.badgeValue == null || this.badgeValue.equals("")) {
            return;
        }
        this.gc.setForeground(this.badgeForeground);
        this.gc.setBackground(this.badgeBackground);
        Point textSize = this.getBadgeTextSizeInPixels();
        Rectangle area = this.getClientArea();
        int width = Math.max(this.buttonSize.x, area.width - 14) - this.left;
        int height = Math.max(this.buttonSize.y, area.height - 14) - this.top;
        int badgeWith = textSize.x > 11 ? textSize.x + 5 : 18;
        switch (this.horizontalLocation) {
            case 131072: {
                x = this.left + width - badgeWith / 2;
                break;
            }
            case 16384: {
                x = this.left - badgeWith / 2;
                break;
            }
            default: {
                return;
            }
        }
        switch (this.verticalLocation) {
            case 128: {
                y = this.top - 9;
                break;
            }
            case 1024: {
                y = this.top + height - 9;
                break;
            }
            default: {
                return;
            }
        }
        if (textSize.x > 11) {
            this.gc.fillRoundRectangle(x, y, badgeWith, 18, 3, 3);
        } else {
            this.gc.fillOval(x, y, 18, 18);
        }
        this.gc.setFont(this.badgeFont);
        this.gc.drawText(this.badgeValue, x + (badgeWith - textSize.x) / 2, y + (18 - textSize.y) / 2, true);
    }

    private Point getBadgeTextSizeInPixels() {
        if (this.badgeTextSizeCache != null) {
            return this.badgeTextSizeCache;
        }
        GC gc = new GC((Drawable)this);
        gc.setFont(this.badgeFont);
        this.badgeTextSizeCache = gc.stringExtent(this.badgeValue);
        gc.dispose();
        return this.badgeTextSizeCache;
    }

    public void setPredefinedColor(int color) {
        this.checkWidget();
        this.badgeForeground = this.getDisplay().getSystemColor(1);
        switch (color) {
            case 9: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 0, 123, 255);
                break;
            }
            case 15: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 108, 117, 125);
                break;
            }
            case 5: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 40, 167, 69);
                break;
            }
            case 3: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 220, 53, 69);
                break;
            }
            case 7: {
                this.badgeForeground = this.getDisplay().getSystemColor(2);
                this.badgeBackground = new Color((Device)this.getDisplay(), 255, 193, 7);
                break;
            }
            case 13: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 23, 162, 184);
                break;
            }
            default: {
                this.badgeBackground = new Color((Device)this.getDisplay(), 52, 58, 64);
            }
        }
        SWTGraphicUtil.addDisposer((Widget)this, (Resource)this.badgeBackground);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (this.image == null && this.text == null) {
            return super.computeSize(wHint, hHint, changed);
        }
        Point buttonSize = this.computeButtonSize();
        int width = buttonSize.x;
        int height = buttonSize.y;
        return new Point(Math.max(width += 21, wHint), Math.max(height += 21, hHint));
    }

    private Point computeButtonSize() {
        int width = 16;
        int height = 16;
        if (this.image != null && this.text == null) {
            Rectangle bounds = this.image.getBounds();
            width += bounds.width;
            height = Math.max(height, bounds.height + 16);
        } else if (this.text != null && this.image == null) {
            Point extent = this.getTextSizeInPixels();
            width = Math.max(width, extent.x + 16);
            height += extent.y;
        } else {
            Rectangle bounds = this.image.getBounds();
            Point extent = this.getTextSizeInPixels();
            width += bounds.width + 8 + extent.x + 16;
            int maxTextAndImageHeight = Math.max(extent.y, bounds.y);
            height = Math.max(height, maxTextAndImageHeight + 16);
        }
        return new Point(width, height);
    }

    public Color getBackgroundColor() {
        this.checkWidget();
        return this.backgroundColor;
    }

    public Color getBadgeBackground() {
        this.checkWidget();
        return this.badgeBackground;
    }

    public Color getBadgeForeground() {
        this.checkWidget();
        return this.badgeForeground;
    }

    public String getBadgeValue() {
        this.checkWidget();
        return this.badgeValue;
    }

    public Color getBorderColor() {
        this.checkWidget();
        return this.borderColor;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public Color getTextColor() {
        this.checkWidget();
        return this.textColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.checkWidget();
        this.checkColor(backgroundColor);
        this.backgroundColor = backgroundColor;
    }

    private void checkColor(Color color) {
        if (color == null) {
            SWT.error((int)4);
        }
        if (color.isDisposed()) {
            SWT.error((int)5);
        }
    }

    public void setBadgeBackground(Color badgeBackground) {
        this.checkWidget();
        this.checkColor(badgeBackground);
        this.badgeBackground = badgeBackground;
    }

    public void setBadgeForeground(Color badgeForeground) {
        this.checkWidget();
        this.checkColor(badgeForeground);
        this.badgeForeground = badgeForeground;
    }

    public void setBadgeValue(String value) {
        this.checkWidget();
        if (value == null) {
            SWT.error((int)4);
        }
        this.badgeValue = value;
        this.badgeTextSizeCache = null;
    }

    public void setBorderColor(Color borderColor) {
        this.checkWidget();
        this.checkColor(borderColor);
        this.borderColor = borderColor;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textSizeCache = null;
        this.boldFont.dispose();
        this.boldFont = SWTGraphicUtil.buildFontFrom((Control)this, (int)1);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setText(String text) {
        this.checkWidget();
        this.textSizeCache = null;
        this.text = text;
    }

    public void setTextColor(Color textColor) {
        this.checkWidget();
        this.checkColor(textColor);
        this.textColor = textColor;
    }
}

