/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.cdatetime.css;

import org.eclipse.e4.ui.css.core.css2.CSS2FontHelper;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.nebula.widgets.cdatetime.css.CDateTimeElement;
import org.eclipse.nebula.widgets.cdatetime.css.CSSEngineHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class CDateTimePropertyHandler
implements ICSSPropertyHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Color newColor;
        CDateTime cdt = (CDateTime)((CDateTimeElement)((Object)element)).getNativeWidget();
        if ("cdt-background-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setBackground(newColor);
        }
        if ("cdt-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setForeground(newColor);
        }
        if ("cdt-font".equals(property)) {
            this.applyCSSPropertyFont((Control)cdt, value, false);
        }
        if ("cdt-font-style".equals(property)) {
            this.applyCSSPropertyStyle((Control)cdt, value, false);
        }
        if ("cdt-font-size".equals(property)) {
            this.applyCSSPropertySize((Control)cdt, value, false);
        }
        if ("cdt-font-weight".equals(property)) {
            this.applyCSSPropertyWeight((Control)cdt, value, false);
        }
        if ("cdt-font-family".equals(property)) {
            this.applyCSSPropertyFamily((Control)cdt, value, false);
        }
        if ("cdt-picker-background-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerBackgroundColor(newColor);
        }
        if ("cdt-picker-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerForegroundColor(newColor);
        }
        if ("cdt-picker-font".equals(property)) {
            this.applyCSSPropertyFont((Control)cdt, value, true);
        }
        if ("cdt-picker-font-style".equals(property)) {
            this.applyCSSPropertyStyle((Control)cdt, value, true);
        }
        if ("cdt-picker-font-size".equals(property)) {
            this.applyCSSPropertySize((Control)cdt, value, true);
        }
        if ("cdt-picker-font-weight".equals(property)) {
            this.applyCSSPropertyWeight((Control)cdt, value, true);
        }
        if ("cdt-picker-font-family".equals(property)) {
            this.applyCSSPropertyFamily((Control)cdt, value, true);
        }
        if ("cdt-picker-active-day-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerActiveDayColor(newColor);
        }
        if ("cdt-picker-inactive-day-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerInactiveDayColor(newColor);
        }
        if ("cdt-picker-today-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerTodayColor(newColor);
        }
        if ("cdt-picker-minutes-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerMinutesColor(newColor);
        }
        if ("cdt-picker-minutes-background-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setPickerMinutesBackgroundColor(newColor);
        }
        if ("cdt-button-hover-border-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setButtonHoverBorderColor(newColor);
        }
        if ("cdt-button-hover-background-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setButtonHoverBackgroundColor(newColor);
        }
        if ("cdt-button-selected-border-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setButtonSelectedBorderColor(newColor);
        }
        if ("cdt-button-selected-background-color".equals(property)) {
            newColor = (Color)engine.convert(value, Color.class, (Object)cdt.getDisplay());
            cdt.setButtonSelectedBackgroundColor(newColor);
        }
        return true;
    }

    private void applyCSSPropertyFont(Control widget, CSSValue value, boolean picker) throws Exception {
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            int length = valueList.getLength();
            int i = 0;
            while (i < length) {
                CSSValue value2 = valueList.item(i);
                if (value2.getCssValueType() == 1) {
                    String cssProp = CSS2FontHelper.getCSSFontPropertyName((CSSPrimitiveValue)((CSSPrimitiveValue)value2));
                    if (cssProp.equals("font-family")) {
                        this.applyCSSPropertyFamily(widget, value2, picker);
                    } else if (cssProp.equals("font-size")) {
                        this.applyCSSPropertySize(widget, value2, picker);
                    } else if (cssProp.equals("font-weight") && ("bold".equals(value2.getCssText()) || "bolder".equals(value2.getCssText()))) {
                        this.applyCSSPropertyWeight(widget, value2, picker);
                    } else if (cssProp.equals("font-style") && ("italic".equals(value2.getCssText()) || "oblique".equals(value2.getCssText()))) {
                        this.applyCSSPropertyStyle(widget, value2, picker);
                    }
                }
                ++i;
            }
        }
    }

    private void applyCSSPropertyStyle(Control widget, CSSValue value, boolean picker) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean modified = false;
            if ("italic".equals(value.getCssText()) || "oblique".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 2) != 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 2);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 2) == 2;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFD);
                }
            }
            if (modified) {
                if (picker) {
                    this.applyFontForPicker((CDateTime)widget, fd);
                } else {
                    this.applyFont(widget, fd);
                }
            }
        }
    }

    private void applyFont(Control widget, FontData fd) {
        if (widget.getFont() != null && !widget.getFont().equals((Object)widget.getDisplay().getSystemFont())) {
            widget.getFont().dispose();
        }
        Font newFont = new Font((Device)widget.getDisplay(), fd);
        widget.setFont(newFont);
        widget.addListener(12, e -> {
            if (newFont != null && !newFont.isDisposed()) {
                newFont.dispose();
            }
        });
    }

    private void applyFontForPicker(CDateTime widget, FontData fd) {
        if (widget.getPickerFont() != null && !widget.getPickerFont().equals((Object)widget.getDisplay().getSystemFont())) {
            widget.getPickerFont().dispose();
        }
        Font newFont = new Font((Device)widget.getDisplay(), fd);
        widget.setPickerFont(newFont);
        widget.addListener(12, e -> {
            if (newFont != null && !newFont.isDisposed()) {
                newFont.dispose();
            }
        });
    }

    private void applyCSSPropertySize(Control widget, CSSValue value, boolean picker) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData(widget);
            Measure m = (Measure)value;
            int newSize = Math.round(m.getFloatValue((short)0));
            boolean bl = modified = fd.getHeight() != newSize;
            if (modified) {
                fd.setHeight(newSize);
                if (picker) {
                    this.applyFontForPicker((CDateTime)widget, fd);
                } else {
                    this.applyFont(widget, fd);
                }
            }
        }
    }

    private void applyCSSPropertyWeight(Control widget, CSSValue value, boolean picker) throws Exception {
        if (value.getCssValueType() == 1) {
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean modified = false;
            if ("bold".equals(value.getCssText()) || "bolder".equals(value.getCssText())) {
                boolean bl = modified = (fd.getStyle() & 1) != 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 1);
                }
            } else {
                boolean bl = modified = (fd.getStyle() & 1) == 1;
                if (modified) {
                    fd.setStyle(fd.getStyle() | 0xFFFFFFFE);
                }
            }
            if (modified) {
                if (picker) {
                    this.applyFontForPicker((CDateTime)widget, fd);
                } else {
                    this.applyFont(widget, fd);
                }
            }
        }
    }

    private void applyCSSPropertyFamily(Control widget, CSSValue value, boolean picker) throws Exception {
        if (value.getCssValueType() == 1) {
            boolean modified;
            FontData fd = CSSEngineHelper.getFontData(widget);
            boolean bl = modified = !fd.getName().equals(value.getCssText());
            if (modified) {
                fd.setName(value.getCssText());
                if (picker) {
                    this.applyFontForPicker((CDateTime)widget, fd);
                } else {
                    this.applyFont(widget, fd);
                }
            }
        }
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

