/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.chips;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.chips.CloseEvent;
import org.eclipse.nebula.widgets.chips.CloseListener;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Chips
extends Canvas {
    private static final int CLOSE_CIRCLE_RAY = 7;
    private Color hoverForeground;
    private Color hoverBackground;
    private Color closeButtonForeground;
    private Color closeButtonBackground;
    private Color closeButtonHoverForeground;
    private Color closeButtonHoverBackground;
    private Color pushedStateForeground;
    private Color pushedStateBackground;
    private Color borderColor;
    private Color hoverBorderColor;
    private Color pushedStateBorderColor;
    private Color chipsBackground;
    private String text;
    private Image image;
    private Image pushImage;
    private Image hoverImage;
    private boolean selection;
    private final boolean isCheck;
    private final boolean isPush;
    private final boolean isClose;
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private final List<CloseListener> closeListeners = new ArrayList<CloseListener>();
    private boolean cursorInside;
    private Point closeCenter;

    public Chips(Composite parent, int style) {
        super(parent, Chips.checkStyle(style));
        this.initDefaultColors();
        this.text = "";
        this.isCheck = (this.getStyle() & 0x20) != 0;
        this.isPush = (this.getStyle() & 8) != 0;
        this.isClose = (this.getStyle() & 0x40) != 0;
        this.addListener(9, e -> {
            GC gc = e.gc;
            gc.setFont(this.getFont());
            gc.setAdvanced(true);
            gc.setTextAntialias(1);
            gc.setAntialias(1);
            Color previousForeground = gc.getForeground();
            Color previousBackground = gc.getBackground();
            int x = this.drawBackground(gc);
            this.drawWidgetBorder(gc);
            if (this.isCheck && this.selection) {
                x = this.drawCheck(gc, x);
            }
            if (this.image != null) {
                x = this.drawImage(gc, x);
            }
            if (this.text != null) {
                x = this.drawText(gc, x);
            }
            if (this.isClose) {
                this.drawClose(gc, x);
            }
            gc.setBackground(previousBackground);
            gc.setForeground(previousForeground);
        });
        this.addListener(6, e -> {
            boolean bl = this.cursorInside = this.isPush || this.isCheck || this.isClose;
            if (this.cursorInside) {
                this.setCursor(this.getDisplay().getSystemCursor(21));
            }
            this.redraw();
        });
        this.addListener(7, e -> {
            this.cursorInside = false;
            if (this.isPush || this.isCheck || this.isClose) {
                this.setCursor(this.getDisplay().getSystemCursor(0));
            }
            this.redraw();
        });
        this.addListener(4, e -> {
            float dist;
            if (!(this.isClose || this.isCheck || this.isPush)) {
                return;
            }
            if (this.isClose && (dist = (float)Math.sqrt((e.x - this.closeCenter.x) * (e.x - this.closeCenter.x) + (e.y - this.closeCenter.y) * (e.y - this.closeCenter.y))) < 7.0f) {
                CloseEvent event = new CloseEvent(e);
                for (CloseListener listener : this.closeListeners) {
                    listener.onClose(event);
                    if (!event.doit) break;
                }
            }
            this.setSelection(!this.selection);
            SelectionEvent event = new SelectionEvent(e);
            for (SelectionListener listener : this.selectionListeners) {
                listener.widgetSelected(event);
                if (!event.doit) break;
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 104;
        int newStyle = style & 0x68;
        return newStyle |= 0x20000000;
    }

    private int drawBackground(GC gc) {
        Rectangle rect = this.getClientArea();
        Color color = this.determineBackgroundColor();
        gc.setBackground(color);
        gc.fillRoundRectangle(0, 0, rect.width, rect.height, rect.height, rect.height);
        return rect.height / 2 + 2;
    }

    private void drawWidgetBorder(GC gc) {
        Rectangle rect = this.getClientArea();
        Color color = this.borderColor;
        if (this.cursorInside) {
            color = this.hoverBorderColor;
        } else if (this.isPush && this.selection) {
            color = this.pushedStateBorderColor;
        }
        if (color == null) {
            return;
        }
        gc.setForeground(color);
        gc.drawRoundRectangle(0, 0, rect.width - 2, rect.height - 2, rect.height, rect.height);
    }

    private Color determineBackgroundColor() {
        if (this.cursorInside) {
            return this.hoverBackground == null ? this.getBackground() : this.hoverBackground;
        }
        if (this.isPush && this.selection) {
            return this.pushedStateBackground == null ? this.getBackground() : this.pushedStateBackground;
        }
        return this.getChipsBackground() == null ? this.getBackground() : this.getChipsBackground();
    }

    private int drawCheck(GC gc, int x) {
        Color foreground = null;
        if (this.cursorInside) {
            foreground = this.hoverForeground;
        } else if (this.isPush && this.selection) {
            foreground = this.pushedStateForeground;
        }
        foreground = foreground == null ? this.getForeground() : foreground;
        gc.setForeground(foreground);
        gc.setLineWidth(2);
        Rectangle rect = this.getClientArea();
        int centerX = x + 4 + 7;
        int centerY = (rect.height - 14) / 2 + 7;
        gc.drawLine(x + 6, centerY, x + 9, centerY + 4);
        gc.drawLine(x + 9, centerY + 4, centerX + 4, centerY - 3);
        return x + 16;
    }

    private int drawImage(GC gc, int x) {
        Image img = this.image;
        if (this.cursorInside) {
            Image image = img = this.hoverImage == null ? img : this.hoverImage;
        }
        if (this.isPush && this.selection) {
            img = this.pushImage == null ? img : this.pushImage;
        }
        Rectangle rect = this.getClientArea();
        gc.drawImage(img, x + 2, (rect.height - img.getBounds().height) / 2);
        return x + 4 + img.getBounds().width;
    }

    private int drawText(GC gc, int x) {
        Point textSize = gc.stringExtent(this.text);
        Color color = null;
        if (this.cursorInside) {
            color = this.hoverForeground;
        } else if (this.isPush && this.selection) {
            color = this.pushedStateForeground;
        }
        color = color == null ? this.getForeground() : color;
        gc.setForeground(color);
        gc.drawText(this.text, x + 2, (this.getClientArea().height - textSize.y) / 2, true);
        return x + 2 + textSize.x;
    }

    private void drawClose(GC gc, int x) {
        Color foreground = this.cursorInside ? this.closeButtonHoverForeground : this.closeButtonForeground;
        Color background = this.cursorInside ? this.closeButtonHoverBackground : this.closeButtonBackground;
        Rectangle rect = this.getClientArea();
        gc.setBackground(background);
        gc.setForeground(foreground);
        this.closeCenter = new Point(x + 4 + 7, (rect.height - 14) / 2 + 7);
        gc.fillOval(x + 4, (rect.height - 14) / 2, 14, 14);
        gc.setLineWidth(2);
        gc.drawLine(this.closeCenter.x - 3, this.closeCenter.y - 3, this.closeCenter.x + 3, this.closeCenter.y + 3);
        gc.drawLine(this.closeCenter.x + 3, this.closeCenter.y - 3, this.closeCenter.x - 3, this.closeCenter.y + 3);
    }

    private void initDefaultColors() {
        this.setForeground(this.getDisplay().getSystemColor(2));
        this.chipsBackground = SWTGraphicUtil.getColorSafely((int)224, (int)224, (int)224);
        this.hoverForeground = SWTGraphicUtil.getColorSafely((int)62, (int)28, (int)96);
        this.hoverBackground = SWTGraphicUtil.getColorSafely((int)214, (int)214, (int)214);
        this.closeButtonForeground = SWTGraphicUtil.getColorSafely((int)229, (int)229, (int)229);
        this.closeButtonBackground = SWTGraphicUtil.getColorSafely((int)100, (int)100, (int)100);
        this.closeButtonHoverForeground = SWTGraphicUtil.getColorSafely((int)214, (int)214, (int)214);
        this.closeButtonHoverBackground = SWTGraphicUtil.getColorSafely((int)64, (int)64, (int)64);
        this.pushedStateForeground = SWTGraphicUtil.getColorSafely((int)224, (int)224, (int)224);
        this.pushedStateBackground = this.getDisplay().getSystemColor(2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 20;
        if (this.image != null) {
            Rectangle imageSize = this.image.getBounds();
            width += 4 + imageSize.width;
            height = Math.max(height, imageSize.height + 4);
        }
        if (this.text != null) {
            GC gc = new GC((Drawable)this);
            Point textSize = gc.stringExtent(this.text);
            width += 4 + textSize.x;
            height = Math.max(height, textSize.y);
            gc.dispose();
        }
        if (this.isCheck && this.selection || this.isClose) {
            width += 20;
        }
        return new Point(Math.max(width += Math.max(height, hHint), wHint), Math.max(height, hHint));
    }

    public void addCloseListener(CloseListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeListeners.add(listener);
    }

    public void addListener(int eventType, final Listener listener) {
        if (eventType == 13) {
            this.selectionListeners.add(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.widgetSelection(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelection(e);
                }

                private void widgetSelection(SelectionEvent e) {
                    Event event = new Event();
                    event.widget = Chips.this;
                    event.display = Chips.this.getDisplay();
                    event.type = 13;
                    listener.handleEvent(event);
                }
            });
            return;
        }
        if (eventType == 21) {
            this.closeListeners.add(new CloseListener(){

                @Override
                public void onClose(CloseEvent e) {
                    Event event = new Event();
                    event.widget = Chips.this;
                    event.display = Chips.this.getDisplay();
                    event.type = 21;
                    listener.handleEvent(event);
                }
            });
            return;
        }
        super.addListener(eventType, listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.add(listener);
    }

    public void removeCloseListener(CloseListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.closeListeners.remove(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.selectionListeners.remove(listener);
    }

    public Color getChipsBackground() {
        this.checkWidget();
        return this.chipsBackground;
    }

    public Color getHoverForeground() {
        this.checkWidget();
        return this.hoverForeground;
    }

    public Color getHoverBackground() {
        this.checkWidget();
        return this.hoverBackground;
    }

    public Color getCloseButtonForeground() {
        this.checkWidget();
        return this.closeButtonForeground;
    }

    public Color getCloseButtonBackground() {
        this.checkWidget();
        return this.closeButtonBackground;
    }

    public Color getCloseButtonHoverForeground() {
        this.checkWidget();
        return this.closeButtonHoverForeground;
    }

    public Color getCloseButtonHoverBackground() {
        this.checkWidget();
        return this.closeButtonHoverBackground;
    }

    public Color getPushedStateForeground() {
        this.checkWidget();
        return this.pushedStateForeground;
    }

    public Color getPushedStateBackground() {
        this.checkWidget();
        return this.pushedStateBackground;
    }

    public Color getBorderColor() {
        this.checkWidget();
        return this.borderColor;
    }

    public Color getHoverBorderColor() {
        this.checkWidget();
        return this.hoverBorderColor;
    }

    public Color getPushedStateBorderColor() {
        this.checkWidget();
        return this.pushedStateBorderColor;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image getPushImage() {
        this.checkWidget();
        return this.pushImage;
    }

    public Image getHoverImage() {
        this.checkWidget();
        return this.hoverImage;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void setChipsBackground(Color chipsBackground) {
        this.checkWidget();
        this.chipsBackground = chipsBackground;
    }

    public void setHoverForeground(Color hoverForeground) {
        this.checkWidget();
        this.hoverForeground = hoverForeground;
    }

    public void setHoverBackground(Color hoverBackground) {
        this.checkWidget();
        this.hoverBackground = hoverBackground;
    }

    public void setCloseButtonForeground(Color closeButtonForeground) {
        this.checkWidget();
        this.closeButtonForeground = closeButtonForeground;
    }

    public void setCloseButtonBackground(Color closeButtonBackground) {
        this.checkWidget();
        this.closeButtonBackground = closeButtonBackground;
    }

    public void setCloseButtonHoverForeground(Color closeButtonHoverForeground) {
        this.checkWidget();
        this.closeButtonHoverForeground = closeButtonHoverForeground;
    }

    public void setCloseButtonHoverBackground(Color closeButtonHoverBackground) {
        this.checkWidget();
        this.closeButtonHoverBackground = closeButtonHoverBackground;
    }

    public void setPushedStateForeground(Color pushedStateForeground) {
        this.checkWidget();
        this.pushedStateForeground = pushedStateForeground;
    }

    public void setPushedStateBackground(Color pushedStateBackground) {
        this.checkWidget();
        this.pushedStateBackground = pushedStateBackground;
    }

    public void setBorderColor(Color borderColor) {
        this.checkWidget();
        this.borderColor = borderColor;
    }

    public void setHoverBorderColor(Color hoverBorderColor) {
        this.checkWidget();
        this.hoverBorderColor = hoverBorderColor;
    }

    public void setPushedStateBorderColor(Color pushedStateBorderColor) {
        this.checkWidget();
        this.pushedStateBorderColor = pushedStateBorderColor;
    }

    public void setText(String text) {
        this.checkWidget();
        this.text = text;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.image = image;
    }

    public void setPushImage(Image pushImage) {
        this.checkWidget();
        this.pushImage = pushImage;
    }

    public void setHoverImage(Image hoverImage) {
        this.checkWidget();
        this.hoverImage = hoverImage;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        this.selection = selected;
        if (this.isCheck) {
            this.getParent().layout(new Control[]{this});
        }
        this.redraw();
    }
}

