/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.ctreecombo.CTreeComboColumn;
import org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTreeCombo
extends Composite {
    Text text;
    Tree tree;
    Button arrow;
    Listener listener;
    Listener filter;
    Shell popup;
    boolean hasFocus;
    int visibleItemCount;
    Color foreground;
    Color background;
    Font font;
    List<CTreeComboItem> items;
    List<CTreeComboColumn> columns;
    List<TreeListener> treeListeners;
    private final TreeListener hookListener;

    static int checkStyle(int style) {
        int mask = 0x6800808;
        return 0x80000 | style & 0x6800808;
    }

    public CTreeCombo(Composite parent, int style) {
        style = CTreeCombo.checkStyle(style);
        super(parent, style);
        this.visibleItemCount = 5;
        this.items = new ArrayList<CTreeComboItem>();
        this.columns = new ArrayList<CTreeComboColumn>();
        this.treeListeners = new ArrayList<TreeListener>();
        this.hookListener = new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                e.item = (Widget)e.item.getData("org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem");
                e.widget = CTreeCombo.this;
                for (TreeListener l : CTreeCombo.this.treeListeners) {
                    l.treeCollapsed(e);
                }
            }

            public void treeExpanded(TreeEvent e) {
                e.item = (Widget)e.item.getData("org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem");
                e.widget = CTreeCombo.this;
                for (TreeListener l : CTreeCombo.this.treeListeners) {
                    l.treeExpanded(e);
                }
            }
        };
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text((Composite)this, textStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (CTreeCombo.this.popup == event.widget) {
                    CTreeCombo.this.popupEvent(event);
                    return;
                }
                if (CTreeCombo.this.text == event.widget) {
                    CTreeCombo.this.textEvent(event);
                    return;
                }
                if (CTreeCombo.this.tree == event.widget) {
                    CTreeCombo.this.treeEvent(event);
                    return;
                }
                if (CTreeCombo.this.arrow == event.widget) {
                    CTreeCombo.this.arrowEvent(event);
                    return;
                }
                if (CTreeCombo.this == event.widget) {
                    CTreeCombo.this.comboEvent(event);
                    return;
                }
                if (CTreeCombo.this.getShell() == event.widget) {
                    CTreeCombo.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CTreeCombo.this.isDisposed()) {
                                return;
                            }
                            CTreeCombo.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.filter = event -> {
            Shell shell = ((Control)event.widget).getShell();
            if (shell == this.getShell()) {
                this.handleFocus(16);
            }
        };
        int[] comboEvents = new int[]{12, 15, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], this.listener);
            ++i;
        }
        int[] textEvents = new int[]{14, 1, 2, 35, 24, 3, 4, 8, 37, 31, 15, 25};
        int i2 = 0;
        while (i2 < textEvents.length) {
            this.text.addListener(textEvents[i2], this.listener);
            ++i2;
        }
        int[] arrowEvents = new int[]{3, 4, 13, 15};
        int i3 = 0;
        while (i3 < arrowEvents.length) {
            this.arrow.addListener(arrowEvents[i3], this.listener);
            ++i3;
        }
        this.createPopup(null, null);
        this.initAccessible();
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return Character.toLowerCase(string.charAt(index));
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        this.treeListeners.add(listener);
    }

    private void adjustShellSize() {
        Point size = this.getSize();
        int itemCount = this.visibleItemCount;
        int itemHeight = this.tree.getItemHeight() * itemCount;
        Point listSize = this.tree.computeSize(-1, itemHeight, false);
        this.tree.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        Display display = this.getDisplay();
        Rectangle listRect = this.tree.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - listRect.width;
        }
        this.popup.setBounds(x, y, width, height);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 3: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(3, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 4: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(4, mouseEvent);
                event.doit = mouseEvent.doit;
                break;
            }
            case 13: {
                this.text.setFocus();
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.tree.clear(index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.tree.clearAll(all);
        this.text.setFont(this.text.getFont());
        this.text.setText("");
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.tree.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.tree = null;
                this.arrow = null;
                break;
            }
            case 15: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.tree) {
                    return;
                }
                if (this.isDropped()) {
                    this.tree.setFocus();
                    break;
                }
                this.text.setFocus();
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        TreeItem[] items = this.tree.getItems();
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int textWidth = gc.stringExtent((String)this.text.getText()).x;
        int i = 0;
        while (i < items.length) {
            textWidth = Math.max(gc.stringExtent((String)items[i].getText()).x, textWidth);
            ++i;
        }
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.tree.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(textSize.y, arrowSize.y + 5);
        width = Math.max(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    void createPopup(Collection<CTreeComboItem> items, CTreeComboItem selectedItem) {
        this.popup = new Shell(this.getShell(), 16392);
        int style = this.getStyle();
        int listStyle = 772;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        this.tree = new Tree((Composite)this.popup, listStyle);
        this.tree.addTreeListener(this.hookListener);
        if (this.font != null) {
            this.tree.setFont(this.font);
        }
        if (this.foreground != null) {
            this.tree.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.tree.setBackground(this.background);
        }
        int[] popupEvents = new int[]{21, 9, 27};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 12, 18, 17};
        int i2 = 0;
        while (i2 < listEvents.length) {
            this.tree.addListener(listEvents[i2], this.listener);
            ++i2;
        }
        for (CTreeComboColumn c : this.columns) {
            TreeColumn col = new TreeColumn(this.tree, 0);
            c.setRealTreeColumn(col);
        }
        if (items != null) {
            this.createTreeItems(items.toArray(new CTreeComboItem[0]));
        }
        if (selectedItem != null) {
            this.tree.setSelection(selectedItem.getRealTreeItem());
        }
    }

    private void createTreeItems(CTreeComboItem[] items) {
        CTreeComboItem[] cTreeComboItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CTreeComboItem item = cTreeComboItemArray[n2];
            TreeItem ti = new TreeItem(this.tree, item.getStyle());
            item.setRealTreeItem(ti);
            this.createTreeItems(item.getItems());
            ++n2;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.tree.deselectAll();
    }

    void dropDown(boolean drop) {
        TreeItem[] items;
        if (drop == this.isDropped() || !this.isVisible()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed() && this.isFocusControl()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            TreeItem[] s = this.tree.getSelection();
            CTreeComboItem selectionIndex = null;
            if (s.length > 0) {
                selectionIndex = (CTreeComboItem)((Object)s[0].getData("org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem"));
            }
            this.tree.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.tree = null;
            this.createPopup(this.items, selectionIndex);
        }
        if ((items = this.tree.getSelection()).length != 0) {
            this.tree.showItem(items[0]);
        }
        this.adjustShellSize();
        this.popup.setVisible(true);
        this.popup.setActive();
        if (this.isFocusControl()) {
            this.tree.setFocus();
        }
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    public CTreeComboColumn getColumn(int columnIndex) {
        this.checkWidget();
        return this.columns.get(columnIndex);
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.tree.getColumnCount();
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        return this.tree.getColumnOrder();
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public CTreeComboItem getItem(int index) {
        this.checkWidget();
        return this.items.get(index);
    }

    public CTreeComboItem getItem(Point p) {
        this.checkWidget();
        TreeItem item = this.tree.getItem(p);
        if (item != null) {
            item.getData("org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem");
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.tree.getItemCount();
    }

    public CTreeComboItem[] getItems() {
        this.checkWidget();
        return this.items.toArray(new CTreeComboItem[0]);
    }

    public CTreeComboItem[] getSelection() {
        this.checkWidget();
        TreeItem[] items = this.tree.getSelection();
        if (items.length > 0) {
            return new CTreeComboItem[]{(CTreeComboItem)((Object)items[0].getData("org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem"))};
        }
        return new CTreeComboItem[0];
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.tree || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    public int indexOf(CTreeComboItem item) {
        this.checkWidget();
        return this.tree.indexOf(item.getRealTreeItem());
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = CTreeCombo.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = CTreeCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = CTreeCombo.this._findMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = CTreeCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = CTreeCombo.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.tree.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = CTreeCombo.this.getToolTipText();
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getName(AccessibleEvent e) {
                e.result = CTreeCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = CTreeCombo.this.text.getCaretPosition();
            }

            public void getSelectionRange(AccessibleTextEvent e) {
                Point sel = CTreeCombo.this.text.getSelection();
                e.offset = sel.x;
                e.length = sel.y - sel.x;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = CTreeCombo.this.toControl(e.x, e.y);
                if (CTreeCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = CTreeCombo.this.getBounds();
                Point pt = CTreeCombo.this.getParent().toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = CTreeCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = CTreeCombo.this.text.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = CTreeCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    private CTreeComboItem internalGetSelection() {
        CTreeComboItem[] is = this.getSelection();
        if (is.length != 0) {
            return is[0];
        }
        return null;
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        this.text.setBounds(0, 0, width - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.tree.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                if (!"carbon".equals(SWT.getPlatform())) {
                    Point point = this.arrow.toControl(this.getDisplay().getCursorLocation());
                    Point size = this.arrow.getSize();
                    Rectangle rect = new Rectangle(0, 0, size.x, size.y);
                    if (rect.contains(point)) break;
                    this.dropDown(false);
                    break;
                }
                this.dropDown(false);
            }
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.tree.removeAll();
        this.items.clear();
        this.text.setFont(this.text.getFont());
        this.text.setText("");
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        this.treeListeners.remove(listener);
    }

    public void select(CTreeComboItem item) {
        this.checkWidget();
        if (item == null) {
            this.tree.deselectAll();
            this.text.setFont(this.text.getFont());
            this.text.setText("");
            return;
        }
        if (item != null && item != this.internalGetSelection()) {
            this.text.setFont(this.text.getFont());
            this.text.setText(item.getText());
            this.text.selectAll();
            this.tree.select(item.getRealTreeItem());
            this.tree.showSelection();
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.tree.setItemCount(count);
    }

    public void setSelection(CTreeComboItem[] newItems) {
        this.checkWidget();
        TreeItem[] items = new TreeItem[newItems.length];
        int i = 0;
        while (i < items.length) {
            items[i] = newItems[i].getRealTreeItem();
            ++i;
        }
        if (items.length == 0) {
            this.text.setFont(this.text.getFont());
            this.text.setText("");
        } else {
            this.text.setFont(this.text.getFont());
            this.text.setText(items[0].getText());
        }
        this.tree.setSelection(items);
    }

    public void showItem(CTreeComboItem item) {
        this.checkWidget();
        this.tree.showItem(item.getRealTreeItem());
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 14: {
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                this.notifyListeners(14, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                event.doit = e.doit;
                break;
            }
            case 35: {
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(35, e);
                break;
            }
            case 24: {
                this.tree.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(3, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(4, mouseEvent);
                if (this.isDisposed()) break;
                event.doit = mouseEvent.doit;
                if (!event.doit) break;
                if (event.button != 1) {
                    return;
                }
                if (this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 8: {
                Event mouseEvent = new Event();
                mouseEvent.button = event.button;
                mouseEvent.count = event.count;
                mouseEvent.stateMask = event.stateMask;
                mouseEvent.time = event.time;
                mouseEvent.x = event.x;
                mouseEvent.y = event.y;
                this.notifyListeners(8, mouseEvent);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: {
                        event.doit = this.traverse(8);
                        event.detail = 0;
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 25: {
                Event e = new Event();
                e.text = event.text;
                e.start = event.start;
                e.end = event.end;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(25, e);
                event.doit = e.doit;
            }
        }
    }

    void treeEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                CTreeComboItem selectionIndex = this.internalGetSelection();
                this.popup = null;
                this.tree = null;
                this.createPopup(this.items, selectionIndex);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                TreeItem[] items = this.tree.getSelection();
                if (items.length != 1) {
                    return;
                }
                if (items[0].getItemCount() != 0) {
                    return;
                }
                this.text.setFont(this.text.getFont());
                this.text.setText(items[0].getText());
                this.text.selectAll();
                this.tree.setSelection(items);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                if (event.item != null) {
                    e.data = event.item.getData();
                }
                this.notifyListeners(13, e);
                event.doit = e.doit;
                this.dropDown(false);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = this.text.traverse(event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDown(false);
                        }
                        return;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 18: {
                this.adjustShellSize();
                break;
            }
            case 17: {
                this.adjustShellSize();
            }
        }
    }
}

