/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class PTChooserEditor
extends PTEditor {
    private PTWidget widget;
    private Item item;
    private PTProperty property;

    @Override
    public ControlEditor render(PTWidget widget, Item item, PTProperty property) {
        this.widget = widget;
        this.item = item;
        this.property = property;
        if (item instanceof TableItem) {
            ((TableItem)item).setText(1, this.getTextFor(property));
        } else {
            ((TreeItem)item).setText(1, this.getTextFor(property));
        }
        Color bgColor = this.getBackgroundColor(property);
        if (bgColor != null) {
            if (item instanceof TableItem) {
                ((TableItem)item).setBackground(1, bgColor);
            }
            if (item instanceof TreeItem) {
                ((TreeItem)item).setBackground(1, bgColor);
            }
            SWTGraphicUtil.addDisposer((Widget)item, (Resource)bgColor);
        }
        Object editor = widget.getWidget() instanceof Table ? new TableEditor((Table)widget.getWidget()) : new TreeEditor((Tree)widget.getWidget());
        Composite buttonHolder = new Composite(widget.getWidget(), 0);
        FillLayout buttonHolderLayout = new FillLayout(256);
        buttonHolderLayout.marginHeight = 0;
        buttonHolderLayout.marginWidth = 0;
        buttonHolder.setLayout((Layout)buttonHolderLayout);
        this.createEraseButton(buttonHolder);
        this.createPlusButton(buttonHolder);
        buttonHolder.pack();
        editor.minimumWidth = buttonHolder.getSize().x;
        editor.horizontalAlignment = 131072;
        if (widget.getWidget() instanceof Table) {
            editor.setEditor((Control)buttonHolder, (TableItem)item, 1);
        } else {
            ((TreeEditor)editor).setEditor((Control)buttonHolder, (TreeItem)item, 1);
        }
        return editor;
    }

    private void createEraseButton(Composite buttonHolder) {
        Button eraseButton = new Button(buttonHolder, 8);
        eraseButton.setText(" X ");
        eraseButton.setToolTipText(ResourceManager.getLabel((String)"eraseProperty"));
        eraseButton.setEnabled(this.property.isEnabled());
        eraseButton.pack();
        eraseButton.addListener(13, event -> {
            this.property.setValue(null);
            if (this.item instanceof TableItem) {
                ((TableItem)this.item).setBackground(1, Display.getDefault().getSystemColor(25));
                ((TableItem)this.item).setText(1, this.getTextFor(this.property));
            }
            if (this.item instanceof TreeItem) {
                ((TreeItem)this.item).setBackground(1, Display.getDefault().getSystemColor(25));
                ((TreeItem)this.item).setText(1, this.getTextFor(this.property));
            }
        });
        eraseButton.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                PTChooserEditor.this.widget.updateDescriptionPanel(PTChooserEditor.this.property);
            }
        });
    }

    private void createPlusButton(Composite buttonHolder) {
        Button plusButton = new Button(buttonHolder, 8);
        plusButton.setText("...");
        plusButton.setToolTipText(ResourceManager.getLabel((String)"editProperty"));
        plusButton.setEnabled(this.property.isEnabled());
        plusButton.addListener(13, event -> this.openWindow(this.widget, this.item, this.property));
        plusButton.addListener(15, event -> this.widget.updateDescriptionPanel(this.property));
        plusButton.pack();
    }

    protected abstract void openWindow(PTWidget var1, Item var2, PTProperty var3);

    protected abstract String getTextFor(PTProperty var1);

    protected abstract Color getBackgroundColor(PTProperty var1);
}

