/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.oscilloscope.example;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.oscilloscope.multichannel.Oscilloscope;
import org.eclipse.nebula.widgets.oscilloscope.multichannel.OscilloscopeDispatcher;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Bundle;

public class OscilloscopeExampleTab
extends AbstractExampleTab {
    private static final String BUNDLE = "org.eclipse.nebula.widgets.oscilloscope.example";
    private Button serviceActive;
    private Spinner pulse;
    private Spinner delay;
    private Spinner lineWidth;
    private Button steady;
    private Spinner steadyPosition;
    private Oscilloscope oscilloscope;
    private Button scale;
    private Button mustFade;
    private Spinner fadeSpinner;
    private Button sound;
    private Button tailsizeMax;
    private Button connect;
    private Spinner tailSize;
    private Button tailsizeDefault;
    private Button tailsizeFill;
    private Combo imageCombo;
    private Combo activeSoundCombo;
    private Combo inactiveSoundCombo;
    private Button btnRandomSpikeEvery;
    private Button btnHeartbeatEveryPulse;
    private Button btnSine;
    private Button btnSquareWave;
    private Spinner progressionSpinner;
    private Button btnFollowProgression;
    private Button btnFollowProgression_1;
    private Spinner baseOffsetSpinner;

    public String[] createLinks() {
        String[] links = new String[]{};
        return links;
    }

    public Control createControl(Composite parent) {
        this.oscilloscope = new Oscilloscope(parent, 0);
        this.oscilloscope.setForeground(this.oscilloscope.getDisplay().getSystemColor(3));
        OscilloscopeDispatcher dispatcher = null;
        try {
            dispatcher = new OscilloscopeDispatcher(){
                private double value;
                private final double counter = 0.1;
                private final OscilloscopeDispatcher.SoundClip clipper = new OscilloscopeDispatcher.SoundClip((OscilloscopeDispatcher)this);
                final String path = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)"org.eclipse.nebula.widgets.oscilloscope.example")).getPath();
                final String HEARTBEAT = String.valueOf(this.path) + "/Heartbeat.wav";
                final String FLATLINE = String.valueOf(this.path) + "/Flatline.wav";
                final String BEEP = String.valueOf(this.path) + "/Beep.wav";
                private Image image;
                private Image image1;

                public void hookSetValues(int value) {
                    if (OscilloscopeExampleTab.this.btnSine.getSelection()) {
                        this.setSineValue(value);
                    }
                    if (OscilloscopeExampleTab.this.btnSquareWave.getSelection()) {
                        this.setSquareValue(value);
                    }
                    if (OscilloscopeExampleTab.this.btnRandomSpikeEvery.getSelection()) {
                        this.setRandomPulse(value);
                    }
                    if (OscilloscopeExampleTab.this.btnHeartbeatEveryPulse.getSelection()) {
                        this.setHeartBeat();
                    }
                }

                private void setHeartBeat() {
                    if (OscilloscopeExampleTab.this.sound.getSelection()) {
                        this.clipper.playClip(this.getActiveSoundfile(), 0);
                    }
                    this.getOscilloscope().setValues(0, Oscilloscope.HEARTBEAT);
                }

                public void setRandomPulse(int v) {
                    if (OscilloscopeExampleTab.this.sound.getSelection()) {
                        this.clipper.playClip(this.getActiveSoundfile(), 0);
                    }
                    this.getOscilloscope().setValue(0, 100 - new Random().nextInt(200));
                }

                public void setSineValue(int v) {
                    int i = 0;
                    while (i < this.getProgression()) {
                        int intValue;
                        this.value += 0.1;
                        if (this.value > Math.PI * 2) {
                            this.value = 0.0;
                        }
                        if ((intValue = (int)(Math.sin(this.value) * 100.0)) == 99 && OscilloscopeExampleTab.this.sound.getSelection()) {
                            this.clipper.playClip(this.getActiveSoundfile(), 0);
                        }
                        this.getOscilloscope().setValue(0, intValue);
                        if (!OscilloscopeExampleTab.this.btnFollowProgression.getSelection()) {
                            return;
                        }
                        ++i;
                    }
                }

                public void setSquareValue(int v) {
                    int i = 0;
                    while (i < this.getProgression()) {
                        int intValue;
                        this.value += 0.1;
                        if (this.value > Math.PI * 2) {
                            this.value = 0.0;
                        }
                        if ((intValue = (int)((Math.sin(this.value) + Math.sin(3.0 * this.value) / 3.0 + Math.sin(5.0 * this.value) / 5.0 + Math.sin(7.0 * this.value) / 7.0 + Math.sin(9.0 * this.value) / 9.0 + Math.sin(11.0 * this.value) / 11.0 + Math.sin(13.0 * this.value) / 13.0 + Math.sin(15.0 * this.value) / 15.0 + Math.sin(17.0 * this.value) / 17.0 + Math.sin(19.0 * this.value) / 19.0) * 100.0)) >= 90 && OscilloscopeExampleTab.this.sound.getSelection()) {
                            this.clipper.playClip(this.getActiveSoundfile(), 0);
                        }
                        this.getOscilloscope().setValue(0, intValue);
                        if (!OscilloscopeExampleTab.this.btnFollowProgression_1.getSelection()) {
                            return;
                        }
                        ++i;
                    }
                }

                public Oscilloscope getOscilloscope() {
                    return OscilloscopeExampleTab.this.oscilloscope;
                }

                public int getLineWidth() {
                    return OscilloscopeExampleTab.this.lineWidth.getSelection();
                }

                public int getProgression() {
                    return OscilloscopeExampleTab.this.progressionSpinner.getSelection();
                }

                public int getBaseOffset() {
                    return OscilloscopeExampleTab.this.baseOffsetSpinner.getSelection();
                }

                public void init() {
                }

                public int getPulse() {
                    return OscilloscopeExampleTab.this.pulse.getSelection();
                }

                public File getActiveSoundfile() {
                    if (OscilloscopeExampleTab.this.activeSoundCombo.getSelectionIndex() == -1) {
                        return null;
                    }
                    if (OscilloscopeExampleTab.this.activeSoundCombo.getItem(OscilloscopeExampleTab.this.activeSoundCombo.getSelectionIndex()).equals("Heartbeat")) {
                        return new File(this.HEARTBEAT);
                    }
                    if (OscilloscopeExampleTab.this.activeSoundCombo.getItem(OscilloscopeExampleTab.this.activeSoundCombo.getSelectionIndex()).equals("Beep")) {
                        return new File(this.BEEP);
                    }
                    return new File(this.FLATLINE);
                }

                public Color getActiveForegoundColor() {
                    return this.getOscilloscope().getForeground();
                }

                public int getDelayLoop() {
                    return OscilloscopeExampleTab.this.delay.getSelection();
                }

                public File getInactiveSoundfile() {
                    if (OscilloscopeExampleTab.this.inactiveSoundCombo.getSelectionIndex() == -1) {
                        return null;
                    }
                    if (OscilloscopeExampleTab.this.inactiveSoundCombo.getItem(OscilloscopeExampleTab.this.inactiveSoundCombo.getSelectionIndex()).equals("Heartbeat")) {
                        return new File(this.HEARTBEAT);
                    }
                    if (OscilloscopeExampleTab.this.inactiveSoundCombo.getItem(OscilloscopeExampleTab.this.inactiveSoundCombo.getSelectionIndex()).equals("Beep")) {
                        return new File(this.BEEP);
                    }
                    return new File(this.FLATLINE);
                }

                public boolean isTailSizeMax() {
                    return OscilloscopeExampleTab.this.tailsizeMax.getSelection();
                }

                public Image getBackgroundImage() {
                    int i;
                    byte[] bytes;
                    if (this.image == null) {
                        bytes = new byte[BACKGROUND_MONITOR.length];
                        i = 0;
                        while (i < BACKGROUND_MONITOR.length) {
                            bytes[i] = (byte)BACKGROUND_MONITOR[i];
                            ++i;
                        }
                        this.image = new Image(null, (InputStream)new ByteArrayInputStream(bytes));
                    }
                    if (this.image1 == null) {
                        bytes = new byte[BACKGROUND_MONITOR_SMALL.length];
                        i = 0;
                        while (i < BACKGROUND_MONITOR_SMALL.length) {
                            bytes[i] = (byte)BACKGROUND_MONITOR_SMALL[i];
                            ++i;
                        }
                        this.image1 = new Image(null, (InputStream)new ByteArrayInputStream(bytes));
                    }
                    if (OscilloscopeExampleTab.this.imageCombo.getItem(OscilloscopeExampleTab.this.imageCombo.getSelectionIndex()).equals("None")) {
                        return null;
                    }
                    if (OscilloscopeExampleTab.this.imageCombo.getItem(OscilloscopeExampleTab.this.imageCombo.getSelectionIndex()).equals("SMALL RASTER")) {
                        return this.image1;
                    }
                    return this.image;
                }

                public boolean isPercentage() {
                    return OscilloscopeExampleTab.this.scale.getSelection();
                }

                public boolean isServiceActive() {
                    return OscilloscopeExampleTab.this.serviceActive.getSelection();
                }

                public boolean isSoundRequired() {
                    if (!this.isServiceActive()) {
                        return OscilloscopeExampleTab.this.sound.getSelection();
                    }
                    return false;
                }

                public int getTailSize() {
                    if (OscilloscopeExampleTab.this.tailsizeMax.getSelection()) {
                        return -1;
                    }
                    if (OscilloscopeExampleTab.this.tailsizeFill.getSelection()) {
                        return -2;
                    }
                    if (OscilloscopeExampleTab.this.tailsizeDefault.getSelection()) {
                        return -3;
                    }
                    return OscilloscopeExampleTab.this.tailSize.getSelection();
                }

                public boolean isSteady() {
                    return OscilloscopeExampleTab.this.steady.getSelection();
                }

                public int getSteadyPosition() {
                    return OscilloscopeExampleTab.this.steadyPosition.getSelection();
                }

                public boolean getFade() {
                    return OscilloscopeExampleTab.this.mustFade.getSelection();
                }

                public int getTailFade() {
                    return OscilloscopeExampleTab.this.fadeSpinner.getSelection();
                }

                public boolean mustConnect() {
                    return OscilloscopeExampleTab.this.connect.getSelection();
                }
            };
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dispatcher.dispatch();
        return this.oscilloscope;
    }

    public void createParameters(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        this.getSettings(parent);
    }

    private Control getSettings(Composite parent) {
        ScrolledComposite group2 = new ScrolledComposite(parent, 768);
        group2.setExpandVertical(true);
        group2.setExpandHorizontal(true);
        Composite Inner = new Composite((Composite)group2, 0);
        Inner.setLayout((Layout)new GridLayout(1, false));
        Group grpSpeed = new Group(Inner, 0);
        grpSpeed.setText("Speed");
        grpSpeed.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        grpSpeed.setLayout((Layout)new GridLayout(4, false));
        Label lblServiceActive = new Label((Composite)grpSpeed, 0);
        lblServiceActive.setText("Service Active");
        this.serviceActive = new Button((Composite)grpSpeed, 32);
        this.serviceActive.addListener(13, e -> {
            if (this.serviceActive.getSelection()) {
                this.oscilloscope.setForeground(this.oscilloscope.getDisplay().getSystemColor(5));
            } else {
                this.oscilloscope.setForeground(this.oscilloscope.getDisplay().getSystemColor(3));
            }
        });
        this.serviceActive.setSelection(false);
        new Label((Composite)grpSpeed, 0);
        new Label((Composite)grpSpeed, 0);
        Label lblDrawEvery = new Label((Composite)grpSpeed, 0);
        lblDrawEvery.setText("Pulse");
        this.pulse = new Spinner((Composite)grpSpeed, 2048);
        this.pulse.setMaximum(500);
        this.pulse.setMinimum(1);
        this.pulse.setIncrement(1);
        this.pulse.setSelection(60);
        this.pulse.setToolTipText("Pulse");
        Label lblTicks = new Label((Composite)grpSpeed, 0);
        lblTicks.setText("ticks");
        new Label((Composite)grpSpeed, 0);
        Label lblRedrawDealy = new Label((Composite)grpSpeed, 0);
        lblRedrawDealy.setText("Redraw delay");
        this.delay = new Spinner((Composite)grpSpeed, 2048);
        this.delay.setMaximum(500);
        this.delay.setMinimum(1);
        this.delay.setIncrement(1);
        this.delay.setSelection(20);
        this.delay.setToolTipText("redraw delay in ms");
        Label lblMs = new Label((Composite)grpSpeed, 0);
        lblMs.setText("ms");
        new Label((Composite)grpSpeed, 0);
        Label lblProgression = new Label((Composite)grpSpeed, 0);
        lblProgression.setText("Progression");
        this.progressionSpinner = new Spinner((Composite)grpSpeed, 2048);
        this.progressionSpinner.setMaximum(100);
        this.progressionSpinner.setMinimum(1);
        this.progressionSpinner.setSelection(1);
        Label lblSteps = new Label((Composite)grpSpeed, 0);
        lblSteps.setText("steps");
        new Label((Composite)grpSpeed, 0);
        Group grpSignal = new Group(Inner, 0);
        grpSignal.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        grpSignal.setText("Signal");
        grpSignal.setLayout((Layout)new GridLayout(2, false));
        this.btnRandomSpikeEvery = new Button((Composite)grpSignal, 16);
        this.btnRandomSpikeEvery.setText("Random spike every pulse");
        new Label((Composite)grpSignal, 0);
        this.btnHeartbeatEveryPulse = new Button((Composite)grpSignal, 16);
        this.btnHeartbeatEveryPulse.setSelection(false);
        this.btnHeartbeatEveryPulse.setText("Heartbeat every pulse");
        this.btnHeartbeatEveryPulse.addListener(13, e -> {
            if (this.btnHeartbeatEveryPulse.getSelection()) {
                this.pulse.setSelection(60);
            }
        });
        new Label((Composite)grpSignal, 0);
        this.btnSine = new Button((Composite)grpSignal, 16);
        this.btnSine.addListener(13, e -> {
            if (this.btnSine.getSelection()) {
                this.pulse.setSelection(1);
                this.scale.setSelection(true);
            }
        });
        this.btnSine.setText("Round Wave (Sine)");
        this.btnFollowProgression = new Button((Composite)grpSignal, 32);
        this.btnFollowProgression.setText("follow progression");
        this.btnSquareWave = new Button((Composite)grpSignal, 16);
        this.btnSquareWave.addListener(13, e -> {
            if (this.btnSquareWave.getSelection()) {
                this.pulse.setSelection(1);
                this.scale.setSelection(true);
            }
        });
        this.btnSquareWave.setText("Square Wave");
        this.btnFollowProgression_1 = new Button((Composite)grpSignal, 32);
        this.btnFollowProgression_1.setText("follow progression");
        Group grpGraph = new Group(Inner, 0);
        grpGraph.setText("Graph");
        grpGraph.setLayout((Layout)new GridLayout(2, false));
        Label pixelSizeLabel = new Label((Composite)grpGraph, 0);
        pixelSizeLabel.setText("Line width");
        this.lineWidth = new Spinner((Composite)grpGraph, 2048);
        this.lineWidth.setMaximum(500);
        this.lineWidth.setMinimum(1);
        this.lineWidth.setSelection(1);
        this.lineWidth.setIncrement(1);
        Label lblSteady = new Label((Composite)grpGraph, 0);
        lblSteady.setText("Steady");
        this.steady = new Button((Composite)grpGraph, 32);
        this.steady.setSelection(false);
        Label lblPosition = new Label((Composite)grpGraph, 0);
        lblPosition.setText("Steady Position");
        this.steadyPosition = new Spinner((Composite)grpGraph, 2048);
        this.steadyPosition.setMaximum(1000);
        this.steadyPosition.setMinimum(-1);
        this.steadyPosition.setIncrement(10);
        this.steadyPosition.setSelection(140);
        this.steadyPosition.setToolTipText("steady position");
        Label lblBaseOffsetIn = new Label((Composite)grpGraph, 0);
        lblBaseOffsetIn.setText("Base Offset in %");
        this.baseOffsetSpinner = new Spinner((Composite)grpGraph, 2048);
        this.baseOffsetSpinner.setTextLimit(3);
        this.baseOffsetSpinner.setSelection(50);
        this.baseOffsetSpinner.setPageIncrement(1);
        Label lblScale = new Label((Composite)grpGraph, 0);
        lblScale.setText("Scale");
        this.scale = new Button((Composite)grpGraph, 32);
        this.scale.setToolTipText("If set to true then the values are treated as percentages of the\r\navailable space rather than absolute values. This will scale the\r\namplitudes if the control is resized.");
        this.scale.setSelection(false);
        Label lblBackgroundImage = new Label((Composite)grpGraph, 0);
        lblBackgroundImage.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblBackgroundImage.setText("Background Image");
        this.imageCombo = new Combo((Composite)grpGraph, 0);
        this.imageCombo.setItems(new String[]{"None", "RASTER", "SMALL RASTER"});
        this.imageCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.imageCombo.select(1);
        Group grpTail = new Group(Inner, 0);
        grpTail.setText("Tail");
        grpTail.setLayout((Layout)new GridLayout(4, false));
        Group grpTailsize = new Group((Composite)grpTail, 0);
        grpTailsize.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        grpTailsize.setText("Tail size");
        grpTailsize.setLayout((Layout)new GridLayout(2, false));
        Label lblTailsizedefault = new Label((Composite)grpTailsize, 0);
        lblTailsizedefault.setText("TAILSIZE_DEFAULT");
        this.tailsizeDefault = new Button((Composite)grpTailsize, 16);
        this.tailsizeDefault.setSelection(true);
        Label lblTailsizemax = new Label((Composite)grpTailsize, 0);
        lblTailsizemax.setText("TAILSIZE_MAX");
        this.tailsizeMax = new Button((Composite)grpTailsize, 16);
        this.tailsizeMax.setSelection(false);
        Label lblTailsizeFill = new Label((Composite)grpTailsize, 0);
        lblTailsizeFill.setText("TAILSIZE_FILL");
        this.tailsizeFill = new Button((Composite)grpTailsize, 16);
        Button label_1 = new Button((Composite)grpTailsize, 16);
        label_1.setText("Tailsize");
        this.tailSize = new Spinner((Composite)grpTailsize, 2048);
        this.tailSize.setToolTipText("tail size");
        this.tailSize.setMaximum(1000);
        this.tailSize.setMinimum(1);
        this.tailSize.setSelection(200);
        this.tailSize.setIncrement(10);
        Label label_2 = new Label((Composite)grpTail, 0);
        label_2.setSize(45, 15);
        label_2.setText("Connect");
        this.connect = new Button((Composite)grpTail, 32);
        this.connect.setSize(13, 16);
        this.connect.setToolTipText("connect head and tail \r\nif tailsize_max, steady and no fade");
        this.connect.setSelection(true);
        Label lblIfTailsizemaxAnd = new Label((Composite)grpTail, 0);
        lblIfTailsizemaxAnd.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        Label lblFade = new Label((Composite)grpTail, 0);
        lblFade.setText("Fade");
        this.mustFade = new Button((Composite)grpTail, 32);
        Label lblPercentage = new Label((Composite)grpTail, 0);
        lblPercentage.setText("Percentage");
        this.fadeSpinner = new Spinner((Composite)grpTail, 2048);
        this.fadeSpinner.setMinimum(1);
        this.fadeSpinner.setSelection(25);
        Group grpSound = new Group(Inner, 0);
        grpSound.setText("Sound");
        grpSound.setLayout((Layout)new GridLayout(2, false));
        Label lblSound_2 = new Label((Composite)grpSound, 0);
        lblSound_2.setText("Sound");
        this.sound = new Button((Composite)grpSound, 32);
        this.sound.setAlignment(131072);
        Label lblSound_1 = new Label((Composite)grpSound, 0);
        lblSound_1.setBounds(0, 0, 55, 15);
        lblSound_1.setText("Active Sound");
        this.activeSoundCombo = new Combo((Composite)grpSound, 0);
        this.activeSoundCombo.setItems(new String[]{"Heartbeat", "Beep"});
        this.activeSoundCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblInactiveSound = new Label((Composite)grpSound, 0);
        lblInactiveSound.setText("Inactive Sound");
        this.inactiveSoundCombo = new Combo((Composite)grpSound, 0);
        this.inactiveSoundCombo.setItems(new String[]{"Heartbeat", "Beep", "Flatline"});
        this.inactiveSoundCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        group2.setContent((Control)Inner);
        group2.setMinSize(Inner.computeSize(-1, -1));
        return group2;
    }
}

