/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.oscilloscope.multichannel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.oscilloscope.multichannel.OscilloscopeDispatcher;
import org.eclipse.nebula.widgets.oscilloscope.multichannel.OscilloscopeStackAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class Oscilloscope
extends Canvas {
    public static final int BASE_CENTER = 50;
    public static final int CURSOR_START_DEFAULT = 50;
    public static final int DEFAULT_HEIGHT = 100;
    public static final int DEFAULT_WIDTH = 180;
    public static final int[] HEARTBEAT;
    public static final int LINE_WIDTH_DEFAULT = 1;
    public static final int PROGRESSION_DEFAULT = 1;
    public static final int STEADYPOSITION_75PERCENT = -1;
    public static final int TAILFADE_DEFAULT = 25;
    public static final int TAILFADE_NONE = 0;
    public static final int TAILFADE_PERCENTAGE = 25;
    public static final int TAILSIZE_DEFAULT = -3;
    public static final int TAILSIZE_FILL = -2;
    public static final int TAILSIZE_MAX = -1;
    private Color bg;
    private final Data[] chan;
    private boolean paintBlock;
    private int width;
    private int gridSquareSize;
    private int gridLineWidth;
    private Color gridBackground;
    private Color gridForeground;

    static {
        int[] nArray = new int[28];
        nArray[0] = 2;
        nArray[1] = 10;
        nArray[2] = 2;
        nArray[3] = -16;
        nArray[4] = 16;
        nArray[5] = 44;
        nArray[6] = 49;
        nArray[7] = 44;
        nArray[8] = 32;
        nArray[9] = 14;
        nArray[10] = -16;
        nArray[11] = -38;
        nArray[12] = -49;
        nArray[13] = -47;
        nArray[14] = -32;
        nArray[15] = -10;
        nArray[16] = 8;
        nArray[17] = 6;
        nArray[18] = 6;
        nArray[19] = -2;
        nArray[20] = 6;
        nArray[21] = 4;
        nArray[22] = 2;
        nArray[25] = 6;
        nArray[26] = 8;
        nArray[27] = 6;
        HEARTBEAT = nArray;
    }

    public Oscilloscope(Composite parent, int style) {
        this(1, null, parent, style);
    }

    public Oscilloscope(int channels, Composite parent, int style) {
        this(channels, null, parent, style);
    }

    public Oscilloscope(int channels, OscilloscopeDispatcher dispatcher, Composite parent, int style) {
        super(parent, 0x20000000 | style);
        Color defaultGridForeground;
        Color defaultGridBackground;
        this.chan = new Data[channels];
        int i = 0;
        while (i < this.chan.length) {
            this.chan[i] = new Data();
            if (dispatcher == null) {
                this.chan[i].dispatcher = new OscilloscopeDispatcher(i, this);
            } else {
                this.chan[i].dispatcher = dispatcher;
                dispatcher.setOscilloscope(this);
            }
            this.bg = Display.getDefault().getSystemColor(2);
            this.setBackground(this.bg);
            this.chan[i].fg = Display.getDefault().getSystemColor(1);
            this.setTailSize(i, -3);
            ++i;
        }
        this.addListener(12, e -> this.widgetDisposed(e));
        this.addListener(9, e -> {
            if (!this.paintBlock) {
                this.paintControl(e);
            }
            this.paintBlock = false;
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
            }
        });
        this.addListener(10, e -> this.controlMoved(e));
        this.addListener(11, e -> {
            this.paintBlock = true;
            this.controlResized(e);
        });
        this.gridSquareSize = 20;
        this.gridLineWidth = 1;
        this.gridBackground = defaultGridBackground = new Color((Device)this.getDisplay(), 57, 52, 56);
        this.gridForeground = defaultGridForeground = new Color((Device)this.getDisplay(), 81, 96, 77);
        this.addListener(12, e -> {
            defaultGridBackground.dispose();
            defaultGridForeground.dispose();
        });
    }

    public synchronized void addStackListener(int channel, OscilloscopeStackAdapter listener) {
        if (this.chan[channel].stackListeners == null) {
            this.chan[channel].stackListeners = new ArrayList();
        }
        if (!this.chan[channel].stackListeners.contains(listener)) {
            this.chan[channel].stackListeners.add(listener);
        }
    }

    private Object[] calculate(int channel) {
        int c = channel;
        int[] line1 = null;
        int[] line2 = null;
        int splitPos = 0;
        int progress = 0;
        while (progress < this.getProgression(c)) {
            if (this.chan[c].stack.isEmpty() && this.chan[c].stackListeners != null) {
                this.notifyListeners(c);
            }
            splitPos = this.chan[c].tailSize * 4;
            if (!this.isSteady(c)) {
                Data data = this.chan[c];
                data.cursor = data.cursor + 1;
            }
            if (this.chan[c].cursor >= this.chan[c].width) {
                this.chan[c].cursor = 0;
            }
            int tailIndex = 1;
            line1 = new int[this.chan[c].tailSize * 4];
            line2 = new int[this.chan[c].tailSize * 4];
            ((Data)this.chan[c]).tail[((Data)this.chan[c]).tailSize] = this.transform(c, this.chan[c].width, this.chan[c].height, this.chan[c].stack.popNegate(0));
            int i = 0;
            while (i < this.chan[c].tailSize) {
                int posx = this.chan[c].cursor - this.chan[c].tailSize + i;
                int pos = i * 4;
                if (posx < 0) {
                    line1[pos] = (posx += this.chan[c].width) - 1;
                    line1[pos + 1] = this.getBase(c) + (this.isSteady(c) ? 0 : this.chan[c].tail[tailIndex - 1]);
                    line1[pos + 2] = posx;
                    line1[pos + 3] = this.getBase(c) + (this.isSteady(c) ? 0 : this.chan[c].tail[tailIndex]);
                } else {
                    if (splitPos == this.chan[c].tailSize * 4) {
                        splitPos = pos;
                    }
                    line2[pos] = posx - 1;
                    line2[pos + 1] = this.getBase(c) + this.chan[c].tail[tailIndex - 1];
                    line2[pos + 2] = posx;
                    line2[pos + 3] = this.getBase(c) + this.chan[c].tail[tailIndex];
                }
                ((Data)this.chan[c]).tail[tailIndex - 1] = this.chan[c].tail[tailIndex++];
                ++i;
            }
            ++progress;
        }
        int[] l1 = new int[splitPos];
        System.arraycopy(line1, 0, l1, 0, l1.length);
        int[] l2 = new int[this.chan[c].tailSize * 4 - splitPos];
        System.arraycopy(line2, splitPos, l2, 0, l2.length);
        return new Object[]{l1, l2};
    }

    private void calculateBase(int channel) {
        if (this.chan[channel].height > 2) {
            this.chan[channel].base = this.chan[channel].height * (100 - this.getBaseOffset(channel)) / 100;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint != -1 ? wHint : 180;
        int height = hHint != -1 ? hHint : 100;
        return new Point(width + 2, height + 2);
    }

    protected void controlMoved(Event e) {
    }

    protected void controlResized(Event e) {
        this.setSizeInternal(this.getSize().x, this.getSize().y);
        this.width = this.getBounds().width;
        if (this.getBounds().width > 0) {
            int channel = 0;
            while (channel < this.chan.length) {
                this.setSteady(channel, this.chan[channel].steady, this.chan[channel].originalSteadyPosition);
                this.setTailSizeInternal(channel);
                ++channel;
            }
        }
    }

    public int getBase(int channel) {
        return this.chan[channel].base;
    }

    public int getBaseOffset(int channel) {
        return this.chan[channel].baseOffset;
    }

    public int getChannels() {
        return this.chan.length;
    }

    public OscilloscopeDispatcher getDispatcher(int channel) {
        return this.chan[channel].dispatcher;
    }

    public Color getForeground(int channel) {
        return this.chan[channel].fg;
    }

    public int getLineWidth(int channel) {
        return this.chan[channel].lineWidth;
    }

    public int getProgression(int channel) {
        return this.chan[channel].progression;
    }

    public int getTailFade(int channel) {
        return this.chan[channel].tailFade;
    }

    public int getTailSize(int channel) {
        return this.chan[channel].tailSize;
    }

    public boolean isConnect(int channel) {
        return this.chan[channel].connect;
    }

    public boolean isFade(int channel) {
        return this.chan[channel].fade;
    }

    public boolean isPercentage(int channel) {
        return this.chan[channel].percentage;
    }

    public boolean isSteady(int channel) {
        return this.chan[channel].steady;
    }

    public boolean isAntiAlias(int channel) {
        return this.chan[channel].antiAlias;
    }

    public boolean needsRedraw() {
        this.checkWidget();
        return !this.isDisposed();
    }

    private void notifyListeners(int channel) {
        if (this.chan[channel].stackListeners == null || this.chan[channel].stackListeners.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.chan[channel].stackListeners.size()) {
            ((OscilloscopeStackAdapter)this.chan[channel].stackListeners.get(i)).stackEmpty(this, channel);
            ++i;
        }
    }

    protected void paintControl(Event e) {
        int c = 0;
        while (c < this.chan.length) {
            if (this.chan[c].tailSize <= 0) {
                this.chan[c].stack.popNegate(0);
            } else {
                Object[] result = this.calculate(c);
                int[] l1 = (int[])result[0];
                int[] l2 = (int[])result[1];
                GC gc = e.gc;
                gc.setForeground(this.getForeground(c));
                gc.setAdvanced(true);
                gc.setAntialias(this.chan[c].antiAlias ? 1 : 0);
                gc.setLineWidth(this.getLineWidth(c));
                if (this.isFade(c)) {
                    gc.setAlpha(0);
                    double fade = 0.0;
                    double fadeOutStep = 125.0 / (double)(this.getTailSize(c) * this.getTailFade(c) / 100);
                    int i = 0;
                    while (i < l1.length - 4) {
                        this.setAlpha(gc, fade += fadeOutStep / 2.0);
                        gc.drawLine(l1[i], l1[i + 1], l1[i + 2], l1[i + 3]);
                        i += 2;
                    }
                    i = 0;
                    while (i < l2.length - 4) {
                        this.setAlpha(gc, fade += fadeOutStep / 2.0);
                        gc.drawLine(l2[i], l2[i + 1], l2[i + 2], l2[i + 3]);
                        i += 2;
                    }
                } else {
                    gc.drawPolyline(l1);
                    gc.drawPolyline(l2);
                }
                if (this.isConnect(c) && !this.isFade(c) && this.chan[c].originalTailSize == -1 && l1.length > 0 && l2.length > 0) {
                    gc.drawLine(l2[l2.length - 2], l2[l2.length - 1], l1[0], l1[1]);
                }
            }
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStackListener(int channel, OscilloscopeStackAdapter listener) {
        if (this.chan[channel].stackListeners != null) {
            this.chan[channel].stackListeners.remove(listener);
            if (this.chan[channel].stackListeners.size() == 0) {
                List list = this.chan[channel].stackListeners;
                synchronized (list) {
                    this.chan[channel].stackListeners = null;
                }
            }
        }
    }

    private void setAlpha(GC gc, double fade) {
        if ((double)gc.getAlpha() == fade) {
            return;
        }
        if (fade >= 255.0) {
            gc.setAlpha(255);
        } else {
            gc.setAlpha((int)fade);
        }
    }

    public void setBaseOffset(int channel, int baseOffset) {
        if (baseOffset > 100) {
            baseOffset = 100;
        }
        if (baseOffset < -100) {
            baseOffset = -100;
        }
        this.chan[channel].baseOffset = baseOffset;
        this.calculateBase(channel);
    }

    public void setConnect(int channel, boolean connectHeadAndTail) {
        this.chan[channel].connect = connectHeadAndTail;
    }

    public void setAntialias(int channel, boolean antialias) {
        this.chan[channel].antiAlias = antialias;
    }

    public void setDispatcher(int channel, OscilloscopeDispatcher dispatcher) {
        this.chan[channel].dispatcher = dispatcher;
    }

    public void setFade(int channel, boolean fade) {
        this.chan[channel].fade = fade;
    }

    public void setForeground(int channel, Color color) {
        this.chan[channel].fg = color;
    }

    public void setLineWidth(int channel, int lineWidth) {
        if (lineWidth > 0) {
            this.chan[channel].lineWidth = lineWidth;
        }
    }

    public void setPercentage(int channel, boolean percentage) {
        this.chan[channel].percentage = percentage;
    }

    public void setProgression(int channel, int progression) {
        if (progression > 0) {
            this.chan[channel].progression = progression;
        }
    }

    private void setSizeInternal(int width, int height) {
        int c = 0;
        while (c < this.chan.length) {
            this.chan[c].width = width;
            this.chan[c].height = height;
            this.calculateBase(c);
            if (width > 1) {
                if (this.chan[c].stack == null) {
                    this.chan[c].stack = new IntegerFiFoCircularStack(width);
                } else {
                    this.chan[c].stack = new IntegerFiFoCircularStack(width, this.chan[c].stack);
                }
            }
            ++c;
        }
    }

    public void setSteady(int channel, boolean steady, int steadyPosition) {
        this.chan[channel].steady = steady;
        this.chan[channel].originalSteadyPosition = steadyPosition;
        if (steady) {
            if (steadyPosition == -1) {
                this.chan[channel].cursor = (int)((double)this.chan[channel].width * 0.75);
            } else if (steadyPosition > 0 && steadyPosition < this.chan[channel].width) {
                this.chan[channel].cursor = steadyPosition;
            }
        }
    }

    public void setTailFade(int channel, int tailFade) {
        this.checkWidget();
        if (tailFade > 100) {
            tailFade = 100;
        }
        if (tailFade < 1) {
            tailFade = 1;
        }
        this.chan[channel].tailFade = tailFade;
    }

    public void setTailSize(int channel, int size) {
        this.checkWidget();
        if (size == -2 && !this.isSteady(channel)) {
            size = -1;
        }
        if (this.chan[channel].originalTailSize != size) {
            this.tailSizeCheck(size);
            this.chan[channel].originalTailSize = size;
            this.setTailSizeInternal(channel);
        }
    }

    private void setTailSizeInternal(int channel) {
        if (this.chan[channel].originalTailSize == -3) {
            this.chan[channel].tailSize = this.chan[channel].width / 4 * 3;
            Data data = this.chan[channel];
            data.tailSize = data.tailSize - 1;
        } else if (this.chan[channel].originalTailSize == -2) {
            if (this.isSteady(channel)) {
                this.chan[channel].tailSize = this.chan[channel].originalSteadyPosition - 1;
            } else {
                this.chan[channel].tailSize = this.chan[channel].width - 2;
            }
        } else if (this.chan[channel].originalTailSize == -1 || this.chan[channel].originalTailSize > this.chan[channel].width) {
            this.chan[channel].tailSize = this.chan[channel].width - 2;
        } else if (this.chan[channel].tailSize != this.chan[channel].originalTailSize) {
            this.chan[channel].tailSize = this.chan[channel].originalTailSize;
        }
        int[] oldTail = this.chan[channel].tail;
        if (oldTail == null) {
            this.chan[channel].tail = new int[this.chan[channel].tailSize + 1];
        } else {
            this.chan[channel].tail = new int[this.chan[channel].tailSize + 1];
            if (this.chan[channel].tail.length >= oldTail.length) {
                int i = 0;
                while (i < oldTail.length) {
                    ((Data)this.chan[channel]).tail[((Data)this.chan[channel]).tail.length - 1 - i] = oldTail[oldTail.length - 1 - i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.chan[channel].tail.length) {
                    ((Data)this.chan[channel]).tail[((Data)this.chan[channel]).tail.length - 1 - i] = oldTail[oldTail.length - 1 - i];
                    ++i;
                }
            }
        }
    }

    public void setValue(int channel, int value) {
        if (this.width > 0 && this.chan[channel].stack.capacity > 0) {
            this.chan[channel].stack.push(value);
        }
    }

    public synchronized void setValues(int channel, int[] values) {
        if (this.width > 0) {
            int[] nArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                int value = nArray[n2];
                this.setValue(channel, value);
                ++n2;
            }
        }
    }

    private void tailSizeCheck(int size) {
        if (size < -3 || size == 0) {
            throw new RuntimeException("Invalid tail size " + size);
        }
    }

    private int transform(int channel, int vWidth, int vHeight, int value) {
        if (this.isPercentage(channel)) {
            return vHeight / 2 * value / 100;
        }
        return value;
    }

    protected void widgetDisposed(Event e) {
        this.bg.dispose();
        Data[] dataArray = this.chan;
        int n = this.chan.length;
        int n2 = 0;
        while (n2 < n) {
            Data element = dataArray[n2];
            element.fg.dispose();
            ++n2;
        }
    }

    public int getGridSquareSize() {
        this.checkWidget();
        return this.gridSquareSize;
    }

    public void setGridSquareSize(int size) {
        this.checkWidget();
        if (size < 1) {
            SWT.error((int)5);
        }
        this.gridSquareSize = size;
        this.updateGrid();
    }

    private void updateGrid() {
        if (this.chan.length > 0) {
            OscilloscopeDispatcher dispatcher = this.chan[0].dispatcher;
            dispatcher.updateBackgroundImage();
            this.setBackgroundImage(dispatcher.getBackgroundImage());
        }
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return this.gridLineWidth;
    }

    public void setGridLineWidth(int gridLineWidth) {
        this.checkWidget();
        if (gridLineWidth < 1) {
            SWT.error((int)5);
        }
        this.gridLineWidth = gridLineWidth;
        this.updateGrid();
    }

    public Color getGridBackground() {
        this.checkWidget();
        return this.gridBackground;
    }

    public void setGridBackground(Color gridBackground) {
        this.checkWidget();
        this.gridBackground = gridBackground;
        this.updateGrid();
    }

    public Color getGridForeground() {
        this.checkWidget();
        return this.gridForeground;
    }

    public void setGridForeground(Color gridForeground) {
        this.checkWidget();
        this.gridForeground = gridForeground;
        this.updateGrid();
    }

    private class Data {
        private int base;
        private int baseOffset = 50;
        private boolean connect;
        private int cursor = 50;
        private OscilloscopeDispatcher dispatcher;
        private boolean fade;
        private Color fg;
        private int height = 100;
        private int lineWidth = 1;
        private int originalSteadyPosition = -1;
        private int originalTailSize;
        private boolean percentage = false;
        private int progression = 1;
        private IntegerFiFoCircularStack stack;
        private List<OscilloscopeStackAdapter> stackListeners;
        private boolean steady;
        private int[] tail;
        private int tailFade = 25;
        private int tailSize;
        private int width = 180;
        private boolean antiAlias = false;

        private Data() {
        }
    }

    public class IntegerFiFoCircularStack {
        private int bottom;
        private final int capacity;
        private final int[] stack;
        private int storedValues;
        private int top;

        public IntegerFiFoCircularStack(int capacity) {
            if (capacity <= 1) {
                throw new RuntimeException("Stack capacity must be > 1");
            }
            this.capacity = capacity;
            this.stack = new int[capacity];
            this.top = 0;
            this.bottom = 0;
        }

        public IntegerFiFoCircularStack(int capacity, IntegerFiFoCircularStack oldStack) {
            this(capacity);
            while (!oldStack.isEmpty()) {
                this.push(oldStack.pop(0));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            int[] nArray = this.stack;
            synchronized (this.stack) {
                int i = 0;
                while (i < this.stack.length) {
                    this.stack[i] = 0;
                    ++i;
                }
                this.top = 0;
                this.bottom = 0;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public int getCapacity() {
            return this.capacity;
        }

        public int getLoad() {
            return this.storedValues;
        }

        public boolean isEmpty() {
            return this.storedValues == 0;
        }

        public boolean isFull() {
            return this.storedValues == this.capacity;
        }

        public int peek(int valueIfEmpty) {
            if (this.storedValues > 0) {
                return this.stack[this.bottom];
            }
            return valueIfEmpty;
        }

        public int pop(int valueIfEmpty) {
            if (this.isEmpty()) {
                return valueIfEmpty;
            }
            --this.storedValues;
            int result = this.stack[this.bottom++];
            if (this.bottom == this.capacity) {
                this.bottom = 0;
            }
            return result;
        }

        public int popNegate(int valueIfEmpty) {
            return this.pop(valueIfEmpty) * -1;
        }

        public void push(int value) {
            if (this.storedValues == this.capacity) {
                this.top = this.bottom++;
                if (this.bottom == this.capacity) {
                    this.bottom = 0;
                }
            } else {
                ++this.storedValues;
            }
            if (this.top == this.capacity) {
                this.top = 0;
            }
            this.stack[this.top++] = value;
        }
    }
}

