/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.multichoice;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.multichoice.MultiChoiceDefaultLabelProvider;
import org.eclipse.nebula.widgets.opal.multichoice.MultiChoiceLabelProvider;
import org.eclipse.nebula.widgets.opal.multichoice.MultiChoiceSelectionListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultiChoice<T>
extends Composite {
    private Text text;
    private Button arrow;
    private Shell popup;
    private ScrolledComposite scrolledComposite;
    private Listener listener;
    private Listener filter;
    private int numberOfColumns = 2;
    private List<T> elements;
    private Set<T> selection;
    private List<Button> checkboxes;
    private boolean hasFocus;
    private MultiChoiceSelectionListener<T> selectionListener;
    private T lastModified;
    private Color foreground;
    private Color background;
    private Font font;
    private String separator;
    private MultiChoiceLabelProvider labelProvider;
    private int preferredHeightOfPopup;

    public MultiChoice(Composite parent, int style) {
        this(parent, style, null);
    }

    public MultiChoice(Composite parent, int style, List<T> elements) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        int readOnlyStyle = (style & 8) == 8 ? 8 : 0;
        this.text = new Text((Composite)this, 4 | readOnlyStyle | 0x800);
        this.text.setBackground(this.getDisplay().getSystemColor(25));
        this.text.setLayoutData((Object)new GridData(4, 4, true, false));
        this.arrow = new Button((Composite)this, 131076);
        this.arrow.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createGlobalListener();
        this.addListeners();
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == MultiChoice.this.getShell()) {
                    MultiChoice.this.handleFocusEvents(16);
                }
            }
        };
        this.selection = new LinkedHashSet<T>();
        this.elements = elements;
        this.separator = ",";
        this.labelProvider = new MultiChoiceDefaultLabelProvider();
        this.createPopup();
        this.setLabel();
    }

    private void createGlobalListener() {
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (MultiChoice.this.popup == event.widget) {
                    MultiChoice.this.handlePopupEvent(event);
                    return;
                }
                if (MultiChoice.this.arrow == event.widget) {
                    MultiChoice.this.handleButtonEvent(event);
                    return;
                }
                if (MultiChoice.this == event.widget) {
                    MultiChoice.this.handleMultiChoiceEvents(event);
                    return;
                }
                if (MultiChoice.this.getShell() == event.widget) {
                    MultiChoice.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (MultiChoice.this.isDisposed()) {
                                return;
                            }
                            MultiChoice.this.handleFocusEvents(16);
                        }
                    });
                }
            }
        };
    }

    private void addListeners() {
        int[] buttonEvents;
        int[] multiChoiceEvent;
        int[] nArray = multiChoiceEvent = new int[]{12, 10, 11};
        int n = multiChoiceEvent.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            this.addListener(element, this.listener);
            ++n2;
        }
        if ((this.getStyle() & 8) == 0) {
            Listener validationListener = new Listener(){

                public void handleEvent(Event event) {
                    if (!MultiChoice.this.popup.isDisposed() && !MultiChoice.this.popup.isVisible()) {
                        MultiChoice.this.validateEntry();
                    }
                }
            };
            this.text.addListener(16, validationListener);
        }
        int[] nArray2 = buttonEvents = new int[]{13, 15};
        int n3 = buttonEvents.length;
        n = 0;
        while (n < n3) {
            int buttonEvent = nArray2[n];
            this.arrow.addListener(buttonEvent, this.listener);
            ++n;
        }
    }

    protected void validateEntry() {
        String messageToDisplay;
        String toValidate = this.text.getText();
        String[] elementsToValidate = toValidate.split(this.separator);
        ArrayList<String> fieldsInError = new ArrayList<String>();
        this.selection.clear();
        String[] stringArray = elementsToValidate;
        int n = elementsToValidate.length;
        int n2 = 0;
        while (n2 < n) {
            String elementToValidate = stringArray[n2];
            String temp = elementToValidate.trim();
            if (!"".equals(temp)) {
                T entry = this.convertEntry(temp);
                if (entry == null) {
                    fieldsInError.add(temp);
                } else {
                    this.selection.add(entry);
                }
            }
            ++n2;
        }
        if (fieldsInError.size() == 0) {
            this.updateSelection();
            return;
        }
        if (fieldsInError.size() == 1) {
            messageToDisplay = String.format(ResourceManager.getLabel((String)"multichoice.message"), fieldsInError.get(0));
        } else {
            StringBuilder sb = new StringBuilder();
            Iterator it = fieldsInError.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            messageToDisplay = String.format(ResourceManager.getLabel((String)"multichoice.message.plural"), sb.toString());
        }
        this.getDisplay().asyncExec(() -> {
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setMessage(messageToDisplay);
            mb.open();
            this.text.forceFocus();
        });
    }

    private T convertEntry(String elementToValidate) {
        for (T elt : this.elements) {
            if (!this.labelProvider.getText(elt).trim().equals(elementToValidate)) continue;
            return elt;
        }
        return null;
    }

    public void add(T value) {
        this.checkWidget();
        if (value == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.add(value);
        this.refresh();
    }

    public void add(T value, int index) {
        this.checkWidget();
        this.checkNullElement();
        if (value == null) {
            SWT.error((int)4);
        }
        this.checkRange(index);
        this.elements.add(index, value);
        this.refresh();
    }

    public void addAll(List<T> values) {
        this.checkWidget();
        if (values == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        this.elements.addAll(values);
        this.refresh();
    }

    public void addAll(T[] values) {
        this.checkWidget();
        if (values == null) {
            SWT.error((int)4);
        }
        if (this.elements == null) {
            this.elements = new ArrayList<T>();
        }
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            this.elements.add(value);
            ++n2;
        }
        this.refresh();
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public T getItem(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        return this.elements.get(index);
    }

    public int getItemCount() {
        this.checkWidget();
        if (this.elements == null) {
            return 0;
        }
        return this.elements.size();
    }

    public List<T> getItems() {
        this.checkWidget();
        if (this.elements == null) {
            return null;
        }
        return new ArrayList<T>(this.elements);
    }

    public void removeAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        T removedElement = this.elements.remove(index);
        this.selection.remove(removedElement);
        this.refresh();
    }

    public void remove(T object) {
        if (object == null) {
            SWT.error((int)4);
        }
        this.checkWidget();
        this.checkNullElement();
        this.elements.remove(object);
        this.selection.remove(object);
        this.refresh();
    }

    public void removeAll() {
        this.checkWidget();
        this.checkNullElement();
        if (this.elements != null) {
            this.elements.clear();
        }
        this.selection.clear();
        this.refresh();
    }

    public void setLabelProvider(MultiChoiceLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setSelection(Set<T> selection) {
        this.checkWidget();
        this.checkNullElement();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.selection = selection;
        this.updateSelection();
    }

    public void selectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.addAll(this.elements);
        this.updateSelection();
    }

    public void selectAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        this.checkRange(index);
        this.selection.add(this.elements.get(index));
        this.updateSelection();
    }

    public void select(T value) {
        this.checkWidget();
        this.checkNullElement();
        if (!this.elements.contains(value)) {
            throw new IllegalArgumentException("Value not present in the widget");
        }
        this.selection.add(value);
        this.updateSelection();
    }

    public void setSelectedIndex(int[] index) {
        this.checkWidget();
        this.checkNullElement();
        int[] nArray = index;
        int n = index.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.checkRange(i);
            this.selection.add(this.elements.get(i));
            ++n2;
        }
        this.updateSelection();
    }

    public int[] getSelectedIndex() {
        this.checkWidget();
        this.checkNullElement();
        ArrayList<Integer> selectedIndex = new ArrayList<Integer>();
        int i = 0;
        while (i < this.elements.size()) {
            if (this.selection.contains(this.elements.get(i))) {
                selectedIndex.add(i);
            }
            ++i;
        }
        int[] returned = new int[selectedIndex.size()];
        int i2 = 0;
        while (i2 < selectedIndex.size()) {
            returned[i2] = (Integer)selectedIndex.get(i2);
            ++i2;
        }
        return returned;
    }

    public List<T> getSelection() {
        this.checkWidget();
        this.checkNullElement();
        return new ArrayList<T>(this.selection);
    }

    public void deselectAt(int index) {
        this.checkWidget();
        this.checkNullElement();
        if (index < 0 || index >= this.elements.size()) {
            SWT.error((int)6);
        }
        this.selection.remove(index);
        this.updateSelection();
    }

    public void deselect(T value) {
        this.checkWidget();
        this.checkNullElement();
        this.selection.remove(value);
        this.updateSelection();
    }

    public void deselectAll() {
        this.checkWidget();
        this.checkNullElement();
        this.selection.clear();
        this.updateSelection();
    }

    public int getNumberOfColumns() {
        this.checkWidget();
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.checkWidget();
        this.numberOfColumns = numberOfColumns;
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void refresh() {
        this.checkWidget();
        this.popup.dispose();
        this.popup = null;
        this.createPopup();
        this.updateSelection();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int textWidth = gc.stringExtent((String)this.text.getText()).x;
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(textSize.y, arrowSize.y);
        width = textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width + 2 * borderWidth, height + 2 * borderWidth);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.arrow.setEnabled(enabled);
        this.text.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
        this.text.setBackground(null);
    }

    public void setToolTipText(String txt) {
        this.checkWidget();
        this.text.setToolTipText(txt);
    }

    public SelectionListener getSelectionListener() {
        this.checkWidget();
        return this.selectionListener;
    }

    public void setSelectionListener(MultiChoiceSelectionListener<T> selectionListener) {
        this.checkWidget();
        this.selectionListener = selectionListener;
        this.refresh();
    }

    public void updateSelection() {
        this.checkWidget();
        if (this.isDisposed()) {
            return;
        }
        if (this.popup == null || this.popup.isDisposed() || this.checkboxes == null) {
            return;
        }
        int i = 0;
        while (i < this.checkboxes.size()) {
            Button currentButton = this.checkboxes.get(i);
            if (!currentButton.isDisposed()) {
                Object content = currentButton.getData();
                currentButton.setSelection(this.selection.contains(content));
            }
            ++i;
        }
        this.setLabel();
    }

    T getLastModified() {
        return this.lastModified;
    }

    Shell getPopup() {
        return this.popup;
    }

    private void createPopup() {
        int[] popupEvents;
        this.popup = new Shell(this.getShell(), 16392);
        this.popup.setLayout((Layout)new FillLayout());
        int[] nArray = popupEvents = new int[]{21, 27, 12};
        int n = popupEvents.length;
        int n2 = 0;
        while (n2 < n) {
            int popupEvent = nArray[n2];
            this.popup.addListener(popupEvent, this.listener);
            ++n2;
        }
        if (this.elements == null) {
            return;
        }
        this.scrolledComposite = new ScrolledComposite((Composite)this.popup, 2560);
        Composite content = new Composite((Composite)this.scrolledComposite, 0);
        content.setLayout((Layout)new GridLayout(this.numberOfColumns, true));
        this.checkboxes = new ArrayList<Button>(this.elements.size());
        for (T o : this.elements) {
            Button checkBoxButton = new Button(content, 32);
            if (this.font != null) {
                checkBoxButton.setFont(this.font);
            }
            if (this.foreground != null) {
                checkBoxButton.setForeground(this.foreground);
            }
            if (this.background != null) {
                checkBoxButton.setBackground(this.background);
            }
            checkBoxButton.setEnabled(this.text.getEditable());
            checkBoxButton.setData(o);
            checkBoxButton.setLayoutData((Object)new GridData(1, 2, false, false));
            checkBoxButton.setText(this.labelProvider.getText(o));
            checkBoxButton.addListener(13, e -> {
                if (checkBoxButton.getSelection()) {
                    this.selection.add(o);
                } else {
                    this.selection.remove(o);
                }
                this.lastModified = o;
                this.setLabel();
            });
            if (this.selectionListener != null) {
                checkBoxButton.addSelectionListener(this.selectionListener);
            }
            checkBoxButton.setSelection(this.selection.contains(o));
            this.checkboxes.add(checkBoxButton);
        }
        this.scrolledComposite.setContent((Control)content);
        this.scrolledComposite.setExpandHorizontal(false);
        this.scrolledComposite.setExpandVertical(true);
        content.pack();
        this.preferredHeightOfPopup = content.getSize().y;
    }

    private void setLabel() {
        if (this.checkboxes == null) {
            this.text.setText("");
            return;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Button current : this.checkboxes) {
            if (!current.getSelection()) continue;
            values.add(current.getText());
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(this.separator);
        }
        this.text.setText(sb.toString());
    }

    private void handleFocusEvents(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    private void handleMultiChoiceEvents(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 11: {
                if (!this.isDropped()) break;
                this.changeVisibilityOfPopupWindow(false);
            }
        }
    }

    private void handleButtonEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocusEvents(15);
                break;
            }
            case 13: {
                this.changeVisibilityOfPopupWindow(!this.isDropped());
            }
        }
    }

    private boolean isDropped() {
        return !this.popup.isDisposed() && this.popup.getVisible();
    }

    private void handlePopupEvent(Event event) {
        switch (event.type) {
            case 21: {
                event.doit = false;
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 27: {
                this.changeVisibilityOfPopupWindow(false);
                break;
            }
            case 12: {
                if (this.checkboxes != null) {
                    this.checkboxes.clear();
                }
                this.checkboxes = null;
            }
        }
    }

    private void changeVisibilityOfPopupWindow(boolean show) {
        if (show == this.isDropped()) {
            return;
        }
        if (!show) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.text.setFocus();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            this.popup.dispose();
            this.popup = null;
            this.createPopup();
        }
        Point arrowRect = this.arrow.toDisplay(this.arrow.getSize().x - 5, this.arrow.getSize().y + this.arrow.getBorderWidth() - 3);
        int x = arrowRect.x;
        int y = arrowRect.y;
        Rectangle displayRect = this.getMonitor().getClientArea();
        Rectangle parentRect = this.getDisplay().map((Control)this.getParent(), null, this.getBounds());
        this.popup.pack();
        int width = this.popup.getBounds().width;
        int maxHeight = 2 * displayRect.height / 3;
        int height = this.popup.getBounds().height;
        if (height > maxHeight) {
            height = maxHeight;
            this.popup.setSize(width, height);
            this.scrolledComposite.setMinHeight(this.preferredHeightOfPopup);
            this.popup.layout(true);
        }
        if (y + height > displayRect.y + displayRect.height && (y = parentRect.y - height) < 0) {
            height += y;
            y = parentRect.y - height + 5;
            this.popup.setSize(width, height);
            this.scrolledComposite.setMinHeight(this.preferredHeightOfPopup);
            this.popup.layout(true);
        }
        if (x + width > displayRect.x + displayRect.width) {
            x = displayRect.x + displayRect.width - width;
        }
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
        this.popup.setFocus();
    }

    private void checkNullElement() {
        if (this.elements == null) {
            throw new NullPointerException("There is no element associated to this widget");
        }
    }

    private void checkRange(int index) throws NullPointerException {
        this.checkNullElement();
        if (index < 0 || index >= this.elements.size()) {
            SWT.error((int)6);
        }
    }

    public void setText(String textValue) {
        this.checkWidget();
        this.checkNullElement();
        if (textValue == null) {
            SWT.error((int)4);
        }
        this.selection.clear();
        this.text.setText(textValue);
    }

    public String getText() {
        this.checkWidget();
        this.checkNullElement();
        return this.text.getText();
    }
}

