/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import org.eclipse.nebula.widgets.opal.propertytable.PropertyTable;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;

public class PTProperty {
    private final String name;
    private final String displayName;
    private final String description;
    private Object value;
    private String category;
    private boolean enabled = true;
    private PTEditor editor;
    private PropertyTable parentTable;

    public PTProperty(String name, String displayName, String description) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
    }

    public PTProperty(String name, String displayName, String description, Object value) {
        this(name, displayName, description);
        this.value = value;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public PTEditor getEditor() {
        return this.editor;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public PTProperty setCategory(String category) {
        this.category = category;
        return this;
    }

    public PTProperty setEditor(PTEditor editor) {
        this.editor = editor;
        return this;
    }

    public PTProperty setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PTProperty setParentTable(PropertyTable parentTable) {
        this.parentTable = parentTable;
        return this;
    }

    public PTProperty setValue(Object value) {
        this.value = value;
        this.parentTable.firePTPropertyChangeListeners(this);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PTProperty other = (PTProperty)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

