/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTChooserEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PTColorEditor
extends PTChooserEditor {
    @Override
    protected void openWindow(PTWidget widget, Item item, PTProperty property) {
        ColorDialog dialog = new ColorDialog(widget.getWidget().getShell());
        RGB result = dialog.open();
        if (result != null) {
            property.setValue(result);
            Color bgColor = this.getBackgroundColor(property);
            if (bgColor != null) {
                if (item instanceof TableItem) {
                    ((TableItem)item).setBackground(1, bgColor);
                }
                if (item instanceof TreeItem) {
                    ((TreeItem)item).setBackground(1, bgColor);
                }
                SWTGraphicUtil.addDisposer((Widget)item, (Resource)bgColor);
            }
            if (item instanceof TableItem) {
                ((TableItem)item).setText(1, this.getTextFor(property));
            } else {
                ((TreeItem)item).setText(1, this.getTextFor(property));
            }
        }
    }

    @Override
    protected String getTextFor(PTProperty property) {
        if (property.getValue() == null) {
            return "";
        }
        RGB rgb = (RGB)property.getValue();
        StringBuilder sb = new StringBuilder();
        sb.append("R:").append(rgb.red).append(" G:").append(rgb.green).append(" B:").append(rgb.blue);
        sb.append(" - #");
        sb.append(("0" + Integer.toHexString(rgb.red)).substring(0, 2));
        sb.append(("0" + Integer.toHexString(rgb.green)).substring(0, 2));
        sb.append(("0" + Integer.toHexString(rgb.blue)).substring(0, 2));
        return sb.toString();
    }

    @Override
    protected Color getBackgroundColor(PTProperty property) {
        if (property.getValue() == null) {
            return null;
        }
        RGB rgb = (RGB)property.getValue();
        return new Color((Device)Display.getDefault(), rgb);
    }
}

