/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable.viewers;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.compositetable.month.MonthCalendar;
import org.eclipse.nebula.widgets.compositetable.month.MonthCalendarSelectedDay;
import org.eclipse.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventContentProvider;
import org.eclipse.nebula.widgets.compositetable.timeeditor.EventCountProvider;
import org.eclipse.nebula.widgets.compositetable.viewers.IMonthCalendarContentProvider;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MonthCalendarViewer
extends ContentViewer {
    MonthCalendar calendar = null;
    private IStructuredSelection selection = StructuredSelection.EMPTY;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            System.out.println("mouseDown: MouseListener: " + e);
            MonthCalendarViewer.this.changeSelection();
        }
    };
    private EventContentProvider eventContentProvider = new EventContentProvider(){

        @Override
        public void refresh(Date day, CalendarableItem[] controls) {
            Object[] elements = ((IMonthCalendarContentProvider)MonthCalendarViewer.this.getContentProvider()).getElements(day, MonthCalendarViewer.this.getInput());
            int count = Math.min(elements.length, controls.length);
            int i = 0;
            while (i < count) {
                if (controls[i] != null) {
                    controls[i].setText(((ILabelProvider)MonthCalendarViewer.this.getLabelProvider()).getText(elements[i]));
                    controls[i].setImage(((ILabelProvider)MonthCalendarViewer.this.getLabelProvider()).getImage(elements[i]));
                    controls[i].setStartTime(day);
                    controls[i].setEndTime(day);
                    controls[i].setAllDayEvent(false);
                    controls[i].setContinued(0);
                }
                ++i;
            }
        }
    };
    private EventCountProvider eventCountProvider = new EventCountProvider(){

        @Override
        public int getNumberOfEventsInDay(Date day) {
            return ((IMonthCalendarContentProvider)MonthCalendarViewer.this.getContentProvider()).getElements(day, MonthCalendarViewer.this.getInput()).length;
        }
    };

    public MonthCalendarViewer(Composite parent, int style) {
        this(new MonthCalendar(parent, style));
    }

    public MonthCalendarViewer(MonthCalendar monthCalendar) {
        if (monthCalendar == null) {
            throw new IllegalArgumentException("MonthCalendar cannot be null");
        }
        this.calendar = monthCalendar;
        this.calendar.setStartDate(new Date());
        super.hookControl((Control)this.calendar);
        this.calendar.addMouseListener(this.mouseListener);
    }

    public Control getControl() {
        return this.getMonthCalendar();
    }

    public MonthCalendar getMonthCalendar() {
        return this.calendar;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        this.calendar.refresh();
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (this.selection.equals(structuredSelection)) {
                return;
            }
            Date selectedDate = null;
            if (structuredSelection.getFirstElement() instanceof MonthCalendarSelectedDay) {
                selectedDate = ((MonthCalendarSelectedDay)structuredSelection.getFirstElement()).date;
            } else if (structuredSelection.getFirstElement() instanceof Date) {
                selectedDate = (Date)structuredSelection.getFirstElement();
            } else {
                return;
            }
            System.out.println("setSelection: selectedDate " + selectedDate);
            if (this.calendar.getSelectedDay().date.equals(selectedDate)) {
                return;
            }
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(selectedDate);
            Point monthPosition = new Point(cal.get(7), cal.get(4));
            this.selection = new StructuredSelection((Object)new MonthCalendarSelectedDay(selectedDate, monthPosition));
            this.calendar.select(selectedDate);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        }
    }

    protected void changeSelection() {
        MonthCalendarSelectedDay selectedDay = this.calendar.getSelectedDay();
        StructuredSelection sel = new StructuredSelection((Object)selectedDay);
        this.selection = sel;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (!(contentProvider instanceof IMonthCalendarContentProvider)) {
            throw new IllegalArgumentException("content provider must be of type IMonthCalendarContentProvider");
        }
        super.setContentProvider(contentProvider);
        this.calendar.setEventContentProvider(this.eventContentProvider);
        this.calendar.setEventCountProvider(this.eventCountProvider);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        if (!(labelProvider instanceof ILabelProvider)) {
            throw new IllegalArgumentException("label provider must be of type ILabelProvider");
        }
        super.setLabelProvider(labelProvider);
    }
}

