/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.progresscircle.snippets;

import org.eclipse.nebula.widgets.progresscircle.ProgressCircle;
import org.eclipse.nebula.widgets.progresscircle.snippets.BasePanel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AbsolutePanel
extends BasePanel {
    public AbsolutePanel(Shell shell) {
        Color white = shell.getDisplay().getSystemColor(1);
        Group group = new Group((Composite)shell, 0);
        group.setText("Absolute");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setBackground(white);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftLabel((Composite)group, "Minimum");
        Text minimum = this.createTextWidget((Composite)group, -100);
        this.createConstraintsLabel((Composite)group, "(-5000>5000)");
        this.createLeftLabel((Composite)group, "Maximum");
        Text maximum = this.createTextWidget((Composite)group, 100);
        this.createConstraintsLabel((Composite)group, "(-5000>5000)");
        this.createLeftLabel((Composite)group, "Value");
        Text value = this.createTextWidget((Composite)group, 52);
        this.createConstraintsLabel((Composite)group, "(-5000>5000)");
        this.createCommonPart(group);
        Button update = new Button((Composite)group, 8);
        update.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        update.setText("Redraw circle");
        ProgressCircle circle = new ProgressCircle((Composite)group, 0);
        GridData gdCircle = new GridData(2, 2, true, true, 3, 1);
        gdCircle.minimumWidth = 200;
        gdCircle.minimumHeight = 200;
        circle.setBackground(white);
        circle.setLayoutData((Object)gdCircle);
        circle.setTextPattern("%d");
        circle.setMinimum(-100);
        circle.setMaximum(100);
        circle.setSelection(52);
        circle.setThickness(10);
        circle.setCircleSize(100);
        circle.setShowText(true);
        Color green = new Color((Device)shell.getDisplay(), 113, 178, 123);
        shell.addDisposeListener(e -> green.dispose());
        circle.setHighlightColor(green);
        update.addListener(13, e -> {
            int newMinimum = 0;
            try {
                newMinimum = Integer.valueOf(minimum.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + minimum.getText() + "] is not a number");
                return;
            }
            int newMaximum = 0;
            try {
                newMaximum = Integer.valueOf(maximum.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + maximum.getText() + "] is not a number");
                return;
            }
            int newValue = 0;
            try {
                newValue = Integer.valueOf(value.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + value.getText() + "] is not a number");
                return;
            }
            if (newMinimum > newMaximum) {
                this.showError(shell, String.format("The minimum [%d] is greater than the maximum [%d]", newMinimum, newMaximum));
                return;
            }
            if (newValue < newMinimum || newValue > newMaximum) {
                this.showError(shell, String.format("The value [%d] should be between %d and %d", newValue, newMinimum, newMaximum));
                return;
            }
            int newCircleSize = 0;
            try {
                newCircleSize = Integer.valueOf(this.circleSize.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.circleSize.getText() + "] is not a number");
                return;
            }
            if (newCircleSize > 1000) {
                this.showError(shell, "The value [" + newCircleSize + "] should be between lower than 1000");
                return;
            }
            int newThickness = 0;
            try {
                newThickness = Integer.valueOf(this.thickness.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.thickness.getText() + "] is not a number");
                return;
            }
            if (newThickness < 1 || newThickness > 50) {
                this.showError(shell, "The value [" + newThickness + "] should be between 1 and 50");
                return;
            }
            circle.setMinimum(newMinimum);
            circle.setMaximum(newMaximum);
            circle.setSelection(newValue);
            circle.setThickness(newThickness);
            circle.setCircleSize(newCircleSize);
            circle.setShowText(this.checkbox.getSelection());
        });
    }
}

