/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.progresscircle.snippets;

import org.eclipse.nebula.widgets.progresscircle.ProgressCircle;
import org.eclipse.nebula.widgets.progresscircle.snippets.BasePanel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class PercentagePanel
extends BasePanel {
    public PercentagePanel(Shell shell) {
        Color white = shell.getDisplay().getSystemColor(1);
        Group group = new Group((Composite)shell, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Percentage");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setBackground(white);
        this.createLeftLabel((Composite)group, "Percent");
        Text percent = this.createTextWidget((Composite)group, 60);
        this.createConstraintsLabel((Composite)group, "(1-100)");
        this.createCommonPart(group);
        Button update = new Button((Composite)group, 8);
        update.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        update.setText("Redraw circle");
        ProgressCircle circle = new ProgressCircle((Composite)group, 0);
        GridData gdCircle = new GridData(2, 2, true, true, 3, 1);
        gdCircle.minimumWidth = 200;
        gdCircle.minimumHeight = 200;
        circle.setBackground(white);
        circle.setLayoutData((Object)gdCircle);
        circle.setTextPattern("%d%%");
        circle.setSelection(60);
        circle.setThickness(10);
        circle.setCircleSize(100);
        circle.setShowText(true);
        update.addListener(13, e -> {
            int percentage = 0;
            try {
                percentage = Integer.valueOf(percent.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + percent.getText() + "] is not a number");
                return;
            }
            if (percentage < 0 || percentage > 100) {
                this.showError(shell, "The value [" + percentage + "] should be between 0 and 100");
                return;
            }
            int newCircleSize = 0;
            try {
                newCircleSize = Integer.valueOf(this.circleSize.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.circleSize.getText() + "] is not a number");
                return;
            }
            if (newCircleSize > 1000) {
                this.showError(shell, "The value [" + newCircleSize + "] should be between lower than 1000");
                return;
            }
            int newThickness = 0;
            try {
                newThickness = Integer.valueOf(this.thickness.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.thickness.getText() + "] is not a number");
                return;
            }
            if (newThickness < 1 || newThickness > 50) {
                this.showError(shell, "The value [" + newThickness + "] should be between 1 and 50");
                return;
            }
            circle.setSelection(percentage);
            circle.setThickness(newThickness);
            circle.setCircleSize(newCircleSize);
            circle.setShowText(this.checkbox.getSelection());
        });
    }
}

