/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.progresscircle.snippets;

import java.time.LocalTime;
import org.eclipse.nebula.widgets.progresscircle.ProgressCircle;
import org.eclipse.nebula.widgets.progresscircle.snippets.BasePanel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

class TimePanel
extends BasePanel {
    public TimePanel(Shell shell) {
        Color white = shell.getDisplay().getSystemColor(1);
        Group group = new Group((Composite)shell, 0);
        group.setText("CountDown");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setBackground(white);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftLabel((Composite)group, "Time");
        Composite temp = new Composite((Composite)group, 0);
        temp.setBackground(white);
        temp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        temp.setLayout((Layout)new GridLayout(6, false));
        Spinner hours = new Spinner(temp, 0);
        hours.setLayoutData((Object)new GridData(4, 2, false, false));
        hours.setMinimum(0);
        hours.setMaximum(23);
        Label lblHour = new Label(temp, 0);
        lblHour.setText("hour(s)");
        lblHour.setBackground(white);
        lblHour.setLayoutData((Object)new GridData(2, 2, false, false));
        Spinner minutes = new Spinner(temp, 0);
        minutes.setLayoutData((Object)new GridData(4, 2, false, false));
        minutes.setMinimum(0);
        minutes.setMaximum(59);
        minutes.setSelection(1);
        Label lblMinutes = new Label(temp, 0);
        lblMinutes.setText("minute(s)");
        lblMinutes.setBackground(white);
        lblMinutes.setLayoutData((Object)new GridData(2, 2, false, false));
        Spinner seconds = new Spinner(temp, 0);
        seconds.setLayoutData((Object)new GridData(4, 2, false, false));
        seconds.setMinimum(0);
        seconds.setMaximum(59);
        seconds.setSelection(18);
        Label lblSeconds = new Label(temp, 0);
        lblSeconds.setText("second(s)");
        lblSeconds.setBackground(white);
        lblSeconds.setLayoutData((Object)new GridData(2, 2, false, false));
        this.createCommonPart(group);
        Button update = new Button((Composite)group, 8);
        update.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        update.setText("Start Counter");
        ProgressCircle circle = new ProgressCircle((Composite)group, 0);
        GridData gdCircle = new GridData(2, 2, true, true, 3, 1);
        gdCircle.minimumWidth = 200;
        gdCircle.minimumHeight = 200;
        circle.setBackground(white);
        circle.setLayoutData((Object)gdCircle);
        circle.setTextPattern("%d");
        circle.setThickness(10);
        circle.setCircleSize(100);
        circle.setShowText(true);
        Color red = new Color((Device)shell.getDisplay(), 222, 80, 79);
        shell.addDisposeListener(e -> red.dispose());
        circle.setHighlightColor(red);
        update.addListener(13, e -> {
            int newCircleSize = 0;
            try {
                newCircleSize = Integer.valueOf(this.circleSize.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.circleSize.getText() + "] is not a number");
                return;
            }
            if (newCircleSize > 1000) {
                this.showError(shell, "The value [" + newCircleSize + "] should be between lower than 1000");
                return;
            }
            int newThickness = 0;
            try {
                newThickness = Integer.valueOf(this.thickness.getText());
            }
            catch (NumberFormatException nfe) {
                this.showError(shell, "The value [" + this.thickness.getText() + "] is not a number");
                return;
            }
            if (newThickness < 1 || newThickness > 50) {
                this.showError(shell, "The value [" + newThickness + "] should be between 1 and 50");
                return;
            }
            circle.setThickness(newThickness);
            circle.setCircleSize(newCircleSize);
            circle.setShowText(this.checkbox.getSelection());
            LocalTime time = LocalTime.of(hours.getSelection(), minutes.getSelection(), seconds.getSelection());
            circle.startCountDown(time);
        });
    }
}

