/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.nebula.widgets.geomap.OsmTileServer;
import org.eclipse.nebula.widgets.geomap.TileServer;
import org.eclipse.nebula.widgets.geomap.internal.AsyncImage;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelperListener;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapPositioned;
import org.eclipse.nebula.widgets.geomap.internal.InternalGeoMapListener;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GeoMapHelper
implements GeoMapPositioned,
GeoMapHelperListener {
    private final Display display;
    public static final int TILE_SIZE = 256;
    private static final int DEFAULT_NUMBER_OF_IMAGEFETCHER_THREADS = 4;
    private static final int MIN_CACHE_SIZE = 200;
    private Point mapSize = new Point(0, 0);
    private Point mapPosition = new Point(0, 0);
    private int zoom;
    AtomicLong zoomStamp = new AtomicLong();
    private TileServer tileServer = OsmTileServer.TILESERVERS[0];
    private int cacheSize;
    Map<TileRef, AsyncImage> cache;
    private BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadFactory threadFactory = r -> {
        Thread thread = new Thread(r);
        thread.setName("Async Image Loader " + thread.getId() + " " + System.identityHashCode(thread));
        thread.setDaemon(true);
        return thread;
    };
    ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 16, 2L, TimeUnit.SECONDS, this.workQueue, this.threadFactory);
    private Color waitBackground;
    private Color waitForeground;
    private List<GeoMapHelperListener> geoMapHelperListeners = new ArrayList<GeoMapHelperListener>();
    private List<InternalGeoMapListener> internalGeoMapListeners = new ArrayList<InternalGeoMapListener>();

    private GeoMapHelper(Display display) {
        this.display = display;
    }

    Display getDisplay() {
        return this.display;
    }

    public GeoMapHelper(Display display, Point mapPosition, int zoom, int cacheSize) {
        this(display);
        if (cacheSize < 200) {
            SWT.error((int)5, null, (String)" - Cache size should be greater than 200");
        }
        this.cacheSize = cacheSize;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<TileRef, AsyncImage>(cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<TileRef, AsyncImage> eldest) {
                boolean remove;
                boolean bl = remove = this.size() > GeoMapHelper.this.cacheSize;
                if (remove) {
                    eldest.getValue().dispose();
                }
                return remove;
            }
        });
        this.waitBackground = new Color((Device)display, 136, 136, 136);
        this.waitForeground = new Color((Device)display, 119, 119, 119);
        this.setZoom(zoom);
        this.setMapPosition(mapPosition.x, mapPosition.y);
    }

    public void paint(GC gc, Rectangle clip, Point size) {
        long startTime = System.currentTimeMillis();
        int tileCount = 0;
        int x0 = (int)Math.floor((double)this.mapPosition.x / 256.0);
        int y0 = (int)Math.floor((double)this.mapPosition.y / 256.0);
        int x1 = (int)Math.ceil(((double)this.mapPosition.x + (double)size.x) / 256.0);
        int y1 = (int)Math.ceil(((double)this.mapPosition.y + (double)size.y) / 256.0);
        int dy = y0 * 256 - this.mapPosition.y;
        int y = y0;
        while (y < y1) {
            int dx = x0 * 256 - this.mapPosition.x;
            int x = x0;
            while (x < x1) {
                if (clip == null || dx + 256 >= clip.x && dy + 256 >= clip.y && dx <= clip.x + clip.width && dy <= clip.y + clip.height) {
                    this.paintTile(gc, dx, dy, x, y);
                }
                dx += 256;
                ++tileCount;
                ++x;
            }
            dy += 256;
            ++y;
        }
        long endTime = System.currentTimeMillis();
        for (InternalGeoMapListener listener : this.internalGeoMapListeners) {
            listener.mapPainted(tileCount, endTime - startTime);
        }
        for (InternalGeoMapListener listener : this.internalGeoMapListeners) {
            listener.tileCacheUpdated(this.cache.size(), this.cacheSize);
        }
    }

    void paintTile(GC gc, int dx, int dy, int x, int y) {
        boolean drawImage;
        boolean DRAW_IMAGES = true;
        boolean DEBUG = false;
        boolean DRAW_OUT_OF_BOUNDS = true;
        boolean imageDrawn = false;
        int xTileCount = 1 << this.zoom;
        int yTileCount = 1 << this.zoom;
        boolean tileInBounds = x >= 0 && x < xTileCount && y >= 0 && y < yTileCount;
        boolean bl = drawImage = DRAW_IMAGES && tileInBounds;
        if (drawImage) {
            Image swtImage;
            TileRef tileRef = new TileRef(x, y, this.zoom);
            AsyncImage image = this.cache.get(tileRef);
            if (image == null) {
                image = new AsyncImage(this, tileRef, this.tileServer.getTileURL(tileRef));
                this.cache.put(tileRef, image);
            }
            if ((swtImage = image.getImage(this.getDisplay())) != null) {
                gc.drawImage(swtImage, dx, dy);
                imageDrawn = true;
            } else {
                tileRef = new TileRef(x / 2, y / 2, this.zoom - 1);
                image = this.cache.get(tileRef);
                if (image != null && (swtImage = image.getImage(this.getDisplay())) != null) {
                    gc.drawImage(swtImage, x % 2 == 0 ? 0 : 128, y % 2 == 0 ? 0 : 128, 128, 128, dx, dy, 256, 256);
                    imageDrawn = true;
                }
            }
            for (InternalGeoMapListener listener : this.internalGeoMapListeners) {
                listener.tilePainted(tileRef);
            }
        }
        if (DEBUG && !imageDrawn && (tileInBounds || DRAW_OUT_OF_BOUNDS)) {
            gc.setBackground(this.display.getSystemColor(tileInBounds ? 5 : 3));
            gc.fillRectangle(dx + 4, dy + 4, 248, 248);
            gc.setForeground(this.display.getSystemColor(2));
            String s = "T " + x + ", " + y + (!tileInBounds ? " #" : "");
            gc.drawString(s, dx + 4 + 8, dy + 4 + 12);
        } else if (!DEBUG && !imageDrawn && tileInBounds) {
            gc.setBackground(this.waitBackground);
            gc.fillRectangle(dx, dy, 256, 256);
            gc.setForeground(this.waitForeground);
            int yl = 0;
            while (yl < 256) {
                gc.drawLine(dx, dy + yl, dx + 256, dy + yl);
                yl += 32;
            }
            int xl = 0;
            while (xl < 256) {
                gc.drawLine(dx + xl, dy, dx + xl, dy + 256);
                xl += 32;
            }
        }
    }

    public void dispose() {
        this.waitBackground.dispose();
        this.waitForeground.dispose();
    }

    public TileServer getTileServer() {
        return this.tileServer;
    }

    public void setTileServer(TileServer tileServer) {
        this.tileServer = tileServer;
        this.cache.clear();
    }

    @Override
    public Point getMapPosition() {
        return new Point(this.mapPosition.x, this.mapPosition.y);
    }

    @Override
    public void setMapPosition(int x, int y) {
        this.mapPosition.x = x;
        this.mapPosition.y = y;
    }

    @Override
    public int getMaxZoom() {
        return this.getTileServer().getMaxZoom();
    }

    @Override
    public int getZoom() {
        return this.zoom;
    }

    @Override
    public void setZoom(int zoom) {
        int size;
        this.zoomStamp.incrementAndGet();
        this.zoom = Math.min(this.tileServer.getMaxZoom(), zoom);
        this.mapSize.x = size = 256 * (1 << zoom);
        this.mapSize.y = size;
    }

    @Override
    public void tileUpdated(TileRef tileRef) {
        for (GeoMapHelperListener listener : this.geoMapHelperListeners) {
            listener.tileUpdated(tileRef);
        }
    }

    public void addGeoMapHelperListener(GeoMapHelperListener listener) {
        this.geoMapHelperListeners.add(listener);
    }

    public void removeGeoMapHelperListener(GeoMapHelperListener listener) {
        this.geoMapHelperListeners.remove(listener);
    }

    public void addInternalGeoMapListener(InternalGeoMapListener listener) {
        this.internalGeoMapListeners.add(listener);
    }

    public void removeInternalGeoMapListener(InternalGeoMapListener listener) {
        this.internalGeoMapListeners.remove(listener);
    }

    public int getNumberOfTiles() {
        return Math.max(this.cache.size(), this.cacheSize);
    }
}

