/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw;

import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public abstract class Transition {
    public static final long DEFAULT_FPS = 60L;
    public static final long DEFAULT_T = 1000L;
    public static final double DIR_RIGHT = 0.0;
    public static final double DIR_UP = 90.0;
    public static final double DIR_LEFT = 180.0;
    public static final double DIR_DOWN = 270.0;
    protected static final boolean IS_MAC_OS = System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0;
    protected static final boolean IS_LINUX_OS = System.getProperty("os.name").toLowerCase().indexOf("nux") >= 0;
    protected TransitionManager _transitionManager;
    protected long _fps;
    protected long _T;
    private long _dt;
    private long _t;

    public Transition(TransitionManager transitionManager, long fps, long T) {
        this._transitionManager = transitionManager;
        this._fps = fps;
        this._T = T;
        this._t = 0L;
        this._dt = (long)(1000.0 / (double)this._fps);
    }

    public Transition(TransitionManager transitionManager) {
        this(transitionManager, 60L, 1000L);
    }

    public final void setFPS(long fps) {
        this._fps = fps;
        this._dt = (long)(1000.0 / (double)fps);
    }

    public final long getFPS() {
        return this._fps;
    }

    public final void setTotalTransitionTime(long T) {
        this._T = T;
    }

    public final double getTotalTransitionTime() {
        return this._T;
    }

    public final void start(Image from, Image to, Canvas canvas, double direction) {
        boolean flag = true;
        long t0 = System.currentTimeMillis();
        long dt = 0L;
        long ttemp = 0L;
        this._t = 0L;
        ImageData fromData = from.getImageData();
        Image xitionBg = new Image((Device)Display.getCurrent(), fromData.width, fromData.height);
        GC xitionBgGC = new GC((Drawable)xitionBg);
        xitionBgGC.setBackground(this._transitionManager.backgroundColor);
        xitionBgGC.fillRectangle(0, 0, fromData.width, fromData.height);
        if (this._transitionManager.backgroundImage != null) {
            ImageData imgData = this._transitionManager.backgroundImage.getImageData();
            xitionBgGC.drawImage(this._transitionManager.backgroundImage, 0, 0, imgData.width, imgData.height, 0, 0, fromData.width, fromData.height);
        }
        xitionBgGC.dispose();
        TransitionPainter transitionPainter = new TransitionPainter(canvas, from, to, direction, xitionBg);
        transitionPainter.paintTransition(0);
        while (this._t <= this._T) {
            ttemp = System.currentTimeMillis() - t0;
            dt = ttemp - this._t;
            if (flag) {
                this._t = ttemp;
            }
            if (dt >= this._dt) {
                if (this._t <= this._T) {
                    transitionPainter.paintTransition(1);
                } else {
                    transitionPainter.paintTransition(2);
                }
                flag = true;
                this.doEvents();
                continue;
            }
            try {
                flag = false;
                Thread.sleep(this._dt - dt);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        xitionBg.dispose();
    }

    protected void doEvents() {
        Display.getCurrent().readAndDispatch();
    }

    protected abstract void initTransition(Image var1, Image var2, GC var3, double var4);

    protected abstract void stepTransition(long var1, Image var3, Image var4, GC var5, double var6);

    protected abstract void endTransition(Image var1, Image var2, GC var3, double var4);

    private class TransitionPainter
    implements PaintListener {
        private static final int TRANSITION_INIT = 0;
        private static final int TRANSITION_STEP = 1;
        private static final int TRANSITION_END = 2;
        private boolean _isEnabled = false;
        private int _transition = -1;
        private GC _gc;
        private Canvas _canvas;
        private final Image _from;
        private final Image _to;
        private final double _direction;
        private final Image _xitionBg;
        private Image _xitionImg;
        private GC _xitionImgGC;

        private TransitionPainter(Canvas canvas, Image from, Image to, double direction, Image xitionBg) {
            this._canvas = canvas;
            this._from = from;
            this._to = to;
            this._direction = direction;
            this._xitionBg = xitionBg;
        }

        private void initXitionImg(Display display) {
            this._xitionImg = new Image((Device)display, this._from.getBounds().width, this._from.getBounds().height);
            this._xitionImgGC = new GC((Drawable)this._xitionImg);
        }

        private void disposeXitionImg() {
            this._xitionImg.dispose();
            this._xitionImgGC.dispose();
        }

        public void paintTransition(int transition) {
            this._transition = transition;
            if (!IS_LINUX_OS) {
                if (this._transition == 0) {
                    this._canvas.addPaintListener((PaintListener)this);
                }
                this._isEnabled = true;
                this._canvas.redraw();
                this._canvas.getDisplay().update();
                this._canvas.getDisplay().readAndDispatch();
                this._isEnabled = false;
                if (this._transition == 2) {
                    this._canvas.removePaintListener((PaintListener)this);
                }
            } else {
                if (this._transition == 0) {
                    this.initXitionImg(this._canvas.getDisplay());
                    this._gc = new GC((Drawable)this._canvas);
                }
                this.paintTransition(this._xitionImgGC, this._transition);
                this._gc.drawImage(this._xitionImg, 0, 0);
                if (this._transition == 2) {
                    this.disposeXitionImg();
                    this._gc.dispose();
                }
            }
        }

        public void paintControl(PaintEvent e) {
            if (this._isEnabled) {
                this.initXitionImg(e.display);
                this.paintTransition(this._xitionImgGC, this._transition);
                e.gc.drawImage(this._xitionImg, 0, 0);
                this.disposeXitionImg();
            }
        }

        private void paintTransition(GC gc, int transition) {
            switch (transition) {
                case 0: {
                    gc.drawImage(this._xitionBg, 0, 0);
                    gc.drawImage(this._from, 0, 0);
                    Transition.this.initTransition(this._from, this._to, gc, this._direction);
                    break;
                }
                case 1: {
                    gc.drawImage(this._xitionBg, 0, 0);
                    Transition.this.stepTransition(Transition.this._t, this._from, this._to, gc, this._direction);
                    break;
                }
                case 2: {
                    gc.drawImage(this._xitionBg, 0, 0);
                    gc.drawImage(this._to, 0, 0);
                    Transition.this.endTransition(this._from, this._to, gc, this._direction);
                    break;
                }
            }
        }
    }
}

