/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.led;

import java.time.LocalDateTime;
import org.eclipse.nebula.widgets.led.DotsLed;
import org.eclipse.nebula.widgets.led.LED;
import org.eclipse.nebula.widgets.led.LEDCharacter;
import org.eclipse.nebula.widgets.led.LEDSeparator;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class LEDSnippet {
    private static Shell shell;

    public static void main(String[] args) {
        Display display = new Display();
        shell = new Shell(display);
        shell.setText("LED Snippet");
        shell.setLayout((Layout)new GridLayout(1, true));
        shell.setBackground(display.getSystemColor(1));
        LEDSnippet.createTopPart();
        LEDSnippet.createBottomPart();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createTopPart() {
        new Label((Composite)shell, 0);
        Composite top = new Composite((Composite)shell, 0);
        top.setLayoutData((Object)new GridData(4, 2, true, false));
        top.setLayout((Layout)new GridLayout(2, true));
        LED led = new LED(top, 1);
        led.setLayoutData((Object)new GridData(3, 4, true, true, 1, 2));
        led.setCharacter(LEDCharacter.CLEAR);
        Color idleColor = new Color((Device)shell.getDisplay(), 60, 60, 60);
        led.setIdleColor(idleColor);
        SWTGraphicUtil.addDisposer((Widget)led, (Resource)idleColor);
        Color selectedColor = new Color((Device)shell.getDisplay(), 255, 0, 0);
        led.setSelectedColor(selectedColor);
        SWTGraphicUtil.addDisposer((Widget)led, (Resource)selectedColor);
        Combo combo = new Combo(top, 8);
        GridData gdCombo = new GridData(1, 2, true, false);
        gdCombo.minimumWidth = 100;
        combo.setLayoutData((Object)gdCombo);
        LEDCharacter[] lEDCharacterArray = LEDCharacter.values();
        int n = lEDCharacterArray.length;
        int n2 = 0;
        while (n2 < n) {
            LEDCharacter element = lEDCharacterArray[n2];
            combo.add(element.name());
            ++n2;
        }
        combo.setText("CLEAR");
        combo.addListener(13, e -> {
            LEDCharacter c = LEDCharacter.valueOf((String)combo.getText());
            led.setCharacter(c);
        });
        Button checkBox = new Button(top, 32);
        checkBox.setLayoutData((Object)new GridData(1, 1, false, false));
        checkBox.setText("Dot ?");
        checkBox.addListener(13, e -> led.setShowDot(checkBox.getSelection()));
        new Label((Composite)shell, 0);
    }

    private static void createBottomPart() {
        Composite bottom = new Composite((Composite)shell, 0);
        bottom.setLayoutData((Object)new GridData(4, 2, true, false));
        bottom.setLayout((Layout)new GridLayout(8, false));
        bottom.setBackground(shell.getDisplay().getSystemColor(2));
        final LED day1 = new LED(bottom, 0);
        day1.setLayoutData((Object)new GridData(3, 4, true, false));
        final LED day2 = new LED(bottom, 0);
        day2.setLayoutData((Object)new GridData(4, 4, false, false));
        LEDSeparator dash1 = new LEDSeparator(bottom, 0);
        dash1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED month1 = new LED(bottom, 0);
        month1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED month2 = new LED(bottom, 0);
        month2.setLayoutData((Object)new GridData(4, 4, false, false));
        LEDSeparator dash2 = new LEDSeparator(bottom, 0);
        dash2.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED year1 = new LED(bottom, 0);
        year1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED year2 = new LED(bottom, 0);
        year2.setLayoutData((Object)new GridData(1, 4, true, false));
        final LED hour1 = new LED(bottom, 0);
        hour1.setLayoutData((Object)new GridData(3, 4, true, false));
        final LED hour2 = new LED(bottom, 0);
        hour2.setLayoutData((Object)new GridData(4, 4, false, false));
        final DotsLed dots1 = new DotsLed(bottom, 0);
        dots1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED min1 = new LED(bottom, 0);
        min1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED min2 = new LED(bottom, 0);
        min2.setLayoutData((Object)new GridData(4, 4, false, false));
        final DotsLed dots2 = new DotsLed(bottom, 0);
        dots2.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED sec1 = new LED(bottom, 0);
        sec1.setLayoutData((Object)new GridData(4, 4, false, false));
        final LED sec2 = new LED(bottom, 0);
        sec2.setLayoutData((Object)new GridData(1, 4, true, false));
        shell.getDisplay().timerExec(0, new Runnable(){
            boolean highligtDash = false;

            @Override
            public void run() {
                LocalDateTime now = LocalDateTime.now();
                day1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getDayOfMonth())));
                day2.setCharacter(LEDCharacter.getByNumber((int)(now.getDayOfMonth() % 10)));
                month1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getMonthValue())));
                month2.setCharacter(LEDCharacter.getByNumber((int)(now.getMonthValue() % 10)));
                year1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getYear() % 100)));
                year2.setCharacter(LEDCharacter.getByNumber((int)(now.getYear() % 10)));
                hour1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getHour())));
                hour2.setCharacter(LEDCharacter.getByNumber((int)(now.getHour() % 10)));
                min1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getMinute())));
                min2.setCharacter(LEDCharacter.getByNumber((int)(now.getMinute() % 10)));
                sec1.setCharacter(LEDCharacter.getByNumber((int)this.getMajorDigit(now.getSecond())));
                sec2.setCharacter(LEDCharacter.getByNumber((int)(now.getSecond() % 10)));
                if (this.highligtDash) {
                    dots1.switchOn();
                    dots2.switchOn();
                } else {
                    dots1.switchOff();
                    dots2.switchOff();
                }
                this.highligtDash = !this.highligtDash;
                shell.getDisplay().timerExec(1000, (Runnable)this);
            }

            private int getMajorDigit(int value) {
                return (value - value % 10) / 10;
            }
        });
    }
}

