/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.ctreecombo.CTreeCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CTreeComboItem
extends Item {
    static final String DATA_ID = "org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem";
    private CTreeCombo parent;
    private CTreeComboItem parentItem;
    private List<CTreeComboItem> childItems = new ArrayList<CTreeComboItem>();
    private TreeItem realTreeItem;

    public CTreeComboItem(CTreeComboItem parentItem, int style, int index) {
        super((Widget)parentItem.parent, style);
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parentItem.childItems.add(index, this);
        if (parentItem.realTreeItem != null && !parentItem.realTreeItem.isDisposed()) {
            this.setRealTreeItem(new TreeItem(parentItem.realTreeItem, style, index));
        }
    }

    public CTreeComboItem(CTreeComboItem parentItem, int style) {
        super((Widget)parentItem.parent, style);
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parentItem.childItems.add(this);
        if (parentItem.realTreeItem != null && !parentItem.realTreeItem.isDisposed()) {
            this.setRealTreeItem(new TreeItem(parentItem.realTreeItem, style));
        }
    }

    public CTreeComboItem(CTreeCombo parent, int style, int index) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parent.items.add(index, this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeItem(new TreeItem(this.parent.tree, style, index));
        }
    }

    public CTreeComboItem(CTreeCombo parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parent.items.add(this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeItem(new TreeItem(this.parent.tree, style));
        }
    }

    public void dispose() {
        super.dispose();
        if (this.realTreeItem != null && !this.realTreeItem.isDisposed()) {
            this.realTreeItem.dispose();
        }
        if (this.parentItem != null && !this.parentItem.isDisposed()) {
            this.parentItem.childItems.remove((Object)this);
        }
        for (CTreeComboItem i : this.childItems) {
            i.dispose();
        }
    }

    void setRealTreeItem(TreeItem realTreeItem) {
        this.realTreeItem = realTreeItem;
        this.realTreeItem.setData(DATA_ID, (Object)this);
    }

    TreeItem getRealTreeItem() {
        return this.realTreeItem;
    }

    public CTreeComboItem[] getItems() {
        this.checkWidget();
        return this.childItems.toArray(new CTreeComboItem[0]);
    }

    private boolean checkRealItem() {
        return this.realTreeItem != null && !this.realTreeItem.isDisposed();
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (this.checkRealItem()) {
            this.realTreeItem.setImage(image);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        super.setText(string);
        if (this.checkRealItem()) {
            this.realTreeItem.setText(string);
        }
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getBounds(index);
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getBounds();
        }
        return null;
    }

    public CTreeCombo getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getBackground(index);
        }
        return null;
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getFont(index);
        }
        return null;
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getForeground(index);
        }
        return null;
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getImage(index);
        }
        return null;
    }

    public String getText(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getText(index);
        }
        return null;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setBackground(index, color);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setBackground(color);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setFont(font);
        }
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setFont(index, font);
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setForeground(index, color);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setForeground(color);
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setImage(index, image);
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setText(index, string);
        }
    }

    public CTreeComboItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public boolean getExpanded() {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getExpanded();
        }
        return false;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.childItems.size();
    }

    public CTreeComboItem getItem(int index) {
        this.checkWidget();
        return this.childItems.get(index);
    }

    public int indexOf(CTreeComboItem item) {
        this.checkWidget();
        return this.childItems.indexOf((Object)item);
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getBounds(index);
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getImageBounds(index);
        }
        return null;
    }

    public void setExpanded(boolean expand) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setExpanded(expand);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setItemCount(count);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.realTreeItem.clear(index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.realTreeItem.clearAll(all);
    }
}

