/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.carousel;

import java.util.List;
import org.eclipse.nebula.widgets.carousel.Carousel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

class ImageContainer
extends Canvas {
    private Image image;
    private Image scrollImage;
    private Carousel carousel;
    private int slider;

    public ImageContainer(Carousel parent, int style) {
        super((Composite)parent, 0x20000000);
        this.carousel = parent;
        this.slider = -1;
        this.addListener(9, e -> {
            GC gc = e.gc;
            gc.setAntialias(1);
            gc.setInterpolation(2);
            if (this.image == null) {
                return;
            }
            Rectangle clientArea = this.getClientArea();
            if (this.slider == -1) {
                Rectangle imageBounds = this.image.getBounds();
                if (imageBounds.width > clientArea.width || imageBounds.height > clientArea.height) {
                    Point point = this.reduceImageSoItFits(this.image);
                    int newWidth = point.x;
                    int newHeight = point.y;
                    gc.drawImage(this.image, 0, 0, imageBounds.width, imageBounds.height, (clientArea.width - newWidth) / 2, (clientArea.height - newHeight) / 2, newWidth, newHeight);
                } else {
                    gc.drawImage(this.image, (clientArea.width - imageBounds.width) / 2, (clientArea.height - imageBounds.height) / 2);
                }
                return;
            }
            gc.drawImage(this.scrollImage, this.slider, 0, clientArea.width, clientArea.height, 0, 0, clientArea.width, clientArea.height);
        });
    }

    private Point reduceImageSoItFits(Image img) {
        Rectangle clientArea = this.getClientArea();
        Rectangle imageBounds = img.getBounds();
        float ratio = (float)imageBounds.width * 1.0f / (float)imageBounds.height * 1.0f;
        int newWidth = imageBounds.width;
        int newHeight = imageBounds.height;
        while (newWidth > clientArea.width - 5 || newHeight > clientArea.height - 5) {
            newWidth = (int)((float)newWidth * 0.9f);
            newHeight = (int)((float)newWidth / ratio);
        }
        return new Point(newWidth, newHeight);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point superSize = super.computeSize(wHint, hHint, changed);
        int width = 0;
        int height = 0;
        List<Image> images = ((Carousel)this.getParent()).getImages();
        for (Image image : images) {
            Rectangle rect = image.getBounds();
            width = Math.max(width, rect.width);
            height = Math.max(height, rect.height);
        }
        return new Point(Math.max(superSize.x, width), Math.max(superSize.y, height));
    }

    void setImage(Image image) {
        this.image = image;
    }

    void moveTo(int newSelection) {
        int direction = newSelection > this.carousel.getSelection() ? 16384 : 131072;
        this.slide(newSelection, direction);
        this.carousel.selection = newSelection;
        this.fireSelectionEvent();
        this.carousel.imageSelector.redraw();
    }

    void moveNext() {
        int newSelection = this.carousel.selection + 1;
        if (newSelection == this.carousel.getImages().size()) {
            newSelection = 0;
        }
        this.slide(newSelection, 16384);
        this.carousel.selection = newSelection;
        this.fireSelectionEvent();
        this.carousel.imageSelector.redraw();
    }

    private void slide(int target, final int direction) {
        final int width = this.getClientArea().width;
        int n = this.slider = direction == 16384 ? 0 : width;
        if (direction == 16384) {
            this.createScrolledImage(this.image, this.carousel.getImages().get(target));
        } else {
            this.createScrolledImage(this.carousel.getImages().get(target), this.image);
        }
        this.getDisplay().timerExec(200, new Runnable(){

            @Override
            public void run() {
                ImageContainer.this.redraw();
                int step = width / 5;
                if (direction == 16384) {
                    ImageContainer imageContainer = ImageContainer.this;
                    imageContainer.slider = imageContainer.slider + step;
                    if (ImageContainer.this.slider >= width) {
                        ImageContainer.this.slider = -1;
                        ImageContainer.this.scrollImage.dispose();
                        return;
                    }
                } else {
                    ImageContainer imageContainer = ImageContainer.this;
                    imageContainer.slider = imageContainer.slider - step;
                    if (ImageContainer.this.slider <= 0) {
                        ImageContainer.this.slider = -1;
                        ImageContainer.this.scrollImage.dispose();
                        return;
                    }
                }
                ImageContainer.this.getDisplay().timerExec(50, (Runnable)this);
            }
        });
        this.image = this.carousel.getImages().get(target);
        this.redraw();
    }

    private void createScrolledImage(Image left, Image right) {
        Rectangle clientArea = this.getClientArea();
        this.scrollImage = new Image((Device)this.getDisplay(), clientArea.width * 2, clientArea.height);
        GC gc = new GC((Drawable)this.scrollImage);
        gc.setInterpolation(2);
        gc.setBackground(this.carousel.getBackground());
        gc.fillRectangle(0, 0, clientArea.width * 2, clientArea.height);
        Rectangle leftImageBounds = left.getBounds();
        if (leftImageBounds.width > clientArea.width || leftImageBounds.height > clientArea.height) {
            Point point = this.reduceImageSoItFits(left);
            int newWidth = point.x;
            int newHeight = point.y;
            gc.drawImage(left, 0, 0, leftImageBounds.width, leftImageBounds.height, (clientArea.width - newWidth) / 2, (clientArea.height - newHeight) / 2, newWidth, newHeight);
        } else {
            gc.drawImage(left, (clientArea.width - leftImageBounds.width) / 2, (clientArea.height - leftImageBounds.height) / 2);
        }
        Rectangle rightImageBounds = right.getBounds();
        if (rightImageBounds.width > clientArea.width || rightImageBounds.height > clientArea.height) {
            Point point = this.reduceImageSoItFits(right);
            int newWidth = point.x;
            int newHeight = point.y;
            gc.drawImage(right, 0, 0, rightImageBounds.width, rightImageBounds.height, clientArea.width + (clientArea.width - newWidth) / 2, (clientArea.height - newHeight) / 2, newWidth, newHeight);
        } else {
            gc.drawImage(right, clientArea.width + (clientArea.width - rightImageBounds.width) / 2, (clientArea.height - rightImageBounds.height) / 2);
        }
        gc.dispose();
    }

    private void fireSelectionEvent() {
        Event e = new Event();
        e.widget = this.carousel;
        e.display = this.getDisplay();
        e.index = this.carousel.selection;
        e.type = 13;
        SelectionEvent event = new SelectionEvent(e);
        for (SelectionListener listener : this.carousel.selectionListeners) {
            listener.widgetSelected(event);
            if (!event.doit) break;
        }
    }

    void movePrevious() {
        Carousel carousel = (Carousel)this.getParent();
        int newSelection = carousel.selection - 1;
        if (newSelection == -1) {
            newSelection = carousel.getImages().size() - 1;
        }
        this.slide(newSelection, 131072);
        carousel.selection = newSelection;
        this.fireSelectionEvent();
        carousel.imageSelector.redraw();
    }
}

