/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.dialog.ChoiceItem;
import org.eclipse.nebula.widgets.opal.dialog.FooterArea;
import org.eclipse.nebula.widgets.opal.dialog.MessageArea;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class Dialog {
    private CenterOption centerPolicy = CenterOption.CENTER_ON_SCREEN;
    private String title;
    OpalDialogType buttonType;
    private final MessageArea messageArea;
    private final FooterArea footerArea;
    final Shell shell;
    private int minimumWidth = 400;
    private int minimumHeight = 150;
    private Point lastSize;

    public Dialog() {
        this(null);
    }

    public Dialog(boolean resizable) {
        this(null, resizable);
    }

    public Dialog(Shell parent) {
        this(parent, true);
    }

    public Dialog(Shell parent, boolean resizable) {
        if (parent == null) {
            this.shell = new Shell(Display.getCurrent(), 0x10860 | (resizable ? 16 : 0));
        } else {
            this.shell = new Shell(parent, 0x10860 | (resizable ? 16 : 0));
            if (parent.getImage() != null) {
                this.shell.setImage(parent.getImage());
            }
        }
        this.messageArea = new MessageArea(this);
        this.footerArea = new FooterArea(this);
    }

    public int show() {
        GridLayout gd = new GridLayout(1, true);
        gd.horizontalSpacing = 0;
        gd.verticalSpacing = 0;
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        this.shell.setLayout((Layout)gd);
        this.messageArea.render();
        this.footerArea.render();
        if (this.title != null) {
            this.shell.setText(this.title);
        }
        this.pack();
        this.center();
        this.shell.setMinimumSize(this.shell.computeSize(this.minimumWidth, -1));
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.footerArea.getSelectedButton();
    }

    private void center() {
        int centerY;
        int centerX;
        Point preferredSize = this.shell.computeSize(-1, -1);
        if (preferredSize.x < this.minimumWidth) {
            preferredSize.x = this.minimumWidth;
        }
        if (preferredSize.y < this.minimumHeight) {
            preferredSize.y = this.minimumHeight;
        }
        if (this.centerPolicy == CenterOption.CENTER_ON_SCREEN || this.shell.getParent() == null) {
            Shell activeShell = this.shell.getDisplay().getActiveShell();
            Rectangle monitorBounds = SWTGraphicUtil.getBoundsOfMonitorOnWhichShellIsDisplayed((Shell)activeShell);
            centerX = monitorBounds.x + (monitorBounds.width - preferredSize.x) / 2;
            centerY = monitorBounds.y + (monitorBounds.height - preferredSize.y) / 2;
        } else {
            Shell parent = (Shell)this.shell.getParent();
            centerX = parent.getLocation().x + (parent.getSize().x - preferredSize.x) / 2;
            centerY = parent.getLocation().y + (parent.getSize().y - preferredSize.y) / 2;
        }
        this.shell.setBounds(centerX, centerY, preferredSize.x, preferredSize.y);
    }

    public void close() {
        this.shell.dispose();
    }

    void pack() {
        Point preferredSize = this.shell.computeSize(-1, -1);
        Rectangle bounds = this.shell.getBounds();
        preferredSize.x = Math.max(preferredSize.x, this.minimumWidth);
        preferredSize.y = Math.max(preferredSize.y, this.minimumHeight);
        if (this.lastSize != null) {
            preferredSize.x = Math.max(preferredSize.x, this.lastSize.x);
            preferredSize.y = Math.max(preferredSize.y, this.lastSize.y);
        }
        this.shell.setBounds(bounds.x, bounds.y, preferredSize.x, preferredSize.y);
        this.lastSize = null;
    }

    public static String ask(String title, String text, String defaultValue) {
        return Dialog.ask(null, title, text, defaultValue);
    }

    public static String ask(Shell shell, String title, String text, String defaultValue) {
        Dialog dialog = Dialog.buildAskDialog(shell, title, text, defaultValue);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getTextBoxValue();
        }
        return null;
    }

    public static Dialog buildAskDialog(Shell shell, String title, String text, String defaultValue) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"Input"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(4)).addTextBox(defaultValue);
        dialog.setButtonType(OpalDialogType.OK_CANCEL);
        return dialog;
    }

    public static void error(String title, String errorMessage) {
        Dialog.error(null, title, errorMessage);
    }

    public static void error(Shell shell, String title, String errorMessage) {
        Dialog.buildErrorDialog(shell, title, errorMessage).show();
    }

    public static Dialog buildErrorDialog(Shell shell, String title, String errorMessage) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"ApplicationError"));
        dialog.getMessageArea().setTitle(title).setText(errorMessage).setIcon(Display.getCurrent().getSystemImage(1));
        dialog.setButtonType(OpalDialogType.OK);
        return dialog;
    }

    public static void inform(String title, String text) {
        Dialog.inform(null, title, text);
    }

    public static void inform(Shell shell, String title, String text) {
        Dialog.buildInformDialog(shell, title, text).show();
    }

    public static Dialog buildInformDialog(Shell shell, String title, String text) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"Information"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(2));
        dialog.setButtonType(OpalDialogType.CLOSE);
        return dialog;
    }

    public static boolean isConfirmed(String title, String text) {
        return Dialog.isConfirmed(null, title, text, -1);
    }

    public static boolean isConfirmed(Shell shell, String title, String text) {
        return Dialog.isConfirmed(shell, title, text, -1);
    }

    public static boolean isConfirmed(String title, String text, int timer) {
        return Dialog.isConfirmed(null, title, text, timer);
    }

    public static boolean isConfirmed(Shell shell, String title, String text, int timer) {
        return Dialog.buildConfirmDialog(shell, title, text, timer).show() == 0;
    }

    public static Dialog buildConfirmDialog(Shell shell, String title, String text, int timer) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"Warning"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(8));
        dialog.getFooterArea().setTimer(timer).setTimerIndexButton(0);
        dialog.setButtonType(OpalDialogType.YES_NO);
        return dialog;
    }

    public static int radioChoice(String title, String text, int defaultSelection, String ... values) {
        return Dialog.radioChoice(null, title, text, defaultSelection, values);
    }

    public static int radioChoice(Shell shell, String title, String text, int defaultSelection, String ... values) {
        Dialog dialog = Dialog.buildRadioChoiceDialog(shell, title, text, defaultSelection, values);
        if (dialog.show() == 0) {
            return dialog.getMessageArea().getRadioChoice();
        }
        return -1;
    }

    public static Dialog buildRadioChoiceDialog(Shell shell, String title, String text, int defaultSelection, String ... values) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"Choice"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(4)).addRadioButtons(defaultSelection, values);
        dialog.setButtonType(OpalDialogType.SELECT_CANCEL);
        return dialog;
    }

    public static void showException(Throwable exception) {
        Dialog.buildExceptionDialog(exception).show();
    }

    public static Dialog buildExceptionDialog(Throwable exception) {
        Dialog dialog = new Dialog();
        dialog.setTitle(ResourceManager.getLabel((String)"Exception"));
        String msg = exception.getMessage();
        String className = exception.getClass().getName();
        boolean noMessage = msg == null || msg.trim().length() == 0;
        dialog.getMessageArea().setTitle(noMessage ? className : msg).setText(noMessage ? "" : className).setIcon(Display.getCurrent().getSystemImage(1)).setException(exception);
        dialog.getFooterArea().setExpanded(true);
        dialog.setButtonType(OpalDialogType.CLOSE);
        return dialog;
    }

    public static int choice(String title, String text, int defaultSelection, ChoiceItem ... items) {
        return Dialog.choice(null, title, text, defaultSelection, items);
    }

    public static int choice(Shell shell, String title, String text, int defaultSelection, ChoiceItem ... items) {
        Dialog dialog = Dialog.buildChoiceDialog(shell, title, text, defaultSelection, items);
        dialog.show();
        return dialog.getMessageArea().getChoice();
    }

    public static Dialog buildChoiceDialog(Shell shell, String title, String text, int defaultSelection, ChoiceItem ... items) {
        Dialog dialog = new Dialog(shell);
        dialog.setTitle(ResourceManager.getLabel((String)"Choice"));
        dialog.getMessageArea().setTitle(title).setText(text).setIcon(Display.getCurrent().getSystemImage(4)).addChoice(defaultSelection, items);
        dialog.setButtonType(OpalDialogType.NONE);
        return dialog;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public OpalDialogType getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(OpalDialogType buttonType) {
        this.buttonType = buttonType;
        switch (buttonType) {
            case CLOSE: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel((String)"Close")).setDefaultButtonIndex(0);
                break;
            }
            case NO_BUTTON: {
                break;
            }
            case OK: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel((String)"Ok")).setDefaultButtonIndex(0);
                break;
            }
            case OK_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel((String)"Ok"), ResourceManager.getLabel((String)"Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case SELECT_CANCEL: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel((String)"Select"), ResourceManager.getLabel((String)"Cancel")).setDefaultButtonIndex(-1);
                break;
            }
            case YES_NO: {
                this.footerArea.setButtonLabels(ResourceManager.getLabel((String)"Yes"), ResourceManager.getLabel((String)"No")).setDefaultButtonIndex(0);
                break;
            }
        }
    }

    public MessageArea getMessageArea() {
        return this.messageArea;
    }

    public FooterArea getFooterArea() {
        return this.footerArea;
    }

    public Shell getShell() {
        return this.shell;
    }

    public int getSelectedButton() {
        return this.getFooterArea().getSelectedButton();
    }

    public boolean getCheckboxValue() {
        return this.footerArea.getCheckBoxValue();
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public CenterOption getCenterPolicy() {
        return this.centerPolicy;
    }

    public void setCenterPolicy(CenterOption centerPolicy) {
        this.centerPolicy = centerPolicy;
    }

    void setLastSize(Point lastSize) {
        this.lastSize = lastSize;
    }

    public static enum CenterOption {
        CENTER_ON_SCREEN,
        CENTER_ON_DIALOG;

    }

    public static enum OpalDialogType {
        CLOSE,
        YES_NO,
        OK,
        OK_CANCEL,
        SELECT_CANCEL,
        NO_BUTTON,
        OTHER,
        NONE;

    }
}

