/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.dialog.Dialog;
import org.eclipse.nebula.widgets.opal.dialog.DialogArea;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class FooterArea
extends DialogArea {
    private static final int BUTTON_WIDTH = 70;
    private Image icon;
    private String footerText;
    private List<String> buttonLabels;
    private int defaultButtonIndex;
    private int timer = -1;
    private int timerIndexButton = -1;
    int selectedButtonIndex = -1;
    private String collapsedLabelText;
    private String expandedLabelText;
    private boolean expanded;
    private String detailText;
    private boolean details;
    private Button disabledButton;
    private String checkBoxLabel;
    private boolean checkBoxValue;
    private Text expandedPanel;
    private Composite composite;
    private ToolBar toolbar;
    private List<FooterAction> footerActions = new ArrayList<FooterAction>();

    public FooterArea(Dialog parent) {
        super(parent);
        this.expandedLabelText = ResourceManager.getLabel((String)"FewerDetails");
        this.collapsedLabelText = ResourceManager.getLabel((String)"MoreDetails");
    }

    public FooterArea addCheckBox(String label, boolean selection) {
        this.checkBoxLabel = label;
        this.checkBoxValue = selection;
        this.setInitialised(true);
        return this;
    }

    @Override
    void render() {
        int numberOfColumns;
        if (!this.isInitialised()) {
            return;
        }
        this.createSeparator();
        this.composite = new Composite((Composite)this.parent.shell, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.composite.setBackground(this.getGreyColor());
        int n = numberOfColumns = this.buttonLabels == null ? 0 : this.buttonLabels.size();
        if (this.details || !this.footerActions.isEmpty()) {
            ++numberOfColumns;
        }
        GridLayout gridLayout = new GridLayout(numberOfColumns, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.composite.setLayout((Layout)gridLayout);
        if (this.details || !this.footerActions.isEmpty()) {
            gridLayout.marginHeight = 5;
            this.toolbar = new ToolBar(this.composite, 0);
        }
        if (this.details) {
            this.createDetails(numberOfColumns);
        }
        if (!this.footerActions.isEmpty()) {
            this.createFooterActions();
        }
        if (this.buttonLabels != null) {
            this.createButtons();
        }
        if (this.details && this.parent.getMessageArea().getException() == null && this.expanded) {
            this.createExpandedPanel(numberOfColumns);
        }
        if (this.checkBoxLabel != null) {
            this.createCheckBox(numberOfColumns);
        }
        if (this.footerText != null) {
            this.createFooter();
        }
    }

    private void createButtons() {
        Button defaultButton = null;
        int i = 0;
        while (i < this.buttonLabels.size()) {
            Button button = new Button(this.composite, 8);
            button.setText(this.buttonLabels.get(i));
            GridData gd = new GridData(3, 2, i == 0, false);
            int defaultWidth = button.computeSize((int)-1, (int)-1).x;
            gd.minimumWidth = Math.max(70, defaultWidth);
            gd.widthHint = Math.max(70, defaultWidth);
            button.setLayoutData((Object)gd);
            if (i == this.defaultButtonIndex) {
                defaultButton = button;
            }
            Integer integer = i;
            button.addListener(13, e -> {
                this.parent.shell.dispose();
                this.selectedButtonIndex = integer;
            });
            if (i == this.timerIndexButton && this.timer != -1) {
                this.disabledButton = button;
                button.setData((Object)button.getText());
                button.setText(String.valueOf(button.getText()) + " (" + this.timer + ")");
                button.setEnabled(false);
                int newWidth = button.computeSize((int)-1, (int)-1).x;
                gd.minimumWidth = Math.max(70, newWidth);
                gd.widthHint = Math.max(70, newWidth);
                button.getParent().layout(new Control[]{button});
            }
            ++i;
        }
        if (this.timerIndexButton != -1 && this.timer != -1) {
            Display.getCurrent().timerExec(1000, new Runnable(){

                @Override
                public void run() {
                    FooterArea footerArea = FooterArea.this;
                    footerArea.timer = footerArea.timer - 1;
                    if (FooterArea.this.disabledButton.isDisposed()) {
                        return;
                    }
                    if (FooterArea.this.timer == 0) {
                        FooterArea.this.disabledButton.setText((String)FooterArea.this.disabledButton.getData());
                        FooterArea.this.disabledButton.setEnabled(true);
                    } else {
                        FooterArea.this.disabledButton.setText(FooterArea.this.disabledButton.getData() + " (" + FooterArea.this.timer + ")");
                        GridData gd = (GridData)FooterArea.this.disabledButton.getLayoutData();
                        int defaultWidth = ((FooterArea)FooterArea.this).disabledButton.computeSize((int)-1, (int)-1).x;
                        gd.minimumWidth = Math.max(70, defaultWidth);
                        gd.widthHint = Math.max(70, defaultWidth);
                        FooterArea.this.disabledButton.getParent().layout(new Control[]{FooterArea.this.disabledButton});
                        Display.getCurrent().timerExec(1000, (Runnable)this);
                    }
                }
            });
        }
        this.parent.shell.setDefaultButton(defaultButton);
    }

    private void createDetails(int numberOfColumns) {
        final ToolItem detailsItem = new ToolItem(this.toolbar, 0);
        detailsItem.setImage(this.isExpanded() ? this.getFewerDetailsImage() : this.getMoreDetailsImage());
        detailsItem.setText(this.isExpanded() ? this.expandedLabelText : this.collapsedLabelText);
        final int numberOfColumnsParam = numberOfColumns;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (FooterArea.this.parent.getMessageArea().getException() != null) {
                    if (detailsItem.getText().equals(FooterArea.this.expandedLabelText)) {
                        detailsItem.setText(FooterArea.this.collapsedLabelText);
                        detailsItem.setImage(FooterArea.this.getMoreDetailsImage());
                        FooterArea.this.parent.getMessageArea().hideException();
                    } else {
                        detailsItem.setText(FooterArea.this.expandedLabelText);
                        detailsItem.setImage(FooterArea.this.getFewerDetailsImage());
                        FooterArea.this.parent.getMessageArea().showException();
                    }
                } else if (detailsItem.getText().equals(FooterArea.this.expandedLabelText)) {
                    detailsItem.setText(FooterArea.this.collapsedLabelText);
                    detailsItem.setImage(FooterArea.this.getMoreDetailsImage());
                    FooterArea.this.expandedPanel.dispose();
                    FooterArea.this.parent.pack();
                } else {
                    detailsItem.setText(FooterArea.this.expandedLabelText);
                    detailsItem.setImage(FooterArea.this.getFewerDetailsImage());
                    FooterArea.this.createExpandedPanel(numberOfColumnsParam);
                    FooterArea.this.parent.pack();
                }
            }
        };
        detailsItem.addListener(13, listener);
    }

    private void createFooterActions() {
        for (FooterAction action : this.footerActions) {
            ToolItem item = new ToolItem(this.toolbar, 0);
            item.setText(action.getLabel());
            item.addListener(13, e -> action.getAction().accept(this.parent));
            if (action.getActive().isPresent()) {
                item.setImage(action.getActive().get());
            }
            if (action.getInactive().isPresent()) {
                item.setDisabledImage(action.getInactive().get());
            }
            if (!action.getHot().isPresent()) continue;
            item.setHotImage(action.getHot().get());
        }
    }

    private void createCheckBox(int numberOfColumns) {
        Button button = new Button(this.composite, 32);
        button.setText(this.checkBoxLabel);
        button.setSelection(this.checkBoxValue);
        button.setBackground(this.getGreyColor());
        button.setLayoutData((Object)new GridData(1, 2, true, false, numberOfColumns, 1));
        button.addListener(13, e -> {
            this.checkBoxValue = button.getSelection();
        });
    }

    private void createFooter() {
        this.createSeparator();
        Composite informationComposite = new Composite((Composite)this.parent.shell, 0);
        informationComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        informationComposite.setBackground(this.getGreyColor());
        informationComposite.setLayout((Layout)new GridLayout(this.icon == null ? 1 : 2, false));
        if (this.icon != null) {
            Label labelIcon = new Label(informationComposite, 0);
            labelIcon.setBackground(this.getGreyColor());
            labelIcon.setImage(this.icon);
            labelIcon.setLayoutData((Object)new GridData(2, 2, false, false));
        }
        Label labelText = new Label(informationComposite, 0);
        labelText.setBackground(this.getGreyColor());
        labelText.setText(this.footerText);
        labelText.setLayoutData((Object)new GridData(4, 2, true, false));
    }

    private void createExpandedPanel(int numberOfColumns) {
        this.expandedPanel = new Text(this.composite, 2826);
        this.expandedPanel.setText(this.detailText);
        this.expandedPanel.setBackground(this.getGreyColor());
        GridData gd = new GridData(4, 4, false, false, numberOfColumns, 1);
        gd.heightHint = 150;
        gd.minimumHeight = 150;
        this.expandedPanel.setLayoutData((Object)gd);
    }

    private void createSeparator() {
        Composite c = new Composite((Composite)this.parent.shell, 0);
        c.setLayoutData((Object)new GridData(4, 4, true, false));
        c.setBackground(this.getGreyColor());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        c.setLayout((Layout)gridLayout);
        Label separator = new Label(c, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    public Image getIcon() {
        return this.icon;
    }

    public FooterArea setIcon(Image icon) {
        this.icon = icon;
        this.setInitialised(true);
        return this;
    }

    public String getFooterText() {
        return this.footerText;
    }

    public FooterArea setFooterText(String text) {
        this.footerText = text;
        this.setInitialised(true);
        return this;
    }

    public List<String> getButtonLabels() {
        return this.buttonLabels;
    }

    public FooterArea setButtonLabels(List<String> buttonLabels) {
        this.buttonLabels = buttonLabels;
        this.setInitialised(true);
        return this;
    }

    public FooterArea setButtonLabels(String ... buttonLabels) {
        this.buttonLabels = Arrays.asList(buttonLabels);
        this.setInitialised(true);
        return this;
    }

    public FooterArea addFooterAction(Supplier<String> label, Consumer<Dialog> action, Image ... images) {
        this.footerActions.add(new FooterAction(label, action, images));
        return this;
    }

    public int getDefaultButtonIndex() {
        return this.defaultButtonIndex;
    }

    public FooterArea setDefaultButtonIndex(int defaultButtonIndex) {
        this.defaultButtonIndex = defaultButtonIndex;
        this.setInitialised(true);
        return this;
    }

    public int getTimer() {
        return this.timer;
    }

    public FooterArea setTimer(int timer) {
        this.timer = timer;
        this.setInitialised(true);
        return this;
    }

    public int getTimerIndexButton() {
        return this.timerIndexButton;
    }

    public FooterArea setTimerIndexButton(int timerIndexButton) {
        this.timerIndexButton = timerIndexButton;
        this.setInitialised(true);
        return this;
    }

    int getSelectedButton() {
        return this.selectedButtonIndex;
    }

    public String getCollapsedLabelText() {
        return this.collapsedLabelText;
    }

    public FooterArea setCollapsedLabelText(String collapsedLabelText) {
        this.details = true;
        this.collapsedLabelText = collapsedLabelText;
        this.setInitialised(true);
        return this;
    }

    public String getExpandedLabelText() {
        return this.expandedLabelText;
    }

    public FooterArea setExpandedLabelText(String expandedLabelText) {
        this.details = true;
        this.expandedLabelText = expandedLabelText;
        this.setInitialised(true);
        return this;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public FooterArea setExpanded(boolean expanded) {
        this.details = true;
        this.expanded = expanded;
        this.setInitialised(true);
        return this;
    }

    public String getDetailText() {
        return this.detailText;
    }

    public FooterArea setDetailText(String detailText) {
        this.details = true;
        this.detailText = detailText;
        this.setInitialised(true);
        return this;
    }

    public boolean getCheckBoxValue() {
        return this.checkBoxValue;
    }

    private class FooterAction {
        private Consumer<Dialog> action;
        private Image active;
        private Image inactive;
        private Image hot;
        private Supplier<String> label;

        public FooterAction(Supplier<String> label, Consumer<Dialog> action, Image ... images) {
            this.label = label;
            this.action = action;
            if (images.length > 0) {
                this.active = images[0];
            }
            if (images.length > 1) {
                this.hot = images[1];
            }
            if (images.length > 2) {
                this.inactive = images[2];
            }
        }

        public Consumer<Dialog> getAction() {
            return this.action;
        }

        public Optional<Image> getActive() {
            return Optional.ofNullable(this.active);
        }

        public Optional<Image> getInactive() {
            return Optional.ofNullable(this.inactive);
        }

        public Optional<Image> getHot() {
            return Optional.ofNullable(this.hot);
        }

        public String getLabel() {
            return this.label.get();
        }
    }
}

