/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.AbstractRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;

public class DefaultRowHeaderRenderer
extends AbstractRenderer {
    int leftMargin = 6;
    int rightMargin = 8;
    int topMargin = 3;
    int bottomMargin = 3;
    private TextLayout textLayout;
    private int truncationStyle = 0x1000000;

    @Override
    public void paint(GC gc, Object value) {
        GridItem item = (GridItem)((Object)value);
        String text = this.getHeaderText(item);
        if (this.getHeaderFont(item) == null) {
            gc.setFont(item.getParent().getFont());
        } else {
            gc.setFont(this.getHeaderFont(item));
        }
        Color background = this.getHeaderBackground(item);
        if (background == null) {
            background = this.getDisplay().getSystemColor(22);
        }
        gc.setBackground(background);
        if (this.isSelected() && item.getParent().getCellSelectionEnabled()) {
            gc.setBackground(item.getParent().getCellHeaderSelectionBackground());
        }
        gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height + 1);
        if (!item.getParent().getCellSelectionEnabled()) {
            if (this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(20));
            }
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y);
            gc.drawLine(this.getBounds().x, this.getBounds().y, this.getBounds().x, this.getBounds().y + this.getBounds().height - 1);
            if (!this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(19));
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + 1, this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2);
            }
            if (this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
            } else {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            }
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            if (!this.isSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(18));
                gc.drawLine(this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + 1, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
                gc.drawLine(this.getBounds().x + 1, this.getBounds().y + this.getBounds().height - 2, this.getBounds().x + this.getBounds().width - 2, this.getBounds().y + this.getBounds().height - 2);
            }
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(17));
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height - 1, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height - 1);
        }
        int x = this.leftMargin;
        Image image = this.getHeaderImage(item);
        if (image != null) {
            if (this.isSelected() && !item.getParent().getCellSelectionEnabled()) {
                gc.drawImage(image, x + 1, this.getBounds().y + 1 + (this.getBounds().height - image.getBounds().height) / 2);
                ++x;
            } else {
                gc.drawImage(image, x, this.getBounds().y + (this.getBounds().height - image.getBounds().height) / 2);
            }
            x += image.getBounds().width + 5;
        }
        int width = this.getBounds().width - x;
        width -= this.rightMargin;
        Color foreground = this.getHeaderForeground(item);
        if (foreground == null) {
            foreground = this.getDisplay().getSystemColor(21);
        }
        gc.setForeground(foreground);
        int y = this.getBounds().y;
        int selectionOffset = 0;
        if (this.isSelected() && !item.getParent().getCellSelectionEnabled()) {
            selectionOffset = 1;
        }
        if (!item.getParent().isWordWrapHeader()) {
            gc.drawString(TextUtils.getShortStr(gc, text, width, this.truncationStyle), this.getBounds().x + x + selectionOffset, (y += (this.getBounds().height - gc.stringExtent((String)text).y) / 2) + selectionOffset, true);
        } else {
            this.getTextLayout(gc, item);
            this.textLayout.setWidth(width < 1 ? 1 : width);
            this.textLayout.setText(text);
            if (item.getParent().isAutoHeight()) {
                int columnCount = item.getParent().getColumnCount();
                int maxHeight = this.textLayout.getBounds().height + this.topMargin + this.bottomMargin;
                int i = 0;
                while (i < columnCount) {
                    GridColumn column = item.getParent().getColumn(i);
                    if (column.getWordWrap()) {
                        int height = column.getCellRenderer().computeSize((GC)gc, (int)column.getWidth(), (int)-1, (Object)((Object)item)).y;
                        maxHeight = Math.max(maxHeight, height);
                    }
                    ++i;
                }
                if (maxHeight != item.getHeight()) {
                    item.setHeight(maxHeight);
                }
            }
            this.textLayout.draw(gc, this.getBounds().x + x + selectionOffset, y + selectionOffset);
        }
    }

    private Font getHeaderFont(GridItem item) {
        return item.getHeaderFont();
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridItem item = (GridItem)((Object)value);
        String text = this.getHeaderText(item);
        Image image = this.getHeaderImage(item);
        Font previousFont = gc.getFont();
        if (this.getHeaderFont(item) == null) {
            gc.setFont(item.getParent().getFont());
        } else {
            gc.setFont(this.getHeaderFont(item));
        }
        int x = this.leftMargin;
        if (image != null) {
            x += image.getBounds().width + 5;
        }
        int y = this.topMargin;
        y = image != null ? (y += Math.max(gc.getFontMetrics().getHeight(), image.getBounds().height)) : (y += gc.getFontMetrics().getHeight());
        gc.setFont(previousFont);
        return new Point(x += gc.stringExtent((String)text).x + this.rightMargin, y += this.bottomMargin);
    }

    private Image getHeaderImage(GridItem item) {
        return item.getHeaderImage();
    }

    private String getHeaderText(GridItem item) {
        String text = item.getHeaderText();
        if (text == null) {
            text = String.valueOf(item.getRowIndex() + 1);
        }
        return text;
    }

    private Color getHeaderBackground(GridItem item) {
        return item.getHeaderBackground();
    }

    private Color getHeaderForeground(GridItem item) {
        return item.getHeaderForeground();
    }

    private void getTextLayout(GC gc, GridItem gridItem) {
        if (this.textLayout == null) {
            this.textLayout = new TextLayout(gc.getDevice());
            this.textLayout.setFont(gc.getFont());
            gridItem.getParent().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    DefaultRowHeaderRenderer.this.textLayout.dispose();
                }
            });
        }
    }

    public int getTruncationStyle() {
        return this.truncationStyle;
    }

    public void setTruncationStyle(int truncationStyle) {
        this.truncationStyle = truncationStyle;
    }
}

