/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.columnbrowser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.opal.columnbrowser.ColumnItem;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ColumnBrowserWidget
extends ScrolledComposite {
    private final List<Table> columns;
    private final Composite composite = new Composite((Composite)this, 0);
    private final Image columnArrow;

    public ColumnBrowserWidget(Composite parent, int style) {
        super(parent, style | 0x100 | 0x200);
        RowLayout layout = new RowLayout(256);
        layout.spacing = 1;
        layout.pack = false;
        this.composite.setLayout((Layout)layout);
        this.columnArrow = SWTGraphicUtil.createImageFromFile((String)"images/columnArrow.png");
        this.columns = new ArrayList<Table>();
        int i = 0;
        while (i < 3) {
            this.createTable();
            ++i;
        }
        this.columns.get(0).setData((Object)new ColumnItem(this));
        this.setContent((Control)this.composite);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.setShowFocusedControl(true);
        this.updateContent();
        this.setMinSize(this.composite.computeSize(-1, -1));
        this.addDisposeListener(e -> SWTGraphicUtil.safeDispose((Resource)this.columnArrow));
    }

    private void createTable() {
        Table table = new Table(this.composite, 67844);
        new TableColumn(table, 16384);
        table.setLayoutData((Object)new RowData(150, 175));
        this.columns.add(table);
        this.addTableListeners(table);
        if (super.getBackground() != null && super.getBackground().getRed() != 240 && super.getBackground().getGreen() != 240 && super.getBackground().getBlue() != 240) {
            table.setBackground(super.getBackground());
        }
        table.setBackgroundImage(super.getBackgroundImage());
        table.setBackgroundMode(super.getBackgroundMode());
        table.setCursor(super.getCursor());
        table.setFont(super.getFont());
        table.setForeground(super.getForeground());
        table.setMenu(super.getMenu());
        table.setToolTipText(super.getToolTipText());
    }

    private void addTableListeners(Table table) {
        table.addListener(11, event -> {
            int width = table.getSize().x;
            table.getColumn(0).setWidth(width - 5);
        });
        table.addListener(13, event -> {
            Table tbl = (Table)event.widget;
            if (tbl.getSelection() == null || tbl.getSelection().length != 1) {
                return;
            }
            this.selectItem(tbl.getSelection()[0]);
        });
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        Rectangle rect = ColumnBrowserWidget.this.columnArrow.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        if (!(event.item instanceof TableItem)) {
                            return;
                        }
                        TableItem item = (TableItem)event.item;
                        if (item.getData() == null) {
                            return;
                        }
                        if (((ColumnItem)((Object)item.getData())).getItemCount() == 0) {
                            return;
                        }
                        int x = event.x + event.width;
                        Rectangle rect = ColumnBrowserWidget.this.columnArrow.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        event.gc.drawImage(ColumnBrowserWidget.this.columnArrow, x, event.y + offset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        table.addListener(13, e -> SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e));
    }

    private void selectItem(TableItem tableItem) {
        ColumnItem c = (ColumnItem)((Object)tableItem.getData());
        if (c.getItemCount() == 0) {
            return;
        }
        int selectedColumn = this.findSelectedColumn(tableItem);
        boolean needPacking = false;
        if (selectedColumn != this.columns.size() - 1) {
            int i = selectedColumn + 1;
            while (i < this.columns.size()) {
                this.columns.get(i).setData(null);
                this.columns.get(i).deselectAll();
                ++i;
            }
            i = 0;
            Iterator<Table> it = this.columns.iterator();
            while (it.hasNext()) {
                Table t = it.next();
                if (i > selectedColumn) {
                    t.dispose();
                    it.remove();
                    this.setMinSize(this.composite.computeSize(-1, -1));
                }
                ++i;
            }
            if (selectedColumn != this.columns.size() - 1) {
                this.columns.get(selectedColumn + 1).setData((Object)c);
            } else {
                this.createTable();
                this.columns.get(this.columns.size() - 1).setData((Object)c);
            }
            needPacking = true;
        } else {
            this.createTable();
            needPacking = true;
            this.columns.get(this.columns.size() - 1).setData((Object)c);
        }
        this.updateContent();
        if (needPacking) {
            this.composite.pack();
            this.setMinSize(this.composite.computeSize(-1, -1));
        }
        this.columns.get(this.columns.size() - 1).forceFocus();
    }

    private int findSelectedColumn(TableItem tableItem) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).equals(tableItem.getParent())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void updateContent() {
        if (this.columns == null) {
            return;
        }
        int i = 0;
        while (i < this.columns.size()) {
            Table table = this.columns.get(i);
            int index = table.getSelectionIndex();
            table.removeAll();
            if (table.getData() != null) {
                ColumnItem[] columnItemArray = ((ColumnItem)((Object)table.getData())).getItems();
                int n = columnItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnItem c = columnItemArray[n2];
                    TableItem item = new TableItem(table, 0);
                    item.setData((Object)c);
                    if (c.getText() != null) {
                        item.setText(c.getText());
                    }
                    if (c.getImage() != null) {
                        item.setImage(c.getImage());
                    }
                    ++n2;
                }
                table.setSelection(index);
            }
            ++i;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void clear(boolean needPacking) {
        Iterator<Table> it = this.columns.iterator();
        int i = 0;
        while (it.hasNext()) {
            Table t = it.next();
            if (i >= 3) {
                t.dispose();
                it.remove();
            } else {
                if (i != 0) {
                    t.setData(null);
                }
                t.deselectAll();
            }
            ++i;
        }
        this.updateContent();
        if (needPacking) {
            this.composite.pack();
            this.setMinSize(this.composite.computeSize(-1, -1));
        }
        this.columns.get(0).forceFocus();
    }

    public ColumnItem getSelection() {
        int i = this.columns.size() - 1;
        while (i >= 0) {
            Table table = this.columns.get(i);
            if (table != null && table.getData() != null && table.getSelection().length != 0) {
                return (ColumnItem)((Object)table.getItem(table.getSelectionIndex()).getData());
            }
            --i;
        }
        return null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void select(ColumnItem item) {
        ArrayList<ColumnItem> items = new ArrayList<ColumnItem>();
        this.findElement(item, items);
        Collections.reverse(items);
        if (items.isEmpty()) {
            return;
        }
        this.clear(false);
        int i = 3;
        while (i < items.size()) {
            this.createTable();
            ++i;
        }
        i = 0;
        while (i < items.size() - 1) {
            this.columns.get(i + 1).setData(items.get(i));
            ++i;
        }
        this.updateContent();
        i = 0;
        while (i < this.columns.size() - 1) {
            ColumnItem nextItem = (ColumnItem)((Object)this.columns.get(i + 1).getData());
            TableItem[] tableItemArray = this.columns.get(i).getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                if (tableItem.getData() != null && tableItem.getData().equals((Object)nextItem)) {
                    tableItem.getParent().setSelection(tableItem);
                }
                ++n2;
            }
            ++i;
        }
        this.composite.pack();
        this.setMinSize(this.composite.computeSize(-1, -1));
        this.columns.get(this.columns.size() - 1).forceFocus();
    }

    private void findElement(ColumnItem item, List<ColumnItem> items) {
        if (item == null) {
            return;
        }
        items.add(item);
        this.findElement(item.getParentItem(), items);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        for (Table column : this.columns) {
            column.setBackground(color);
        }
    }

    public void setBackgroundMode(int mode) {
        super.setBackgroundMode(mode);
        for (Table column : this.columns) {
            column.setBackgroundMode(mode);
        }
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        for (Table column : this.columns) {
            column.setBackgroundImage(image);
        }
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        for (Table column : this.columns) {
            column.setCursor(cursor);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        for (Table column : this.columns) {
            column.setFont(font);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        for (Table column : this.columns) {
            column.setForeground(color);
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        for (Table column : this.columns) {
            column.setMenu(menu);
        }
    }

    public void setToolTipText(String tooltipText) {
        super.setToolTipText(tooltipText);
        for (Table column : this.columns) {
            column.setToolTipText(tooltipText);
        }
    }

    ColumnItem getRootItem() {
        if (this.columns == null || this.columns.isEmpty()) {
            return null;
        }
        return (ColumnItem)((Object)this.columns.get(0).getData());
    }
}

