/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.progresscircle;

import java.time.LocalTime;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressCircle
extends Canvas {
    public static final String PERCENTAGE_PATTERN = "%d%%";
    public static final String INTEGER_PATTERN = "%d";
    private int value = 0;
    private int circleSize = 100;
    private int thickness = 10;
    private boolean showText;
    private Color highlightColor = this.getAndDisposeColor(119, 167, 251);
    private static int MARGIN = 2;
    private boolean firstDisplay = true;
    private int maximum = 100;
    private int minimum = 0;
    private String textPattern = "%d%%";
    private float floatValue;
    private boolean isTimer;
    private int fDelay;

    public ProgressCircle(Composite parent, int style) {
        super(parent, ProgressCircle.checkStyle(style) | 0x20000000);
        this.setForeground(this.getAndDisposeColor(232, 232, 232));
        this.setFont(this.createDefaultFont());
        this.addPaintListener(e -> this.paintControl(e));
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return 2048;
        }
        return 0;
    }

    private Color getAndDisposeColor(int r, int g, int b) {
        Color color = new Color((Device)this.getDisplay(), r, g, b);
        this.addDisposeListener(e -> {
            if (!color.isDisposed()) {
                color.dispose();
            }
        });
        return color;
    }

    private Font createDefaultFont() {
        FontData fontData = this.getFont().getFontData()[0];
        Font newFont = new Font((Device)this.getDisplay(), fontData.getName(), Math.max(fontData.getHeight(), 20), fontData.getStyle());
        this.addDisposeListener(e -> {
            if (!newFont.isDisposed()) {
                newFont.dispose();
            }
        });
        return newFont;
    }

    private void paintControl(PaintEvent e) {
        this.firstDisplay = false;
        GC gc = e.gc;
        gc.setAdvanced(true);
        gc.setAntialias(1);
        Path pathHighlight = new Path((Device)this.getDisplay());
        float ratio = 1.0f * (float)this.value / (float)(this.maximum - this.minimum);
        if (this.minimum < 0 && this.maximum < 0) {
            ratio = -1.0f * (float)(this.minimum - this.value) / (float)(this.maximum - this.minimum);
        }
        float angle = ratio * 360.0f;
        if (this.minimum < 0 && this.maximum > 0) {
            angle += 180.0f;
        }
        pathHighlight.addArc((float)MARGIN, (float)MARGIN, (float)this.circleSize, (float)this.circleSize, 90.0f, -angle);
        pathHighlight.lineTo((float)((MARGIN + this.circleSize) / 2), (float)((MARGIN + this.circleSize) / 2));
        pathHighlight.close();
        gc.setBackground(this.getHighlightColor());
        gc.fillPath(pathHighlight);
        pathHighlight.dispose();
        Path path = new Path((Device)this.getDisplay());
        float unselectedAngle = 360.0f - angle;
        path.addArc((float)MARGIN, (float)MARGIN, (float)this.circleSize, (float)this.circleSize, 90.0f - angle, -unselectedAngle);
        path.lineTo((float)((MARGIN + this.circleSize) / 2), (float)((MARGIN + this.circleSize) / 2));
        path.close();
        gc.setBackground(this.getForeground());
        gc.fillPath(path);
        pathHighlight.dispose();
        gc.setBackground(this.getBackground());
        gc.fillOval(MARGIN + this.thickness, MARGIN + this.thickness, this.circleSize - this.thickness * 2, this.circleSize - this.thickness * 2);
        if (this.showText) {
            LocalTime time;
            gc.setForeground(this.getHighlightColor());
            String text = this.isTimer ? ((time = LocalTime.ofSecondOfDay(this.value)).getHour() == 0 ? (time.getMinute() == 0 ? String.format("%02d", time.getSecond()) : String.format("%02d:%02d", time.getMinute(), time.getSecond())) : String.format("%02d:%02d:%02d", time.getHour(), time.getMinute(), time.getSecond())) : String.format(this.textPattern, this.value);
            Point textSize = gc.stringExtent(text);
            int x = MARGIN + (this.circleSize - textSize.x) / 2;
            int y = (this.circleSize - textSize.y) / 2;
            gc.drawText(text, x, y, true);
            path.dispose();
        }
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (maximum < this.minimum) {
            SWT.error((int)5, null, (String)String.format("The value %d is lower than the minimum (%d)", maximum, this.minimum));
        }
        this.maximum = maximum;
        this.redraw();
        this.update();
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum > this.maximum) {
            SWT.error((int)5, null, (String)String.format("The value %d is greater than the maximum (%d)", minimum, this.maximum));
        }
        this.minimum = minimum;
        this.redraw();
        this.update();
    }

    public int getSelection() {
        this.checkWidget();
        return this.value;
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < this.minimum || selection > this.maximum) {
            SWT.error((int)5, null, (String)String.format("Value %d is out of range [%d - %d]", selection, this.minimum, this.maximum));
        }
        int previousValue = this.value;
        this.value = selection;
        if (this.firstDisplay || previousValue == selection) {
            return;
        }
        this.startAnimation(previousValue);
    }

    private void startAnimation(int startValue) {
        int endValue = this.value;
        float delta = (float)(endValue - startValue) / 10.0f;
        this.floatValue = 1.0f * (float)startValue;
        boolean animate = true;
        while (animate) {
            this.floatValue += delta;
            this.value = (int)this.floatValue;
            if (this.isDisposed()) {
                return;
            }
            this.redraw();
            this.flush();
            if (delta > 0.0f && this.value >= endValue || delta < 0.0f && this.value <= endValue) {
                this.value = endValue;
                this.redraw();
                this.flush();
                animate = false;
                continue;
            }
            try {
                Thread.sleep(this.fDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public ProgressCircle setAnimationDelay(int delay) {
        this.fDelay = delay;
        return this;
    }

    private void flush() {
        while (this.getDisplay().readAndDispatch()) {
        }
    }

    public int getCircleSize() {
        this.checkWidget();
        return this.circleSize;
    }

    public void setCircleSize(int circleSize) {
        this.checkWidget();
        if (this.circleSize == circleSize) {
            return;
        }
        this.circleSize = circleSize;
        this.getParent().layout(new Control[]{this});
    }

    public int getThickness() {
        this.checkWidget();
        return this.thickness;
    }

    public void setThickness(int thickness) {
        this.checkWidget();
        this.thickness = thickness;
        this.redraw();
        this.update();
    }

    public boolean isShowText() {
        this.checkWidget();
        return this.showText;
    }

    public void setShowText(boolean showPercentage) {
        this.checkWidget();
        this.showText = showPercentage;
        this.redraw();
        this.update();
    }

    public Color getHighlightColor() {
        this.checkWidget();
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.checkWidget();
        this.highlightColor = highlightColor;
        this.redraw();
        this.update();
    }

    public String getTextPattern() {
        this.checkWidget();
        return this.textPattern;
    }

    public void setTextPattern(String textPattern) {
        this.checkWidget();
        if (textPattern == null) {
            SWT.error((int)4);
        }
        this.textPattern = textPattern;
    }

    public void startCountDown(LocalTime startTime) {
        this.checkWidget();
        this.setMinimum(0);
        int numberOfSeconds = startTime.getHour() * 3600 + startTime.getMinute() * 60 + startTime.getSecond();
        this.minimum = 0;
        this.maximum = numberOfSeconds;
        this.value = numberOfSeconds;
        this.isTimer = true;
        this.redraw();
        this.update();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (ProgressCircle.this.isDisposed()) {
                    return;
                }
                ProgressCircle progressCircle = ProgressCircle.this;
                progressCircle.value = progressCircle.value - 1;
                ProgressCircle.this.redraw();
                ProgressCircle.this.update();
                if (ProgressCircle.this.value != 0) {
                    ProgressCircle.this.getDisplay().timerExec(1000, (Runnable)this);
                }
            }
        };
        this.getDisplay().timerExec(1000, runnable);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return new Point(Math.max(this.circleSize + 2 * MARGIN, wHint), Math.max(this.circleSize + 2 * MARGIN, hHint));
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
        this.update();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.redraw();
        this.update();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.redraw();
        this.update();
    }
}

