/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.xviewer.Activator;
import org.eclipse.nebula.widgets.xviewer.core.util.XViewerUtil;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerLog;
import org.eclipse.nebula.widgets.xviewer.util.internal.images.XViewerImageCache;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class XViewerLib {
    private static final Date today = new Date();
    public static final int MILLISECS_PER_DAY = 86400000;
    public static final String MMDDYYHHMM = "MM/dd/yyyy hh:mm a";

    public static long daysTillToday(Date date) {
        return (date.getTime() - today.getTime()) / 86400000L;
    }

    public static String intern(String str) {
        return XViewerUtil.intern((String)str);
    }

    public static String generateGuidStr() {
        return XViewerUtil.generateGuidStr();
    }

    public static void writeStringToFile(String str, File outFile) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
        char[] chars = str.toCharArray();
        out.write(chars, 0, chars.length);
        out.close();
    }

    public static void popup(String title, String message) {
        if (!PlatformUI.isWorkbenchRunning()) {
            XViewerLog.log(Activator.class, Level.SEVERE, message);
        } else {
            XViewerLib.ensureInDisplayThread(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message));
        }
    }

    public static GridLayout getZeroMarginLayout(int numColumns, boolean equalColumnWidth) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = equalColumnWidth;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        return layout;
    }

    public static GridLayout getZeroMarginLayout() {
        return XViewerLib.getZeroMarginLayout(1, false);
    }

    public static List<String> readListFromDir(File directory, FilenameFilter filter, boolean keepExtension) {
        ArrayList<String> list = new ArrayList<String>(400);
        if (directory == null) {
            XViewerLog.log(Activator.class, Level.SEVERE, "Invalid directory path");
            return list;
        }
        Object[] files = directory.listFiles(filter);
        if (files == null) {
            XViewerLog.log(Activator.class, Level.SEVERE, "Invalid path: " + directory);
            return list;
        }
        if (files.length > 0) {
            Arrays.sort(files);
        }
        if (keepExtension) {
            int i = 0;
            while (i < files.length) {
                list.add(((File)files[i]).getName());
                ++i;
            }
        } else {
            int i = 0;
            while (i < files.length) {
                list.add(XViewerLib.removeExtension(((File)files[i]).getName()));
                ++i;
            }
        }
        return list;
    }

    public static List<String> readListFromDir(String directory, FilenameFilter filter) {
        return XViewerLib.readListFromDir(new File(directory), filter, false);
    }

    public static String removeExtension(String filepath) {
        String ext = XViewerLib.getExtension(filepath);
        if (ext != null && ext.length() > 0) {
            filepath = filepath.substring(0, filepath.length() - (ext.length() + 1));
        }
        return filepath;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("indows") != -1;
    }

    public static String getExtension(String filepath) {
        int index;
        filepath = filepath.trim();
        String separatorRegEx = File.separator;
        if (XViewerLib.isWindows()) {
            separatorRegEx = "\\\\";
        }
        String[] pathsArray = filepath.split(separatorRegEx);
        String fileName = pathsArray[0];
        if (pathsArray.length > 0) {
            fileName = pathsArray[pathsArray.length - 1];
        }
        if ((index = fileName.lastIndexOf(46)) >= 0 && index + 1 < fileName.length()) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    public static void ensureInDisplayThread(Runnable runnable) {
        XViewerLib.ensureInDisplayThread(runnable, false);
    }

    public static void ensureInDisplayThread(Runnable runnable, boolean forcePend) {
        if (XViewerLib.isDisplayThread()) {
            runnable.run();
        } else if (forcePend) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public static boolean isDisplayThread() {
        if (Display.getCurrent() == null) {
            return false;
        }
        return Display.getCurrent().getThread() == Thread.currentThread();
    }

    public static Image getImage(String imageName) {
        return XViewerImageCache.getImage(imageName);
    }

    public static ImageDescriptor getImageDescriptor(String imageName) {
        return XViewerImageCache.getImageDescriptor(imageName);
    }

    public static String getDateFromPattern(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (date == null) {
            return "";
        }
        String result = dateFormat.format(date);
        return result;
    }
}

