/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.heapmanager;

import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class HeapManager
extends Composite {
    private Canvas bar;
    private Button button;
    private int heapMaxSize;
    private int heapSize;
    private Color barBorderColor;
    private Color barInnerColor;
    private Color barTextColor;
    private Color barGradientColorTopStart;
    private Color barGradientColorTopEnd;
    private Color barGradientColorMiddleStart;

    public HeapManager(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.createBar();
        this.createButton();
        this.updateContent();
        this.createDefaultColors();
    }

    private void createBar() {
        this.bar = new Canvas((Composite)this, 0);
        GridData gd = new GridData(4, 4, true, false);
        gd.minimumWidth = 100;
        gd.heightHint = 30;
        this.bar.setLayoutData((Object)gd);
        this.heapMaxSize = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        this.bar.addPaintListener(e -> this.drawBar(e));
    }

    private void drawBar(PaintEvent e) {
        GC gc = e.gc;
        Rectangle clientArea = this.bar.getClientArea();
        gc.setForeground(this.barBorderColor);
        gc.setBackground(this.barInnerColor);
        gc.fillRectangle(clientArea);
        gc.drawRectangle(clientArea.x, clientArea.y, clientArea.width - 1, clientArea.height - 1);
        float width = ((float)clientArea.width - 2.0f) * (float)this.heapSize / (float)this.heapMaxSize;
        gc.setForeground(this.barGradientColorTopStart);
        gc.setBackground(this.barGradientColorTopEnd);
        gc.fillGradientRectangle(clientArea.x + 1, clientArea.y + 1, (int)width, clientArea.height / 2, true);
        gc.setForeground(this.barGradientColorMiddleStart);
        gc.setBackground(this.barBorderColor);
        gc.fillGradientRectangle(clientArea.x + 1, clientArea.height / 2, (int)width, clientArea.height / 2, true);
        String message = String.valueOf(this.heapSize) + " " + ResourceManager.getLabel((String)"megabytes") + "/" + this.heapMaxSize + " " + ResourceManager.getLabel((String)"megabytes");
        Point size = gc.stringExtent(message);
        gc.setForeground(this.barTextColor);
        gc.setFont(this.getFont());
        gc.drawText(message, (clientArea.width - size.x) / 2, (clientArea.height - size.y) / 2, true);
        gc.dispose();
    }

    private void createButton() {
        this.button = new Button((Composite)this, 8);
        Image image = SWTGraphicUtil.createImageFromFile((String)"images/trash.png");
        this.button.setImage(image);
        SWTGraphicUtil.addDisposer((Widget)this.button, (Resource[])new Resource[]{image});
        this.button.setLayoutData((Object)new GridData(4, 4, false, false));
        this.button.addListener(13, e -> System.gc());
        this.button.setToolTipText(ResourceManager.getLabel((String)"performGC"));
        this.button.pack();
    }

    private void updateContent() {
        this.getDisplay().timerExec(500, new Runnable(){

            @Override
            public void run() {
                HeapManager.this.heapSize = (int)(Runtime.getRuntime().totalMemory() / 0x100000L);
                if (!HeapManager.this.isDisposed()) {
                    HeapManager.this.bar.redraw();
                    if (!HeapManager.this.getDisplay().isDisposed()) {
                        HeapManager.this.getDisplay().timerExec(500, (Runnable)this);
                    }
                }
            }
        });
    }

    private void createDefaultColors() {
        this.barTextColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)57, (int)98, (int)149);
        this.barInnerColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)219, (int)230, (int)243);
        this.barBorderColor = SWTGraphicUtil.getDefaultColor((Control)this, (int)101, (int)148, (int)207);
        this.barGradientColorTopStart = SWTGraphicUtil.getDefaultColor((Control)this, (int)175, (int)202, (int)237);
        this.barGradientColorTopEnd = SWTGraphicUtil.getDefaultColor((Control)this, (int)136, (int)177, (int)229);
        this.barGradientColorMiddleStart = SWTGraphicUtil.getDefaultColor((Control)this, (int)112, (int)161, (int)223);
    }

    public Color getBarBorderColor() {
        return this.barBorderColor;
    }

    public void setBarBorderColor(Color barBorderColor) {
        this.barBorderColor = barBorderColor;
    }

    public Color getBarInnerColor() {
        return this.barInnerColor;
    }

    public void setBarInnerColor(Color barInnerColor) {
        this.barInnerColor = barInnerColor;
    }

    public Color getBarTextColor() {
        return this.barTextColor;
    }

    public void setBarTextColor(Color barTextColor) {
        this.barTextColor = barTextColor;
    }

    public Color getBarGradientColorTopStart() {
        return this.barGradientColorTopStart;
    }

    public void setBarGradientColorTopStart(Color barGradientColorTopStart) {
        this.barGradientColorTopStart = barGradientColorTopStart;
    }

    public Color getBarGradientColorTopEnd() {
        return this.barGradientColorTopEnd;
    }

    public void setBarGradientColorTopEnd(Color barGradientColorTopEnd) {
        this.barGradientColorTopEnd = barGradientColorTopEnd;
    }

    public Color getBarGradientColorMiddleStart() {
        return this.barGradientColorMiddleStart;
    }

    public void setBarGradientColorMiddleStart(Color barGradientColorMiddleStart) {
        this.barGradientColorMiddleStart = barGradientColorMiddleStart;
    }
}

