/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.segmentedbar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.nebula.widgets.segmentedbar.Segment;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SegmentedBar
extends Canvas {
    private static final int DEFAULT_SPACING = 3;
    private static final int DEFAULT_WIDTH = 50;
    private static final int HORIZONTAL_BORDER = 2;
    private List<Segment> segments = new ArrayList<Segment>();
    private int spacing = 3;
    GC gc;
    int currentX;
    boolean isFirstItem;
    boolean isLastItem;
    private DefaultToolTip toolTip;

    public SegmentedBar(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListeners();
        this.toolTip = new DefaultToolTip((Control)this, 1, false);
        this.toolTip.setBackgroundColor(this.getDisplay().getSystemColor(29));
        this.toolTip.setShift(new Point(10, 5));
    }

    private void addListeners() {
        this.addListener(9, e -> {
            this.gc = e.gc;
            this.drawWidget();
        });
        this.addListener(5, event -> {
            this.toolTip.setText(null);
            for (Segment segment : this.segments) {
                if (segment.drawingArea == null || !segment.drawingArea.contains(event.x, event.y)) continue;
                this.toolTip.setText(segment.getTooltip());
            }
        });
        this.addListener(7, event -> this.toolTip.setText(null));
    }

    private void drawWidget() {
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        Color previousForeground = this.gc.getForeground();
        Color previousBackground = this.gc.getBackground();
        int totalWidth = this.getSize().x;
        double total = this.getTotal();
        this.currentX = 2;
        Iterator<Segment> it = this.segments.iterator();
        this.isFirstItem = true;
        while (it.hasNext()) {
            Segment segment = it.next();
            int segmentSize = (int)((double)(totalWidth - 4) * (segment.getValue() / total));
            this.isLastItem = !it.hasNext();
            this.drawItem(segment, segmentSize);
            this.currentX += segmentSize + this.spacing;
            this.isFirstItem = false;
        }
        this.gc.setBackground(previousBackground);
        this.gc.setForeground(previousForeground);
    }

    private void drawItem(Segment segment, int segmentSize) {
        segment.setParent(this);
        segment.draw(segmentSize);
    }

    public double getTotal() {
        this.checkWidget();
        double total = 0.0;
        for (Segment segment : this.segments) {
            total += segment.getValue().doubleValue();
        }
        return total;
    }

    public List<Segment> getSegments() {
        this.checkWidget();
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.checkWidget();
        if (segments == null) {
            SWT.error((int)4);
        }
        this.segments = segments;
        this.redraw();
        this.update();
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            SWT.error((int)5);
        }
        this.spacing = spacing;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        wHint = wHint != -1 ? DPIUtil.autoScaleUp((int)wHint) : wHint;
        hHint = hHint != -1 ? DPIUtil.autoScaleUp((int)hHint) : hHint;
        return DPIUtil.autoScaleDown((Point)this.computeSizePixels(wHint, hHint, changed));
    }

    private Point computeSizePixels(int wHint, int hHint, boolean changed) {
        int width = 50;
        int height = 0;
        for (Segment segment : this.segments) {
            height = Math.max(height, segment.computeHeight());
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public void addSegment(Segment segment) {
        this.checkWidget();
        if (segment == null) {
            SWT.error((int)4);
        }
        this.segments.add(segment);
        this.redraw();
        this.update();
    }

    public void removeSegment(Segment segment) {
        this.checkWidget();
        if (segment == null) {
            SWT.error((int)4);
        }
        this.segments.remove(segment);
        this.redraw();
        this.update();
    }
}

