/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.examples;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.figures.ProgressBarFigure;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ProgressBarExample {
    private static int counter = 0;

    public static void main(String[] args) {
        Shell shell = new Shell();
        shell.setSize(300, 120);
        shell.open();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        final ProgressBarFigure progressBarFigure = new ProgressBarFigure();
        progressBarFigure.setFillColor(XYGraphMediaFactory.getInstance().getColor(0, 255, 0));
        progressBarFigure.setRange(-100.0, 100.0);
        progressBarFigure.setLoLevel(-50.0);
        progressBarFigure.setLoloLevel(-80.0);
        progressBarFigure.setHiLevel(60.0);
        progressBarFigure.setHihiLevel(80.0);
        progressBarFigure.setMajorTickMarkStepHint(50);
        progressBarFigure.setHorizontal(true);
        progressBarFigure.setOriginIgnored(true);
        lws.setContents((IFigure)progressBarFigure);
        ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        ScheduledFuture<?> future = scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        progressBarFigure.setValue(Math.sin((double)counter++ / 10.0) * 100.0);
                    }
                });
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        Display display = Display.getDefault();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        future.cancel(true);
        scheduler.shutdown();
    }
}

