/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTickMarks;

public class LinearScaleTickMarks2
extends LinearScaleTickMarks {
    public LinearScaleTickMarks2(LinearScale scale) {
        super(scale);
    }

    @Override
    protected void drawXTickMarks(Graphics gc, List<Integer> tickLabelPositions, AbstractScale.LabelSide tickLabelSide, int width, int height) {
        gc.setLineStyle(1);
        ITicksProvider ticks = this.getScaleProvider().getTicksProvider();
        int imax = ticks.getMajorCount();
        if (this.getScaleProvider().isLogScaleEnabled()) {
            int y;
            int i = 0;
            while (i < imax) {
                int x = ticks.getPosition(i);
                int tickLength = ticks.isVisible(i) ? 6 : 3;
                int n = y = tickLabelSide == AbstractScale.LabelSide.Primary ? 0 : height - 1 - 1 - tickLength;
                if (ticks.isVisible(i) || this.getScaleProvider().isMinorTicksVisible()) {
                    gc.drawLine(x, y, x, y + tickLength);
                }
                ++i;
            }
            if (this.getScaleProvider().isMinorTicksVisible()) {
                int start = this.getScaleProvider().getTicksProvider().getHeadMargin();
                y = tickLabelSide == AbstractScale.LabelSide.Primary ? 0 : height - 1 - 1 - 3;
                int jmax = ticks.getMinorCount();
                int j = 0;
                while (j < jmax) {
                    int x = ticks.getMinorPosition(j);
                    if (x >= start && x < width) {
                        gc.drawLine(x, y, x, y + 3);
                    }
                    ++j;
                }
            }
        } else {
            int y = tickLabelSide == AbstractScale.LabelSide.Primary ? 0 : height - 1 - 1 - 6;
            int i = 0;
            while (i < imax) {
                int x = ticks.getPosition(i);
                gc.drawLine(x, y, x, y + 6);
                ++i;
            }
            if (this.getScaleProvider().isMinorTicksVisible()) {
                int start = this.getScaleProvider().getTicksProvider().getHeadMargin();
                if (tickLabelSide == AbstractScale.LabelSide.Secondary) {
                    y = height - 1 - 1 - 3;
                }
                int jmax = ticks.getMinorCount();
                int j = 0;
                while (j < jmax) {
                    int x = ticks.getMinorPosition(j);
                    if (x >= start && x < width) {
                        gc.drawLine(x, y, x, y + 3);
                    }
                    ++j;
                }
            }
        }
        if (this.getScaleProvider().isScaleLineVisible()) {
            if (tickLabelSide == AbstractScale.LabelSide.Primary) {
                gc.drawLine(this.getScaleProvider().getMargin(), 0, width - this.getScaleProvider().getMargin(), 0);
            } else {
                gc.drawLine(this.getScaleProvider().getMargin(), height - 1, width - this.getScaleProvider().getMargin(), height - 1);
            }
        }
    }

    @Override
    protected void drawYTickMarks(Graphics gc, List<Integer> tickLabelPositions, AbstractScale.LabelSide tickLabelSide, int width, int height) {
        gc.setLineStyle(1);
        ITicksProvider ticks = this.getScaleProvider().getTicksProvider();
        if (this.getScaleProvider().isLogScaleEnabled()) {
            this.drawMajorTicks(gc, ticks, tickLabelSide, width, height, true);
            if (this.getScaleProvider().isMinorTicksVisible()) {
                this.drawMinorTicks(gc, ticks, tickLabelSide, width, height);
            }
        } else {
            this.drawMajorTicks(gc, ticks, tickLabelSide, width, height, false);
            if (this.getScaleProvider().isMinorTicksVisible()) {
                this.drawMinorTicks(gc, ticks, tickLabelSide, width, height);
            }
        }
        if (this.getScaleProvider().isScaleLineVisible()) {
            if (tickLabelSide == AbstractScale.LabelSide.Primary) {
                gc.drawLine(width - 1, this.getScaleProvider().getMargin(), width - 1, height - this.getScaleProvider().getMargin());
            } else {
                gc.drawLine(0, this.getScaleProvider().getMargin(), 0, height - this.getScaleProvider().getMargin());
            }
        }
    }

    private void drawMajorTicks(Graphics gc, ITicksProvider ticks, AbstractScale.LabelSide tickLabelSide, int width, int height, boolean isLogScaleEnabled) {
        int imax = ticks.getMajorCount();
        if (isLogScaleEnabled) {
            int i = 0;
            while (i < imax) {
                int tickLength = ticks.isVisible(i) ? 6 : 3;
                int x = tickLabelSide == AbstractScale.LabelSide.Primary ? width - 1 - 1 - tickLength : 1;
                int y = height - ticks.getPosition(i);
                if (ticks.isVisible(i) || this.getScaleProvider().isMinorTicksVisible()) {
                    gc.drawLine(x, y, x + tickLength, y);
                }
                ++i;
            }
        } else {
            int x = tickLabelSide == AbstractScale.LabelSide.Primary ? width - 1 - 6 : 1;
            int i = 0;
            while (i < imax) {
                int y = height - ticks.getPosition(i);
                gc.drawLine(x, y, x + 6, y);
                ++i;
            }
        }
    }

    private void drawMinorTicks(Graphics gc, ITicksProvider ticks, AbstractScale.LabelSide tickLabelSide, int width, int height) {
        int end = height - this.getScaleProvider().getTicksProvider().getTailMargin();
        int x = tickLabelSide == AbstractScale.LabelSide.Primary ? width - 1 - 3 : 1;
        int y = 0;
        int jmax = ticks.getMinorCount();
        int j = 0;
        while (j < jmax) {
            y = height - ticks.getMinorPosition(j);
            if (y >= 0 && y < end) {
                gc.drawLine(x, y, x + 3, y);
            }
            ++j;
        }
    }
}

