/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.floatingtext.snippets;

import org.eclipse.nebula.widgets.floatingtext.FloatingText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FloatingTextSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(1, true));
        FloatingTextSnippet.createText(new Group((Composite)shell, 0));
        Point p = shell.getSize();
        p.y = shell.getMonitor().getBounds().height * 75 / 100;
        p.x = shell.getMonitor().getBounds().width * 50 / 100;
        shell.setSize(p);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createText(Group group) {
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Floating Text widgets");
        FloatingText txt1 = new FloatingText((Composite)group, 2048);
        txt1.setLayoutData((Object)new GridData(4, 4, true, false));
        txt1.getText().setMessage("Out of the box floating text");
        txt1.getText().setText("this is text");
        Group group2 = new Group((Composite)group, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        layoutData.verticalSpan = 2;
        group2.setLayoutData((Object)layoutData);
        group2.setLayout((Layout)new GridLayout(1, false));
        group2.setText("Special case");
        Button button = new Button((Composite)group2, 32);
        button.setText("Use default location");
        button.setSelection(true);
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        final FloatingText txt11b = new FloatingText((Composite)group2, 2048);
        txt11b.setLayoutData((Object)new GridData(4, 4, true, false));
        txt11b.getText().setMessage("Location");
        final String initText = "C:\\default";
        txt11b.getText().setText(initText);
        txt11b.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (txt11b.isEnabled()) {
                    txt11b.setEnabled(false);
                    txt11b.getText().setText(initText);
                } else {
                    txt11b.setEnabled(true);
                    if (txt11b.getText().getText().equals(initText)) {
                        txt11b.getText().setText("");
                    }
                }
            }
        });
        FloatingText txt11w = new FloatingText((Composite)group, 2050);
        txt11w.setLayoutData((Object)new GridData(4, 4, true, false));
        txt11w.getText().setMessage("Text with Separator");
        FloatingText txt11x = new FloatingText((Composite)group, 2050);
        txt11x.setLayoutData((Object)new GridData(4, 4, true, false));
        txt11x.getText().setMessage("Text + Dark Separator");
        txt11x.setBackground(txt11x.getDisplay().getSystemColor(2));
        FloatingText txt11 = new FloatingText((Composite)group, 2050);
        txt11.setLayoutData((Object)new GridData(4, 4, true, false));
        txt11.getText().setMessage("Text + Separator + Gray label");
        txt11.getLabel().setForeground(txt11.getDisplay().getSystemColor(15));
        FloatingText txt112 = new FloatingText((Composite)group, 2050);
        txt112.setLayoutData((Object)new GridData(4, 4, true, false));
        txt112.getText().setMessage("Last Name + Dark Separator + Label Background");
        txt112.getLabel().setBackground(txt112.getDisplay().getSystemColor(15));
        txt112.getLabel().setForeground(txt112.getDisplay().getSystemColor(1));
        txt112.setBackground(txt112.getDisplay().getSystemColor(2));
        FloatingText txt2gap = new FloatingText((Composite)group, 2050);
        txt2gap.setLayoutData((Object)new GridData(4, 4, true, false));
        txt2gap.getText().setMessage("2 pixel blue gap");
        txt2gap.setSeparatorSpace(2);
        txt2gap.setBackground(txt11.getDisplay().getSystemColor(9));
        FloatingText txt2 = new FloatingText((Composite)group, 2050);
        txt2.setLayoutData((Object)new GridData(4, 4, true, false));
        txt2.getText().setMessage("Red Separator");
        txt2.setBackground(txt11.getDisplay().getSystemColor(3));
        FloatingText passw = new FloatingText((Composite)group, 0x400000);
        passw.setLayoutData((Object)new GridData(4, 4, true, false));
        passw.getText().setMessage("Password - Borderless");
        FloatingText flip = new FloatingText((Composite)group, 67110914);
        flip.setLayoutData((Object)new GridData(4, 4, true, false));
        flip.getText().setMessage("Right to Left");
        FloatingText ratio50 = new FloatingText((Composite)group, 2048);
        ratio50.setLayoutData((Object)new GridData(4, 4, true, false));
        ratio50.getText().setMessage("Label Ratio 70%");
        ratio50.setRatio(70);
        FloatingText ratio120 = new FloatingText((Composite)group, 2050);
        ratio120.setLayoutData((Object)new GridData(4, 4, true, false));
        ratio120.getText().setMessage("Label Ratio 120%");
        ratio120.setRatio(120);
        ratio120.setBackground(ratio120.getDisplay().getSystemColor(7));
        FloatingText multi2 = new FloatingText((Composite)group, 2);
        GridData layoutData2 = new GridData(4, 4, true, true);
        layoutData2.verticalSpan = 2;
        multi2.setLayoutData((Object)layoutData2);
        multi2.getText().setMessage("Multi Text 2");
        FloatingText multi = new FloatingText((Composite)group, 66);
        multi.setLayoutData((Object)layoutData2);
        multi.getText().setMessage("Multi Text");
        multi.setBackground(multi.getDisplay().getSystemColor(3));
    }
}

