/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.geomap.jface.GoogleIconDescriptor;
import org.eclipse.nebula.widgets.geomap.jface.IPinPointProvider;
import org.eclipse.nebula.widgets.geomap.jface.IToolTipProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class LabelImageProvider
extends LabelProvider
implements IPinPointProvider,
IToolTipProvider {
    private ImageRegistry imageRegistry;
    private boolean hasShadow;
    private RGB textColor = new RGB(0, 0, 0);
    private RGB fillColor = new RGB(255, 250, 200);
    private String iconStyle = "d_bubble_text_small";
    private String frameStyle = "bb";

    protected ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
        }
        return this.imageRegistry;
    }

    protected ImageRegistry createImageRegistry() {
        return new ImageRegistry();
    }

    public void dispose() {
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
        super.dispose();
    }

    public boolean hasShadow() {
        return this.hasShadow;
    }

    public void setHasShadow(boolean hasShadow) {
        this.hasShadow = hasShadow;
    }

    public RGB getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGB textColor) {
        this.textColor = textColor;
    }

    public RGB getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(RGB fillColor) {
        this.fillColor = fillColor;
    }

    public String getIconStyle() {
        return this.iconStyle;
    }

    public void setIconStyle(String iconStyle) {
        this.iconStyle = iconStyle;
    }

    public String getFrameStyle() {
        return this.frameStyle;
    }

    public void setFrameStyle(String frameStyle) {
        this.frameStyle = frameStyle;
    }

    protected Image getLabelImage(Object element) {
        String text = this.getText(element);
        if (text == null) {
            return null;
        }
        Image image = this.getImageRegistry().get(text);
        if (image == null) {
            GoogleIconDescriptor.Options options = new GoogleIconDescriptor.Options(this.getIconStyle(), null, this.getFrameStyle(), this.hasShadow(), text, this.getFillColor(), this.getTextColor());
            GoogleIconDescriptor descriptor = new GoogleIconDescriptor(options);
            this.imageRegistry.put(text, (ImageDescriptor)descriptor);
            image = this.getImageRegistry().get(text);
        }
        return image;
    }

    public Image getImage(Object element) {
        return this.getLabelImage(element);
    }

    @Override
    public Point getPinPoint(Object element) {
        return this.getPinPoint(element, 0.0f, 1.0f);
    }

    protected Point getPinPoint(Object element, float alignX, float alignY) {
        Rectangle bounds = this.getImage(element).getBounds();
        return new Point((int)((float)bounds.width * alignX), (int)((float)bounds.height * alignY));
    }

    @Override
    public Object getToolTip(Object element) {
        return this.getText(element);
    }
}

