/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseCallMessageSend;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.BaseReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CalloutMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.AnchorMapping;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.WeakenedTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CalloutImplementor;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StandardElementGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.RoleTypeCreator;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding syntheticAccessor;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    private boolean isDecapsulation = false;
    public boolean isCallinRoleMethodCall = false;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean nonStatic = !this.binding.isStatic();
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, nonStatic).unconditionalInits();
        if (nonStatic) {
            this.receiver.checkNPE(currentScope, flowContext, flowInfo);
        }
        if (this.arguments != null) {
            int length = this.arguments.length;
            int i = 0;
            while (i < length) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                ++i;
            }
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                thrownExceptions = currentScope.environment().convertToRawTypes(this.binding.thrownExceptions, true, true);
            }
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo.copy(), currentScope);
        }
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        flowInfo = this.checkBaseCallsIfSuper(currentScope, flowInfo);
        return flowInfo;
    }

    protected FlowInfo checkBaseCallsIfSuper(BlockScope currentScope, FlowInfo flowInfo) {
        MethodScope methodScope = currentScope.methodScope();
        if (methodScope == null) {
            return flowInfo;
        }
        AbstractMethodDeclaration methodDecl = methodScope.referenceMethod();
        if (methodDecl == null || !methodDecl.isCallin()) {
            return flowInfo;
        }
        if (!this.isSuperAccess()) {
            return flowInfo;
        }
        MethodDeclaration callinMethod = (MethodDeclaration)methodDecl;
        if (MethodModel.hasCallinFlag(this.binding, 8)) {
            return flowInfo;
        }
        boolean definitelyViaSuper = !MethodModel.hasCallinFlag(this.binding, 16);
        LocalVariableBinding trackingVariable = callinMethod.baseCallTrackingVariable.binding;
        if (flowInfo.isDefinitelyAssigned(callinMethod.baseCallTrackingVariable)) {
            if (definitelyViaSuper) {
                currentScope.problemReporter().definitelyDuplicateBasecall(this);
            } else {
                currentScope.problemReporter().potentiallyDuplicateBasecall(this);
            }
        } else if (flowInfo.isPotentiallyAssigned(trackingVariable)) {
            currentScope.problemReporter().potentiallyDuplicateBasecall(this);
        } else if (definitelyViaSuper) {
            flowInfo.markAsDefinitelyAssigned(trackingVariable);
        } else {
            FlowInfo potential = flowInfo.copy();
            potential.markAsDefinitelyAssigned(trackingVariable);
            flowInfo = FlowInfo.conditional(flowInfo.initsWhenTrue(), potential.initsWhenTrue());
        }
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            ReferenceBinding referenceCast;
            MethodBinding originalBinding = this.binding.original();
            TypeBinding originalType = originalBinding.returnType;
            if (originalType.leafComponentType().isTypeVariable()) {
                TypeBinding targetType = !compileTimeType.isBaseType() && runtimeTimeType.isBaseType() ? compileTimeType : runtimeTimeType;
                this.valueCast = originalType.genericCast(targetType);
            } else if (this.binding == scope.environment().arrayClone && runtimeTimeType.id != 1 && scope.compilerOptions().sourceLevel >= 0x310000L) {
                this.valueCast = runtimeTimeType;
            }
            if (this.valueCast instanceof ReferenceBinding && !(referenceCast = (ReferenceBinding)this.valueCast).canBeSeenBy(scope) && !this.isDecapsulationAllowed(scope)) {
                scope.problemReporter().invalidType(this, new ProblemReferenceBinding(CharOperation.splitOn('.', referenceCast.shortReadableName()), referenceCast, 2));
            }
        }
        super.computeConversion(scope, runtimeTimeType, compileTimeType);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        MethodBinding codegenBinding = this.binding.original();
        boolean isStatic = codegenBinding.isStatic();
        if (isStatic) {
            this.receiver.generateCode(currentScope, codeStream, false);
        } else if ((this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] path = currentScope.getEmulationPath(targetType, true, false);
            codeStream.generateOuterAccess(path, this, targetType, currentScope);
        } else {
            this.receiver.generateCode(currentScope, codeStream, true);
            if ((this.bits & 0x40000) != 0) {
                codeStream.checkcast(this.actualReceiverType);
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        if (codegenBinding.needsSyntheticEnclosingTeamInstance()) {
            codeStream.iconst_0();
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, (ReferenceBinding)this.actualReceiverType, null, this);
        }
        this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
        pc = codeStream.position;
        if (this.syntheticAccessor == null) {
            TypeBinding constantPoolDeclaringClass = CodeStream.getConstantPoolDeclaringClass((Scope)currentScope, codegenBinding, this.actualReceiverType, this.receiver.isImplicitThis());
            if (isStatic) {
                codeStream.invoke((byte)-72, codegenBinding, constantPoolDeclaringClass);
            } else if (this.receiver.isSuper() || codegenBinding.isPrivate() && !this.isDecapsulation) {
                codeStream.invoke((byte)-73, codegenBinding, constantPoolDeclaringClass);
            } else if (constantPoolDeclaringClass.isInterface() || constantPoolDeclaringClass instanceof RoleTypeBinding) {
                codeStream.invoke((byte)-71, codegenBinding, constantPoolDeclaringClass);
            } else {
                codeStream.invoke((byte)-74, codegenBinding, constantPoolDeclaringClass);
            }
        } else {
            codeStream.invoke((byte)-72, this.syntheticAccessor, null);
        }
        if (this.valueCast != null) {
            codeStream.checkcast(this.valueCast);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            boolean isUnboxing;
            boolean bl = isUnboxing = (this.implicitConversion & 0x400) != 0;
            if (isUnboxing) {
                codeStream.generateImplicitConversion(this.implicitConversion);
            }
            switch (isUnboxing ? this.postConversionType((Scope)currentScope).id : codegenBinding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, (int)(this.nameSourcePosition >>> 32));
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    protected boolean isAnySuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        MethodBinding codegenBinding = this.binding.original();
        if (this.binding.isPrivate() && !this.isDecapsulation) {
            if (currentScope.enclosingSourceType() != codegenBinding.declaringClass) {
                this.syntheticAccessor = ((SourceTypeBinding)codegenBinding.declaringClass).addSyntheticMethod(codegenBinding, false);
                currentScope.problemReporter().needToEmulateMethodAccess(codegenBinding, this);
                return;
            }
        } else {
            SourceTypeBinding enclosingSourceType;
            int depth;
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticAccessor = destinationType.addSyntheticMethod(codegenBinding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(codegenBinding, this);
                return;
            }
            if (this.binding.isProtected() && (depth = this.getDepthForSynthMethodAccess(this.binding, enclosingSourceType = currentScope.enclosingSourceType())) > 0) {
                SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt(depth);
                this.syntheticAccessor = currentCompatibleType.addSyntheticMethod(codegenBinding, this.isSuperAccess());
                currentScope.problemReporter().needToEmulateMethodAccess(codegenBinding, this);
                return;
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding convertedType = this.resolvedType;
        if (this.valueCast != null) {
            convertedType = this.valueCast;
        }
        int runtimeType = (this.implicitConversion & 0xFF) >> 4;
        switch (runtimeType) {
            case 5: {
                convertedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                convertedType = TypeBinding.BYTE;
                break;
            }
            case 4: {
                convertedType = TypeBinding.SHORT;
                break;
            }
            case 2: {
                convertedType = TypeBinding.CHAR;
                break;
            }
            case 10: {
                convertedType = TypeBinding.INT;
                break;
            }
            case 9: {
                convertedType = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                convertedType = TypeBinding.LONG;
                break;
            }
            case 8: {
                convertedType = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            convertedType = scope.environment().computeBoxingType(convertedType);
        }
        return convertedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        output.append(this.selector).append('(');
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(')');
    }

    public TypeBinding resolveType(BlockScope scope) {
        ReferenceContext referenceContext;
        MethodBinding origMethod;
        AbstractMethodDeclaration enclosingMethod;
        boolean callinAllowed;
        boolean argHasError;
        boolean receiverIsType;
        this.constant = Constant.NotAConstant;
        boolean receiverCast = false;
        boolean argsContainCast = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            receiverCast = true;
        }
        this.actualReceiverType = this.receiver.resolvedType != null ? this.receiver.resolvedType : this.receiver.resolveType(scope);
        boolean bl = receiverIsType = (this.receiver instanceof NameReference || this.receiver instanceof BaseReference) && (this.receiver.bits & 4) != 0;
        if (receiverCast && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            scope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            argHasError = scope.compilerOptions().sourceLevel < 0x310000L;
            this.genericTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                TypeReference typeReference = this.typeArguments[i];
                this.genericTypeArguments[i] = typeReference.resolveType(scope, true);
                if (this.genericTypeArguments[i] == null) {
                    argHasError = true;
                }
                if (argHasError && typeReference instanceof Wildcard) {
                    scope.problemReporter().illegalUsageOfWildcard(typeReference);
                }
                ++i;
            }
            if (argHasError) {
                if (this.arguments != null) {
                    i = 0;
                    int max = this.arguments.length;
                    while (i < max) {
                        this.arguments[i].resolveType(scope);
                        ++i;
                    }
                }
                return null;
            }
        }
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if (argument.resolvedType != null) {
                    argumentTypes[i] = argument.resolvedType;
                } else {
                    argumentTypes[i] = argument.resolveType(scope);
                    if (argumentTypes[i] == null) {
                        argHasError = true;
                    }
                }
                ++i;
            }
            if (argHasError) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    TypeBinding[] pseudoArgs = new TypeBinding[length];
                    int i2 = length;
                    while (--i2 >= 0) {
                        TypeBinding typeBinding = pseudoArgs[i2] = argumentTypes[i2] == null ? TypeBinding.NULL : argumentTypes[i2];
                    }
                    MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, pseudoArgs, this) : scope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, pseudoArgs, this);
                    if (this.binding != null && !this.binding.isValidBinding()) {
                        MethodBinding closestMatch = ((ProblemMethodBinding)this.binding).closestMatch;
                        if (closestMatch != null) {
                            if (closestMatch.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                                closestMatch = scope.environment().createParameterizedGenericMethod(closestMatch.original(), (RawTypeBinding)null);
                            }
                            this.binding = closestMatch;
                            MethodBinding closestMatchOriginal = closestMatch.original();
                            if (closestMatchOriginal.isOrEnclosedByPrivateType() && !scope.isDefinedInMethod(closestMatchOriginal)) {
                                closestMatchOriginal.modifiers |= 0x8000000;
                            }
                        }
                    } else if (this.binding != null && this.binding.isOrEnclosedByPrivateType() && !scope.isDefinedInMethod(this.binding)) {
                        this.binding.modifiers |= 0x8000000;
                    }
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
            return null;
        }
        if (this.actualReceiverType instanceof WeakenedTypeBinding) {
            this.actualReceiverType = ((WeakenedTypeBinding)this.actualReceiverType).getStrongType();
            this.bits |= 0x40000;
        }
        if (this.receiver.isThis() && !this.isQualifiedThis(this.receiver) && this.actualReceiverType.isRole()) {
            this.actualReceiverType = ((ReferenceBinding)this.actualReceiverType).getRealClass();
            if (this.actualReceiverType == null) {
                this.actualReceiverType = ((ReferenceBinding)this.receiver.resolvedType).getRealType();
            }
        }
        AnchorMapping anchorMapping = null;
        int baseTypeModifiers = -1;
        ReferenceBinding receiverReferenceType = this.actualReceiverType instanceof ReferenceBinding ? (ReferenceBinding)this.actualReceiverType : null;
        TypeBinding returnType = null;
        try {
            anchorMapping = this.beforeMethodLookup(argumentTypes, scope);
            if (this.isDecapsulationAllowed(scope) && receiverReferenceType != null) {
                baseTypeModifiers = receiverReferenceType.modifiers;
                receiverReferenceType.modifiers &= 0xFFFFFFF8;
                receiverReferenceType.modifiers |= 1;
            }
            char[] realSelector = this.selector;
            if (CharOperation.equals(this.selector, IOTConstants.LOWER) && this.actualReceiverType.isRole() && this.arguments == null && this.actualReceiverType.isCompatibleWith(scope.getType(new char[][]{IOTConstants.ORG, IOTConstants.OBJECTTEAMS, IOTConstants.ITEAM, IOTConstants.ILOWERABLE}, 4))) {
                this.selector = IOTConstants._OT_GETBASE;
            }
            this.binding = this.receiver.isImplicitThis() ? scope.getImplicitMethod(this.selector, argumentTypes, this) : scope.getMethod(this.actualReceiverType, this.selector, argumentTypes, this);
            this.selector = realSelector;
            returnType = RoleTypeCreator.maybeWrapQualifiedRoleType(this, scope);
        }
        catch (Throwable throwable) {
            AnchorMapping.removeCurrentMapping(anchorMapping);
            if (baseTypeModifiers != -1) {
                receiverReferenceType.modifiers = baseTypeModifiers;
            }
            throw throwable;
        }
        AnchorMapping.removeCurrentMapping(anchorMapping);
        if (baseTypeModifiers != -1) {
            receiverReferenceType.modifiers = baseTypeModifiers;
        }
        returnType = this.afterMethodLookup(scope, anchorMapping, argumentTypes, returnType);
        int bindingModifiers = this.binding.modifiers;
        if (!this.binding.isValidBinding()) {
            ProblemMethodBinding problem = (ProblemMethodBinding)this.binding;
            if (problem.closestMatch != null) {
                bindingModifiers = problem.closestMatch.modifiers;
            }
        }
        if ((bindingModifiers & Integer.MIN_VALUE) != 0 && !(callinAllowed = (enclosingMethod = scope.methodScope().referenceMethod()) == null ? false : (this.isAnySuperAccess() ? (enclosingMethod.modifiers & Integer.MIN_VALUE) != 0 : enclosingMethod.isGenerated))) {
            scope.problemReporter().callToCallin(this.binding, this);
            this.resolvedType = null;
            return null;
        }
        if (this.binding.problemId() == 1) {
            if (CharOperation.prefixEquals(IOTConstants.OT_DOLLAR_NAME, this.selector) && scope.referenceType().ignoreFurtherInvestigation) {
                return null;
            }
            if (CalloutImplementor.inferMappingFromCall(scope.referenceType(), this, argumentTypes)) {
                scope.problemReporter().usingInferredCalloutForMessageSend(this);
                returnType = this.binding.returnType;
            }
        } else {
            CalloutMappingDeclaration callout = MethodModel.getImplementingInferredCallout(this.binding);
            if (callout != null) {
                if (callout.isCalloutToField()) {
                    scope.problemReporter().usingInferredCalloutToFieldForMessageSend(this);
                } else {
                    scope.problemReporter().usingInferredCalloutForMessageSend(this);
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    scope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, argumentTypes);
                    return null;
                }
            }
            if (this.binding.problemId() == 2 && this.isDecapsulationAllowed(scope)) {
                this.binding = ((ProblemMethodBinding)this.binding).closestMatch;
                if (!this.binding.declaringClass.isRole()) {
                    scope.enclosingSourceType().roleModel.addInaccessibleBaseMethod(this.binding);
                    this.binding = new MethodBinding(this.binding, this.binding.declaringClass.getRealClass());
                    this.binding.selector = CharOperation.concat(IOTConstants.OT_DECAPS, this.selector);
                }
                this.isDecapsulation = true;
                scope.problemReporter().decapsulation(this, (Scope)scope);
                try {
                    anchorMapping = AnchorMapping.setupNewMapping(this.receiverForAnchorMapping(scope), this.arguments, scope);
                    returnType = RoleTypeCreator.maybeWrapQualifiedRoleType(this, scope);
                }
                finally {
                    AnchorMapping.removeCurrentMapping(anchorMapping);
                }
            } else {
                boolean avoidSecondary;
                ReferenceBinding declaringClass = this.binding.declaringClass;
                boolean bl2 = avoidSecondary = declaringClass != null && declaringClass.isAnonymousType() && declaringClass.superclass() instanceof MissingTypeBinding;
                if (!avoidSecondary) {
                    scope.problemReporter().invalidMethod(this, this.binding);
                }
                MethodBinding closestMatch = ((ProblemMethodBinding)this.binding).closestMatch;
                switch (this.binding.problemId()) {
                    case 3: {
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: {
                        if (closestMatch == null) break;
                        this.resolvedType = closestMatch.returnType;
                    }
                }
                if (closestMatch != null) {
                    this.binding = closestMatch;
                    MethodBinding closestMatchOriginal = closestMatch.original();
                    if (closestMatchOriginal.isOrEnclosedByPrivateType() && !scope.isDefinedInMethod(closestMatchOriginal)) {
                        closestMatchOriginal.modifiers |= 0x8000000;
                    }
                }
                return this.resolvedType != null && (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
            }
        }
        if (this.receiver instanceof BaseReference && !CallinImplementorDyn.DYNAMIC_WEAVING) {
            enclosingMethod = scope.methodScope().referenceMethod();
            if (!enclosingMethod.isCallin()) {
                enclosingMethod = BaseCallMessageSend.getOuterCallinMethod(scope.methodScope());
            }
            MethodBinding basecallSurrogate = null;
            if (enclosingMethod.model != null) {
                basecallSurrogate = enclosingMethod.model.getBaseCallSurrogate();
            }
            if (this.binding != basecallSurrogate) {
                scope.problemReporter().baseCallNotSameMethod(enclosingMethod, this);
            }
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            scope.problemReporter().missingTypeInMethod(this, this.binding);
        }
        CompilerOptions compilerOptions = scope.compilerOptions();
        if (!this.binding.isStatic()) {
            if (receiverIsType) {
                scope.problemReporter().mustUseAStaticMethod(this, this.binding);
                if (this.actualReceiverType.isRawType() && (this.receiver.bits & 0x40000000) == 0 && compilerOptions.getSeverity(0x20010000) != 256) {
                    scope.problemReporter().rawTypeReference(this.receiver, this.actualReceiverType);
                }
            } else {
                TypeBinding oldReceiverType = this.actualReceiverType;
                this.actualReceiverType = this.actualReceiverType.getErasureCompatibleType(this.binding.declaringClass);
                this.receiver.computeConversion(scope, this.actualReceiverType, this.actualReceiverType);
                if (this.actualReceiverType != oldReceiverType && this.receiver.postConversionType(scope) != this.actualReceiverType) {
                    this.bits |= 0x40000;
                }
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || receiverIsType)) {
                scope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && this.binding.declaringClass != this.actualReceiverType) {
                scope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        if (this.checkInvocationArguments(scope, this.receiver, this.actualReceiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this)) {
            this.bits |= 0x10000;
        }
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            scope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        MethodBinding methodBinding = origMethod = this.binding.copyInheritanceSrc != null ? this.binding.copyInheritanceSrc : this.binding;
        if (this.isMethodUseDeprecated(origMethod, scope, true)) {
            scope.problemReporter().deprecatedMethod(origMethod, this);
        }
        if (this.binding.model != null && this.binding.model.isForbiddenCreationMethod()) {
            scope.problemReporter().abstractRoleIsRelevant(this, this.binding.returnType);
        }
        if (this.binding == scope.environment().arrayClone && compilerOptions.sourceLevel >= 0x310000L) {
            this.resolvedType = this.actualReceiverType;
        } else {
            if ((this.bits & 0x10000) != 0 && this.genericTypeArguments == null) {
                returnType = this.binding.returnType;
                if (returnType != null) {
                    returnType = scope.environment().convertToRawType(returnType.erasure(), true);
                }
            } else {
                if (!scope.isGeneratedScope() && returnType instanceof ReferenceBinding) {
                    if (StandardElementGenerator.isCastToMethod(this.selector)) {
                        this.resolvedType = this.binding.returnType;
                    } else {
                        returnType = this.checkStrengthenReturnType((ReferenceBinding)returnType, scope);
                    }
                }
                if (returnType != null) {
                    returnType = returnType.capture(scope, this.sourceEnd);
                }
            }
            this.resolvedType = returnType;
        }
        if (this.receiver.isSuper() && compilerOptions.getSeverity(0x20100000) != 256 && (referenceContext = scope.methodScope().referenceContext) instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration abstractMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
            MethodBinding enclosingMethodBinding = abstractMethodDeclaration.binding;
            if (enclosingMethodBinding.isOverriding() && CharOperation.equals(this.binding.selector, enclosingMethodBinding.selector) && this.binding.areParametersEqual(enclosingMethodBinding)) {
                abstractMethodDeclaration.bits |= 0x10;
            }
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            scope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.genericTypeArguments, this.typeArguments);
        }
        return (this.resolvedType.tagBits & 0x80L) == 0L ? this.resolvedType : null;
    }

    private boolean isQualifiedThis(Expression receiver) {
        if (receiver instanceof QualifiedThisReference) {
            return true;
        }
        if (receiver instanceof BaseReference) {
            return ((BaseReference)receiver).isQualified();
        }
        return false;
    }

    protected boolean isDecapsulationAllowed(Scope scope) {
        if (scope.methodScope().referenceContext instanceof AbstractMethodDeclaration) {
            AbstractMethodDeclaration method = (AbstractMethodDeclaration)scope.methodScope().referenceContext;
            return method.isCalloutWrapper() || method.isBasePredicate();
        }
        return false;
    }

    protected AnchorMapping beforeMethodLookup(TypeBinding[] argumentTypes, Scope scope) {
        AnchorMapping result = null;
        try {
            if (this.actualReceiverType instanceof ReferenceBinding) {
                Dependencies.ensureBindingState((ReferenceBinding)this.actualReceiverType, 19);
            }
        }
        finally {
            result = AnchorMapping.setupNewMapping(this.receiverForAnchorMapping(scope), this.arguments, scope);
        }
        return result;
    }

    private Expression receiverForAnchorMapping(Scope scope) {
        MethodScope methodScope = scope.methodScope();
        if (methodScope != null && methodScope.isCallinWrapper() && this.isCallinRoleMethodCall) {
            return null;
        }
        return this.receiver;
    }

    protected TypeBinding afterMethodLookup(Scope scope, AnchorMapping anchorMapping, TypeBinding[] argumentTypes, TypeBinding returnType) {
        if (this.binding.isValidBinding() && CharOperation.equals(this.binding.declaringClass.compoundName, IOTConstants.ORG_OBJECTTEAMS_TEAM_OTCONFINED) && !CharOperation.equals(this.selector, IOTConstants._OT_GETTEAM)) {
            ReferenceBinding object = scope.getJavaLangObject();
            this.binding = scope.findMethod(object, this.binding.selector, this.binding.parameters, this);
        }
        if (this.binding.isValidBinding() && anchorMapping != null && !anchorMapping.checkInstantiatedParameters(this, scope)) {
            MethodBinding instantiatedMethod = new MethodBinding(this.binding, (ReferenceBinding)this.actualReceiverType);
            instantiatedMethod.parameters = anchorMapping.getInstantiatedParameters(this.binding);
            this.binding = new ProblemMethodBinding(instantiatedMethod, this.selector, this.binding.parameters, 1);
        }
        if (this.binding.isStatic() && this.actualReceiverType.isInterface()) {
            ReferenceBinding receiverType = (ReferenceBinding)this.actualReceiverType;
            assert (receiverType.isRole());
            ReferenceBinding classPart = receiverType.roleModel.getClassPartBinding();
            this.actualReceiverType = classPart;
        }
        if (!scope.isGeneratedScope() && this.binding.returnType instanceof ReferenceBinding && StandardElementGenerator.isCastToMethod(this.selector)) {
            this.resolvedType = this.binding.returnType;
        }
        return returnType;
    }

    public Expression.DecapsulationState getBaseclassDecapsulation() {
        if (CharOperation.equals(this.selector, IOTConstants._OT_GETBASE)) {
            return Expression.DecapsulationState.REPORTED;
        }
        return this.receiver.getBaseclassDecapsulation();
    }

    private TypeBinding checkStrengthenReturnType(TypeBinding returnType, Scope scope) {
        TypeBinding typeBound;
        ReferenceBinding currentType = (ReferenceBinding)returnType.leafComponentType();
        if (currentType.isTypeVariable() && (typeBound = ((TypeVariableBinding)currentType).firstBound) instanceof ReferenceBinding) {
            currentType = (ReferenceBinding)typeBound;
        }
        if (!currentType.isRole()) {
            return returnType;
        }
        ReferenceBinding strengthenedReturnType = null;
        if (currentType instanceof WeakenedTypeBinding) {
            WeakenedTypeBinding weakenedTypeBinding = (WeakenedTypeBinding)currentType;
            if (!weakenedTypeBinding.isSignificantlyWeakened()) {
                return returnType;
            }
            strengthenedReturnType = weakenedTypeBinding.getStrongType();
        } else {
            ReferenceBinding site = (ReferenceBinding)this.actualReceiverType;
            if (this.receiver.isSuper()) {
                site = scope.enclosingSourceType();
            }
            if ((strengthenedReturnType = (ReferenceBinding)TeamModel.strengthenRoleType(site, currentType)) == currentType) {
                return returnType;
            }
            this.resolvedType = WeakenedTypeBinding.makeWeakenedTypeBinding(strengthenedReturnType, currentType, returnType.dimensions());
        }
        this.valueCast = strengthenedReturnType;
        return strengthenedReturnType;
    }

    protected int getDepthForSynthMethodAccess(MethodBinding methodBinding, SourceTypeBinding enclosingSourceType) {
        int depth = (this.bits & 0x1FE0) >> 5;
        if (methodBinding.isPrivate()) {
            return depth;
        }
        if (!methodBinding.isProtected()) {
            return -1;
        }
        if (methodBinding.declaringClass.getPackage() == enclosingSourceType.getPackage() && (depth = TeamModel.levelFromEnclosingTeam(methodBinding.declaringClass, enclosingSourceType)) == 0) {
            return -1;
        }
        return depth;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
        if (receiverType == null) {
            return;
        }
        this.actualReceiverType = receiverType;
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setExpectedType(TypeBinding expectedType) {
        this.expectedType = expectedType;
    }

    public void setFieldIndex(int depth) {
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.receiver.traverse(visitor, blockScope);
            if (this.typeArguments != null) {
                int i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, blockScope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

