/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.HashSet;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemberTypeBinding
extends NestedTypeBinding {
    private static final ReferenceBinding NoBaseclass = new SourceTypeBinding();
    private static final ReferenceBinding ProblemBaseClass = new SourceTypeBinding();
    private boolean hasCheckedBaseclassCircularity = false;

    static {
        MemberTypeBinding.NoBaseclass.compoundName = new char[][]{"No Baseclass".toCharArray()};
        MemberTypeBinding.NoBaseclass.model = new TypeModel(NoBaseclass);
        MemberTypeBinding.NoBaseclass.model.setState(27);
        MemberTypeBinding.ProblemBaseClass.compoundName = new char[][]{"Problem Baseclass".toCharArray()};
        MemberTypeBinding.ProblemBaseClass.model = new TypeModel(ProblemBaseClass);
        MemberTypeBinding.ProblemBaseClass.model.setState(27);
    }

    public MemberTypeBinding(char[][] compoundName, ClassScope scope, SourceTypeBinding enclosingType) {
        super(compoundName, scope, enclosingType);
        this.tagBits |= 0x80CL;
    }

    void checkSyntheticArgsAndFields() {
        if (this.isInterface()) {
            if (this.isRole()) {
                this.addSyntheticArgument(this.enclosingType);
            }
            return;
        }
        if (this.isStatic()) {
            return;
        }
        this.addSyntheticArgumentAndField(this.enclosingType);
    }

    @Override
    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concat(this.enclosingType().constantPoolName(), this.sourceName, '$');
        return this.constantPoolName;
    }

    @Override
    public void initializeDeprecatedAnnotationTagBits() {
        if ((this.tagBits & 0x400000000L) == 0L) {
            super.initializeDeprecatedAnnotationTagBits();
            if ((this.tagBits & 0x400000000000L) == 0L) {
                ReferenceBinding enclosing = this.enclosingType();
                if ((enclosing.tagBits & 0x400000000L) == 0L) {
                    enclosing.initializeDeprecatedAnnotationTagBits();
                }
                if (enclosing.isViewedAsDeprecated()) {
                    this.modifiers |= 0x200000;
                }
            }
        }
    }

    @Override
    public ReferenceBinding baseclass() {
        String circle;
        if (!this.isDirectRole()) {
            return null;
        }
        if (this.baseclass == null) {
            this.baseclass = NoBaseclass;
            if (this.roleModel != null) {
                if (this.isSynthInterface()) {
                    ReferenceBinding classPart = this.getRealClass();
                    if (classPart != null && classPart.baseclass != null) {
                        this.baseclass = classPart.baseclass;
                    }
                    if (this.baseclass != NoBaseclass && this.baseclass != ProblemBaseClass) {
                        return this.baseclass;
                    }
                }
                if (!Dependencies.ensureRoleState(this.roleModel, 7)) {
                    this.scope.problemReporter().searchingBaseclassTooEarly(this);
                    this.tagBits |= 0x800000000000000L;
                    this.baseclass = ProblemBaseClass;
                    return null;
                }
            }
            if (this.superclass() != null && !CharOperation.equals(this.superclass().compoundName, TypeConstants.JAVA_LANG_OBJECT) && this.superclass().isSourceRole()) {
                this.baseclass = this.superclass().baseclass();
            }
            if (this.baseclass == null) {
                this.baseclass = NoBaseclass;
            }
            this.checkRefineBaseFromSuperInterfaces();
        }
        if ((circle = this.hasBaseclassCircularity()) != null) {
            circle = String.valueOf(new String(this.readableName())) + circle;
            this.scope.problemReporter().baseclassCircularity(circle, this.scope.referenceContext.baseclass);
            this.tagBits |= 0x800000000000000L;
        }
        return this.rawBaseclass();
    }

    @Override
    public ReferenceBinding rawBaseclass() {
        return this.baseclass == NoBaseclass || this.baseclass == ProblemBaseClass ? null : this.baseclass;
    }

    private String hasBaseclassCircularity() {
        if (this.hasCheckedBaseclassCircularity) {
            return null;
        }
        this.hasCheckedBaseclassCircularity = true;
        if (this.baseclass == null) {
            return null;
        }
        HashSet<ReferenceBinding> visitedTypes = new HashSet<ReferenceBinding>();
        return this.internalHasBaseclassCircularity(visitedTypes, this.baseclass);
    }

    private String internalHasBaseclassCircularity(HashSet<ReferenceBinding> visitedTypes, ReferenceBinding type) {
        ReferenceBinding[] memberTypes;
        if (type == null || type == NoBaseclass || type == ProblemBaseClass) {
            return null;
        }
        if (visitedTypes.contains(type)) {
            return "";
        }
        visitedTypes.add(type);
        String circle = null;
        if (type.rawBaseclass() != null) {
            circle = this.internalHasBaseclassCircularity(visitedTypes, type.baseclass);
            if (circle != null) {
                return "->" + new String(type.shortReadableName()) + circle;
            }
            visitedTypes.remove(type.baseclass);
        }
        if ((memberTypes = type.memberTypes()) == null) {
            return null;
        }
        ReferenceBinding[] referenceBindingArray = memberTypes;
        int n = memberTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding member = referenceBindingArray[n2];
            circle = this.internalHasBaseclassCircularity(visitedTypes, member);
            if (circle != null) {
                return "->" + new String(type.shortReadableName()) + circle;
            }
            visitedTypes.remove(member);
            ++n2;
        }
        return null;
    }

    public void checkRefineBaseFromSuperInterfaces() {
        TypeDeclaration roleDecl = this.roleModel.getAst();
        if (roleDecl == null) {
            return;
        }
        if (this.superInterfaces != null) {
            int i = 0;
            while (i < this.superInterfaces.length) {
                ReferenceBinding superIfc = this.superInterfaces[i];
                int sStart = roleDecl.declarationSourceStart;
                int sEnd = roleDecl.declarationSourceEnd;
                if (roleDecl.superInterfaces != null && roleDecl.superInterfaces.length > i) {
                    sStart = roleDecl.superInterfaces[i].sourceStart;
                    sEnd = roleDecl.superInterfaces[i].sourceEnd;
                }
                if (superIfc.isDirectRole()) {
                    superIfc.baseclass();
                    this.baseclass = this.checkRefineBase(roleDecl.scope, sStart, sEnd, this.baseclass, superIfc.baseclass);
                    if (this.baseclass == ProblemBaseClass) {
                        this.tagBits |= 0x800000000000000L;
                    }
                    if (this.superclass != null && this.superclass.isRole() && this.rawBaseclass() != null && this.baseclass == this.superclass.baseclass) {
                        this.superclass.roleModel._supercededBy = this;
                    }
                }
                ++i;
            }
        }
    }

    private ReferenceBinding checkRefineBase(ClassScope classScope, int sStart, int sEnd, ReferenceBinding current, ReferenceBinding next) {
        if (next == null || next == NoBaseclass) {
            return current;
        }
        if (current == null || current == NoBaseclass) {
            return next;
        }
        if (current == ProblemBaseClass || next == ProblemBaseClass) {
            return ProblemBaseClass;
        }
        if (current.isCompatibleWith(next)) {
            return current;
        }
        if (next.isCompatibleWith(current)) {
            return next;
        }
        if (current.isRole() && current.roleModel.hasTSuperRole(next.getRealType())) {
            return current;
        }
        if (RoleTypeBinding.isRoleWithExplicitAnchor(current) && RoleTypeBinding.isRoleWithExplicitAnchor(next)) {
            ITeamAnchor currentAnchor = ((RoleTypeBinding)current).getAnchor();
            ITeamAnchor nextAnchor = ((RoleTypeBinding)next).getAnchor();
            if (currentAnchor.isBaseAnchor() && nextAnchor.isBaseAnchor()) {
                ReferenceBinding nextDeclaringType = ((FieldBinding)nextAnchor).getDeclaringClass().getRealType();
                ReferenceBinding currentDeclaringType = ((FieldBinding)currentAnchor).getDeclaringClass().getRealType();
                if (current.getRealType().isCompatibleWith(next.getRealType()) && currentDeclaringType.isCompatibleWith(nextDeclaringType)) {
                    return current;
                }
                if (next.getRealType().isCompatibleWith(current.getRealType()) && nextDeclaringType.isCompatibleWith(currentDeclaringType)) {
                    return next;
                }
            }
        }
        classScope.problemReporter().incompatibleBaseclasses(classScope.referenceContext, sStart, sEnd, current, next);
        this.tagBits |= 0x800000000000000L;
        if (this.isSynthInterface()) {
            this.roleModel.getClassPartBinding().tagBits |= 0x800000000000000L;
        }
        return ProblemBaseClass;
    }

    @Override
    public String toString() {
        return "Member type : " + new String(this.sourceName()) + " " + super.toString();
    }
}

