/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.core.util.FieldData;
import org.eclipse.objectteams.otdt.core.util.MethodData;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCalloutToFieldMapping;

public class CalloutToFieldMapping
extends AbstractCalloutMapping
implements ICalloutToFieldMapping {
    private boolean _isOverride;
    private IField _baseField;
    private FieldData _baseFieldHandle;

    public CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IRoleType role, IMethod correspondingJavaElem, MethodData roleMethodHandle, FieldData baseFieldHandle, boolean hasSignature, boolean isOverride) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, role, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, true);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, FieldData baseFieldHandle, boolean hasSignature, boolean isOverride) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, parentRole, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, true);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, FieldData baseFieldHandle, boolean hasSignature, boolean isOverride, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, correspondingJavaElem, parentRole, roleMethodHandle, hasSignature, addAsChild);
        this._isOverride = isOverride;
        this._baseFieldHandle = baseFieldHandle;
    }

    public IMethodMapping createStealthMethodMapping() {
        CalloutToFieldMapping result = new CalloutToFieldMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), 9, (IType)this.getCorrespondingJavaElement().getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.getBaseFieldHandle(), this.hasSignature(), this.isOverride(), false);
        result._mimicMethodDecl = true;
        result._originalMethodMapping = this;
        return result;
    }

    public boolean isOverride() {
        return this._isOverride;
    }

    public String getElementName() {
        if (this._mimicMethodDecl) {
            MethodData roleMethodHandle = this.getRoleMethodHandle();
            if (roleMethodHandle != null) {
                return roleMethodHandle.getSelector();
            }
            return "(unknown role method)";
        }
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" -> ");
        if (this.hasSignature()) {
            name.append(this._baseFieldHandle.toString());
        } else {
            name.append(this._baseFieldHandle.getSelector());
        }
        return name.toString();
    }

    public int getMappingKind() {
        return 104;
    }

    public IField getBoundBaseField() throws JavaModelException {
        if (this._baseField == null) {
            this._baseField = this.findBaseField();
        }
        return this._baseField;
    }

    public FieldData getBaseFieldHandle() {
        return this._baseFieldHandle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CalloutToFieldMapping)) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "callout to field" + super.toString();
    }

    private IField findBaseField() throws JavaModelException {
        IType baseClass = ((IRoleType)this.getParent()).getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        return this.findField(typeParents, this._baseFieldHandle);
    }

    private IField findField(IType[] types, FieldData fieldHandle) throws JavaModelException {
        int idx = 0;
        while (idx < types.length) {
            IField[] fields = types[idx].getFields();
            int idy = 0;
            while (idy < fields.length) {
                IField tmpField = fields[idy];
                if (tmpField.getElementName().equals(fieldHandle.getSelector())) {
                    return tmpField;
                }
                ++idy;
            }
            ++idx;
        }
        return null;
    }

    protected char getMappingKindChar() {
        if (this._baseFieldHandle.isSetter()) {
            if (this._isOverride) {
                return 'S';
            }
            return 's';
        }
        if (this._isOverride) {
            return 'G';
        }
        return 'g';
    }

    protected void getBaseMethodsForHandle(StringBuffer buff) {
        JavaElement.escapeMementoName(buff, this._baseFieldHandle.getSelector());
        buff.append('~');
        JavaElement.escapeMementoName(buff, this._baseFieldHandle.getFieldType());
    }

    public static FieldData createFieldData(MementoTokenizer memento, boolean isSetter) {
        String selector = memento.nextToken();
        String cur = memento.nextToken();
        if (cur.charAt(0) == '~') {
            cur = memento.nextToken();
        }
        StringBuffer buffer = new StringBuffer();
        while (cur.length() == 1 && '[' == cur.charAt(0)) {
            buffer.append('[');
            if (!memento.hasMoreTokens()) break;
            cur = memento.nextToken();
        }
        buffer.append(cur);
        String fieldType = buffer.toString();
        memento.nextToken();
        return new FieldData(selector, fieldType, isSetter);
    }

    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCalloutToFieldMapping resolvedHandle = new ResolvedCalloutToFieldMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), this.getElementType(), (IType)this.getParent(), this.getIMethod(), this.getRoleMethodHandle(), this._baseFieldHandle, this.hasSignature(), this.isOverride(), new String(uniqueKey));
        if (this.isStealthMethodMapping()) {
            resolvedHandle._originalMethodMapping = this._originalMethodMapping;
        }
        return resolvedHandle;
    }
}

