/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.PhantomType;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchy;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchyHelper;
import org.eclipse.objectteams.otdt.internal.core.TypeHierarchyConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CopyInheritanceInfo {
    private Map<String, IType> _roles = new HashMap<String, IType>();
    private Map<String, Object> _superclasses = new HashMap<String, Object>();
    private Map<String, List<Object>> _superInterfaces = new HashMap<String, List<Object>>();
    private OTTypeHierarchy _hierarchy;
    private IType _team;

    public CopyInheritanceInfo(OTTypeHierarchy hierarchy, IType teamType) {
        this._hierarchy = hierarchy;
        this._team = teamType;
    }

    protected void addDeclaredRoles(IType[] roles) throws JavaModelException {
        int idx = 0;
        while (idx < roles.length) {
            IType role = roles[idx];
            this._roles.put(role.getElementName(), role);
            if (!role.isInterface()) {
                if (OTTypeHierarchyHelper.isTeam(role)) {
                    this._superclasses.put(role.getElementName(), this._hierarchy.ORG_OBJECTTEAMS_TEAM);
                    this._hierarchy.addRootClass(this._hierarchy.ORG_OBJECTTEAMS_TEAM);
                } else {
                    this._superclasses.put(role.getElementName(), this._hierarchy.JAVA_LANG_OBJECT);
                    this._hierarchy.addRootClass(this._hierarchy.JAVA_LANG_OBJECT);
                }
            }
            ++idx;
        }
    }

    protected void addDeclaredInheritance(IType[] roles) throws JavaModelException {
        int roleIdx = 0;
        while (roleIdx < roles.length) {
            String superclassName;
            IType role = roles[roleIdx];
            String roleName = role.getElementName();
            TypeHierarchyConnector connector = null;
            if (!role.isInterface() && (superclassName = role.getSuperclassName()) != null) {
                if (this._roles.containsKey(superclassName)) {
                    this._superclasses.put(roleName, superclassName);
                } else {
                    connector = this._hierarchy.getTypeHierarchyConnector(role);
                    this._hierarchy.connect(connector);
                    IType superclassType = connector.getSuperclass(role);
                    this._superclasses.put(roleName, superclassType);
                }
            }
            String[] superInterfaceNames = role.getSuperInterfaceNames();
            List<Object> existantSuperInterfaces = this._superInterfaces.get(roleName);
            if (existantSuperInterfaces == null && superInterfaceNames.length > 0) {
                existantSuperInterfaces = new LinkedList<Object>();
                this._superInterfaces.put(roleName, existantSuperInterfaces);
            }
            int idx = 0;
            while (idx < superInterfaceNames.length) {
                String superInterfaceName = superInterfaceNames[idx];
                if (this._roles.containsKey(superInterfaceName)) {
                    if (!existantSuperInterfaces.contains(superInterfaceName)) {
                        existantSuperInterfaces.add(superInterfaceName);
                    }
                } else {
                    if (connector == null) {
                        connector = this._hierarchy.getTypeHierarchyConnector(role);
                        this._hierarchy.connect(connector);
                    }
                    IType[] superInterfaceTypes = connector.getSuperInterfaces(this._roles.get(roleName));
                    int interfaceIdx = 0;
                    while (interfaceIdx < superInterfaceTypes.length) {
                        IType superInterfaceType = superInterfaceTypes[interfaceIdx];
                        if (superInterfaceType.getElementName().equals(superInterfaceName)) {
                            existantSuperInterfaces.add(superInterfaceType);
                            break;
                        }
                        ++interfaceIdx;
                    }
                }
                ++idx;
            }
            ++roleIdx;
        }
    }

    protected void inherit(CopyInheritanceInfo superInfo) throws JavaModelException {
        if (superInfo != null) {
            this.addInheritedRoles(superInfo._roles);
            this.addInheritedSuperClasses(superInfo._superclasses);
            this.addInheritedSuperInterfaces(superInfo._superInterfaces);
        }
    }

    protected void updateHierarchy() {
        for (String roleName : this._roles.keySet()) {
            IType[] superInterfaces;
            IType role = this._roles.get(roleName);
            IType superclass = this.getSuperclass(roleName);
            if (superclass != null) {
                this._hierarchy.cacheSuperclass(role, superclass);
            }
            if ((superInterfaces = this.getSuperInterfaces(roleName)) == null) continue;
            this._hierarchy.cacheSuperInterfaces(role, superInterfaces);
        }
    }

    protected void updateHierarchy(OTTypeHierarchy hierarchy) {
        for (String roleName : this._roles.keySet()) {
            IType[] superInterfaces;
            IType role = this._roles.get(roleName);
            IType superclass = this.getSuperclass(roleName);
            if (superclass != null) {
                hierarchy.cacheSuperclass(role, superclass);
            }
            if ((superInterfaces = this.getSuperInterfaces(roleName)) == null) continue;
            hierarchy.cacheSuperInterfaces(role, superInterfaces);
        }
    }

    private void addInheritedRoles(Map<String, IType> tsuperRoles) throws JavaModelException {
        for (String roleName : tsuperRoles.keySet()) {
            IType tsuperRole = tsuperRoles.get(roleName);
            IType localRoleType = null;
            if (this._roles.containsKey(roleName)) {
                localRoleType = this._roles.get(roleName);
            } else {
                localRoleType = new PhantomType(this._team, tsuperRole);
                this._roles.put(roleName, localRoleType);
            }
            this._hierarchy.addTSupertype(localRoleType, tsuperRole);
            if (!(localRoleType instanceof PhantomType)) continue;
            ((PhantomType)localRoleType).setRealType(tsuperRole);
        }
    }

    private void addInheritedSuperClasses(Map<String, Object> superclasses) {
        this._superclasses.putAll(superclasses);
    }

    private void addInheritedSuperInterfaces(Map<String, List<Object>> superInterfaces) {
        for (String roleName : superInterfaces.keySet()) {
            List<Object> existantSuperInterfaces = this._superInterfaces.get(roleName);
            if (existantSuperInterfaces == null) {
                existantSuperInterfaces = new LinkedList<Object>();
                this._superInterfaces.put(roleName, existantSuperInterfaces);
            }
            existantSuperInterfaces.addAll((Collection<Object>)superInterfaces.get(roleName));
        }
    }

    private IType getSuperclass(String roleName) {
        IType result = null;
        Object superclassObj = this._superclasses.get(roleName);
        if (superclassObj instanceof String) {
            String superclassName = (String)superclassObj;
            result = this._roles.get(superclassName);
        } else {
            result = (IType)superclassObj;
        }
        return result;
    }

    private IType[] getSuperInterfaces(String roleName) {
        List<Object> superInterfaces = this._superInterfaces.get(roleName);
        if (superInterfaces == null) {
            return null;
        }
        IType[] result = new IType[superInterfaces.size()];
        int idx = 0;
        for (Object superInterfaceObj : superInterfaces) {
            if (superInterfaceObj instanceof String) {
                String superInterfaceName = (String)superInterfaceObj;
                IType superInterfaceType = this._roles.get(superInterfaceName);
                result[idx++] = superInterfaceType;
                continue;
            }
            IType superInterfaceType = (IType)superInterfaceObj;
            result[idx++] = superInterfaceType;
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(this._team.getElementName()) + "\n");
        buffer.append("Roles...\n");
        for (String roleName : this._roles.keySet()) {
            IType role = this._roles.get(roleName);
            buffer.append("- ");
            buffer.append(role.getFullyQualifiedName('.'));
            buffer.append("\n");
        }
        buffer.append("Superclasses...\n");
        for (String roleName : this._superclasses.keySet()) {
            Object superclass = this._superclasses.get(roleName);
            if (superclass instanceof String) {
                buffer.append("  ");
                buffer.append(roleName);
                buffer.append(" -> ");
                buffer.append((String)superclass);
                buffer.append("\n");
                continue;
            }
            if (!(superclass instanceof IType)) continue;
            buffer.append("  ");
            buffer.append(roleName);
            buffer.append(" -> ");
            buffer.append(((IType)superclass).getFullyQualifiedName('.'));
            buffer.append("\n");
        }
        buffer.append("Superinterfaces...\n");
        for (String roleName : this._superInterfaces.keySet()) {
            List<Object> superInterfaces = this._superInterfaces.get(roleName);
            int idx = 0;
            while (idx < superInterfaces.size()) {
                Object superInterface = superInterfaces.get(idx);
                if (superInterface instanceof String) {
                    buffer.append("  ");
                    buffer.append(roleName);
                    buffer.append(" -> ");
                    buffer.append((String)superInterface);
                    buffer.append("\n");
                } else if (superInterface instanceof IType) {
                    buffer.append("  ");
                    buffer.append(roleName);
                    buffer.append(" -> ");
                    buffer.append(((IType)superInterface).getFullyQualifiedName('.'));
                    buffer.append("\n");
                }
                ++idx;
            }
        }
        return buffer.toString();
    }
}

