/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.HashMap;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.TraverseRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritedMethodsRequestor
extends TraverseRequestor {
    private HashMap<String, IMethod> _result = new HashMap();
    private boolean _overwriteCollectedMethods;
    private boolean _checkVisibility;

    public InheritedMethodsRequestor(IType type, boolean overwriteCollectedMethods, boolean checkVisibility) {
        this._focusType = type;
        this._overwriteCollectedMethods = overwriteCollectedMethods;
        this._checkVisibility = checkVisibility;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void report(IType type, HashMap<String, Boolean> context) {
        boolean isFocusType = context.get("isFocusType");
        boolean isExplicitSuperclass = context.get("isExplicitSuperclass");
        boolean isBehindExplicitInheritance = context.get("isBehindExplicitInheritance");
        try {
            boolean checkVisibility;
            if (!this._checkVisibility) {
                checkVisibility = false;
            } else if (type.isInterface()) {
                if (!this._focusType.isInterface()) return;
                checkVisibility = false;
            } else {
                checkVisibility = isFocusType ? false : isExplicitSuperclass || isBehindExplicitInheritance;
            }
            this.writeMethodsToResult(type, checkVisibility);
            return;
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void writeMethodsToResult(IType type, boolean checkVisibility) throws JavaModelException {
        IMethod[] methods = type.getMethods();
        IMethod currMethod = null;
        int methodIdx = 0;
        while (methodIdx < methods.length) {
            currMethod = methods[methodIdx];
            if (!currMethod.getElementName().startsWith("_OT$") && !currMethod.isConstructor()) {
                if (checkVisibility) {
                    if (!Flags.isPrivate(currMethod.getFlags())) {
                        if (Flags.isPublic(currMethod.getFlags()) || Flags.isProtected(currMethod.getFlags())) {
                            this.storeMethod(currMethod);
                        } else if (type.getPackageFragment().equals(this._focusType.getPackageFragment())) {
                            this.storeMethod(currMethod);
                        }
                    }
                } else {
                    this.storeMethod(currMethod);
                }
            }
            ++methodIdx;
        }
    }

    private void storeMethod(IMethod method) {
        String key = TypeHelper.getMethodSignature(method);
        if (!this._overwriteCollectedMethods) {
            if (!this._result.containsKey(key)) {
                this._result.put(key, method);
            }
        } else {
            this._result.put(key, method);
        }
    }

    public IMethod[] getResult() {
        return this._result.values().toArray(new IMethod[this._result.size()]);
    }
}

