/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.IOTJavaElement;

public abstract class OTJavaElement
extends Member
implements IOTJavaElement {
    public static final char OTEM_METHODMAPPING = '`';
    public static final String METHODMAPPING = Character.toString('`');
    private int _type;
    private List<IJavaElement> _children;
    private IJavaElement _correspondingJavaElem;

    public OTJavaElement(int type, IJavaElement correspondingJavaElem, IJavaElement parent) {
        this(type, correspondingJavaElem, parent, true);
    }

    public OTJavaElement(int type, IJavaElement correspondingJavaElem, IJavaElement parent, boolean addAsChild) {
        super((JavaElement)parent);
        this._type = type;
        this._correspondingJavaElem = correspondingJavaElem;
        this._children = new ArrayList<IJavaElement>();
        if (addAsChild && parent instanceof OTJavaElement) {
            ((OTJavaElement)parent).addChild(this);
        }
    }

    public boolean hasChildren() {
        return this._children.size() > 0;
    }

    public IJavaElement[] getChildren() {
        if (this._children.isEmpty() && this._correspondingJavaElem instanceof IType) {
            try {
                IJavaElement[] iJavaElementArray = ((IType)this._correspondingJavaElem).getChildren();
                int n = iJavaElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement child = iJavaElementArray[n2];
                    this._children.add(child);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return this._children.toArray(new IJavaElement[this._children.size()]);
    }

    public void addChild(IOTJavaElement child) {
        if (child != null) {
            this._children.add(child);
        }
    }

    public IJavaElement getParent() {
        IJavaElement result = this.parent;
        if (result == null) {
            result = this.getCorrespondingJavaElement().getParent();
        }
        return result;
    }

    public String getElementName() {
        return this.getCorrespondingJavaElement().getElementName();
    }

    public int getElementType() {
        return this._type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        OTJavaElement other = (OTJavaElement)obj;
        return this.getParent().equals(other.getParent()) && this._type == other._type && this.getCorrespondingJavaElement().equals(other.getCorrespondingJavaElement());
    }

    public int hashCode() {
        IJavaElement parent = this.getParent();
        if (parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getElementName().hashCode(), parent.hashCode());
    }

    public String toString() {
        return "OTJavaElement " + this.getElementName();
    }

    public IJavaElement getCorrespondingJavaElement() {
        return this._correspondingJavaElem;
    }

    public OTJavaElement resolved(Binding binding) {
        return this;
    }

    public void setCorrespondingJavaElement(IJavaElement javaElem) {
        this._correspondingJavaElem = javaElem;
    }

    public boolean exists() {
        return this._correspondingJavaElem.exists();
    }

    public void close() throws JavaModelException {
        super.close();
        ((JavaElement)this._correspondingJavaElem).close();
    }

    public IJavaElement getAncestor(int ancestorType) {
        IJavaElement element = this;
        while (element != null) {
            if (element.getElementType() == ancestorType) {
                return element;
            }
            element = element.getParent();
        }
        return this._correspondingJavaElem.getAncestor(ancestorType);
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        return this._correspondingJavaElem.getCorrespondingResource();
    }

    public String getHandleIdentifier() {
        return this._correspondingJavaElem.getHandleIdentifier();
    }

    public IJavaModel getJavaModel() {
        return this._correspondingJavaElem.getJavaModel();
    }

    public IJavaProject getJavaProject() {
        return this._correspondingJavaElem.getJavaProject();
    }

    public IOpenable getOpenable() {
        return this._correspondingJavaElem.getOpenable();
    }

    public IPath getPath() {
        return this._correspondingJavaElem.getPath();
    }

    public IJavaElement getPrimaryElement() {
        return this._correspondingJavaElem.getPrimaryElement();
    }

    public IResource getResource() {
        return this._correspondingJavaElem.getResource();
    }

    public ISchedulingRule getSchedulingRule() {
        return this._correspondingJavaElem.getSchedulingRule();
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        return this._correspondingJavaElem.getUnderlyingResource();
    }

    public boolean isReadOnly() {
        return this._correspondingJavaElem.isReadOnly();
    }

    public boolean isStructureKnown() throws JavaModelException {
        return this._correspondingJavaElem.isStructureKnown();
    }

    public Object getAdapter(Class adapter) {
        Object result = super.getAdapter(adapter);
        if (result == null) {
            result = this._correspondingJavaElem.getAdapter(adapter);
        }
        return result;
    }

    public void toString(int tab, StringBuffer buffer) {
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        buffer.append(this.toString());
    }
}

