/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.TypeVector;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IOTTypeHierarchy;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.PhantomType;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.CopyInheritanceInfo;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchyBuilder;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchyCache;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchyHelper;
import org.eclipse.objectteams.otdt.internal.core.TypeHierarchyConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTTypeHierarchy
extends TypeHierarchy
implements IOTTypeHierarchy {
    private static int EXPLICIT = 1;
    private static int IMPLICIT = 2;
    protected Map<IType, TypeVector> _typeToTSuperTypes;
    protected Map<IType, TypeVector> _typeToTSubTypes;
    protected Map<IType, CopyInheritanceInfo> _copyInheritanceInfos;
    protected OTTypeHierarchyCache _hierarchyCache;
    protected boolean _phantomMode = false;
    protected IType JAVA_LANG_OBJECT;
    protected IType ORG_OBJECTTEAMS_TEAM;

    public OTTypeHierarchy(IType type, IJavaProject project, boolean computeSubtypes) {
        this(OTTypeHierarchyHelper.getJavaModelIType(type), project, computeSubtypes, new OTTypeHierarchyCache());
    }

    protected OTTypeHierarchy(IType type, IJavaProject project, boolean computeSubtypes, OTTypeHierarchyCache cache) {
        super(OTTypeHierarchyHelper.getJavaModelIType(type), new ICompilationUnit[0], project, computeSubtypes);
        this.init(cache);
    }

    public OTTypeHierarchy(IType type, boolean computeSubtypes) {
        super(type, JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, true), SearchEngine.createWorkspaceScope(), computeSubtypes);
        this.init(new OTTypeHierarchyCache());
    }

    private void init(OTTypeHierarchyCache cache) {
        block2: {
            this._hierarchyCache = cache;
            try {
                this.JAVA_LANG_OBJECT = this.focusType.getJavaProject().findType("java.lang.Object");
                this.ORG_OBJECTTEAMS_TEAM = this.focusType.getJavaProject().findType(TypeHelper.ORG_OBJECTTEAMS_TEAM);
            }
            catch (JavaModelException javaModelException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public IType[] getAllClasses() {
        return this.filterPhantomTypes(super.getAllClasses());
    }

    @Override
    public IType[] getAllInterfaces() {
        return super.getAllInterfaces();
    }

    @Override
    public IType[] getAllTypes() {
        return this.filterPhantomTypes(super.getAllTypes());
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.getAllSubtypesForType(OTTypeHierarchyHelper.getJavaModelIType(type), IMPLICIT | EXPLICIT));
    }

    @Override
    public IType[] getAllTSubtypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.getAllSubtypesForType(OTTypeHierarchyHelper.getJavaModelIType(type), IMPLICIT));
    }

    private IType[] getAllSubtypesForType(IType type, int kind) {
        ArrayList<IType> subs = new ArrayList<IType>();
        this.getAllSubtypesForType0(type, subs, kind);
        return subs.toArray(new IType[subs.size()]);
    }

    private void getAllSubtypesForType0(IType type, ArrayList<IType> subs, int kind) {
        int idx;
        IType[] subtypes;
        if ((kind & IMPLICIT) != 0) {
            subtypes = this.getSubtypesForType(type, IMPLICIT);
            idx = 0;
            while (idx < subtypes.length) {
                if (!this.isDefaultMode() || !(subtypes[idx] instanceof PhantomType)) {
                    subs.add(subtypes[idx]);
                }
                this.getAllSubtypesForType0(subtypes[idx], subs, kind);
                ++idx;
            }
        }
        if ((kind & EXPLICIT) != 0) {
            subtypes = this.getSubtypesForType(type, EXPLICIT);
            idx = 0;
            while (idx < subtypes.length) {
                if (this.isDefaultMode() && subtypes[idx] instanceof PhantomType) {
                    subs.add(((PhantomType)subtypes[idx]).getRealType());
                } else {
                    subs.add(subtypes[idx]);
                }
                this.getAllSubtypesForType0(subtypes[idx], subs, kind);
                ++idx;
            }
        }
    }

    @Override
    public IType[] getAllSuperclasses(IType type) {
        if (this.isInterface(type)) {
            return NO_TYPE;
        }
        return OTTypeHierarchy.filterDuplicates(this.filterPhantomTypes(this.getAllSuperclassesForType(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getAllSuperclassesForType(IType type) {
        TypeVector supers = new TypeVector();
        this.getAllSuperclasses0(type, supers);
        return supers.elements();
    }

    private void getAllSuperclasses0(IType type, TypeVector supers) {
        IType[] superclasses = this.getSuperclasses0(type);
        supers.addAll(superclasses);
        int idx = 0;
        while (idx < superclasses.length) {
            this.getAllSuperclasses0(superclasses[idx], supers);
            ++idx;
        }
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type) {
        return this.filterPhantomTypes(this.getAllSuperInterfacesForType(OTTypeHierarchyHelper.getJavaModelIType(type)));
    }

    private IType[] getAllSuperInterfacesForType(IType type) {
        ArrayList<IType> supers = new ArrayList<IType>();
        this.getAllSuperInterfaces0(type, supers);
        return supers.toArray(new IType[supers.size()]);
    }

    private void getAllSuperInterfaces0(IType type, ArrayList<IType> supers) {
        IType superclass;
        IType[] superinterfaces = (IType[])this.typeToSuperInterfaces.get(type);
        if (superinterfaces != null && superinterfaces.length != 0) {
            this.addAllCheckingDuplicates(supers, superinterfaces);
            int i = 0;
            while (i < superinterfaces.length) {
                this.getAllSuperInterfaces0(superinterfaces[i], supers);
                ++i;
            }
        }
        if ((superclass = (IType)this.classToSuperclass.get(type)) != null) {
            this.getAllSuperInterfaces0(superclass, supers);
        }
        if (this.isInterface(type)) {
            this.addAllCheckingDuplicates(supers, this.getAllTSuperTypes0(type));
        }
    }

    @Override
    public IType[] getAllSupertypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.filterPhantomTypes(this.getAllSupertypes0(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getAllSupertypes0(IType type) {
        TypeVector supers = new TypeVector();
        IType[] supertypes = this.getSupertypes0(type);
        supers.addAll(supertypes);
        int idx = 0;
        while (idx < supertypes.length) {
            supers.addAll(this.getAllSupertypes0(supertypes[idx]));
            ++idx;
        }
        return supers.elements();
    }

    @Override
    public IType[] getAllTSuperTypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.filterPhantomTypes(this.getAllTSuperTypes0(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getAllTSuperTypes0(IType type) {
        TypeVector result = new TypeVector();
        IType[] tsupers = this.getTSuperTypes0(type);
        result.addAll(tsupers);
        int idx = 0;
        while (idx < tsupers.length) {
            IType tsup = tsupers[idx];
            result.addAll(this.getAllTSuperTypes0(tsup));
            ++idx;
        }
        return result.elements();
    }

    @Override
    public IType[] getSubclasses(IType type) {
        if (this.isInterface(type)) {
            return NO_TYPE;
        }
        return this.getSubtypes(OTTypeHierarchyHelper.getJavaModelIType(type));
    }

    @Override
    public IType[] getSubtypes(IType type) {
        if (this.isPhantomMode()) {
            return this.getSubtypesForType(OTTypeHierarchyHelper.getJavaModelIType(type), EXPLICIT | IMPLICIT);
        }
        ArrayList<IType> realSubtypes = new ArrayList<IType>();
        this.getRealSubtypesForType(OTTypeHierarchyHelper.getJavaModelIType(type), realSubtypes, EXPLICIT | IMPLICIT);
        return OTTypeHierarchy.filterDuplicates(realSubtypes.toArray(new IType[realSubtypes.size()]));
    }

    private IType[] getSubtypesForType(IType type, int kind) {
        TypeVector result = new TypeVector();
        if ((kind & EXPLICIT) != 0) {
            result.addAll(super.getSubtypes(type));
        }
        if ((kind & IMPLICIT) != 0) {
            result.addAll(this.getTSubtypesForType(type));
        }
        return result.elements();
    }

    private IType[] getTSubtypesForType(IType type) {
        TypeVector vector = this._typeToTSubTypes.get(type);
        if (vector == null) {
            return NO_TYPE;
        }
        return vector.elements();
    }

    private void getRealSubtypesForType(IType type, ArrayList<IType> realSubtypes, int kind) {
        IType[] subtypes = this.getSubtypesForType(type, kind);
        int idx = 0;
        while (idx < subtypes.length) {
            IType subtype = subtypes[idx];
            if (subtype instanceof PhantomType) {
                if (type.equals(this.getExplicitSuperclass(subtype))) {
                    if (!realSubtypes.contains(subtype)) {
                        realSubtypes.add(((PhantomType)subtype).getRealType());
                    }
                    this.getRealSubtypesForType(subtypes[idx], realSubtypes, IMPLICIT);
                } else {
                    this.getRealSubtypesForType(subtypes[idx], realSubtypes, EXPLICIT | IMPLICIT);
                }
            } else if (!realSubtypes.contains(subtypes[idx])) {
                realSubtypes.add(subtypes[idx]);
            }
            ++idx;
        }
    }

    @Override
    public IType getExplicitSuperclass(IType type) {
        return this.replacePhantomType(this.getExplicitSuperclass0(OTTypeHierarchyHelper.getJavaModelIType(type)));
    }

    private IType getExplicitSuperclass0(IType currentType) {
        return super.getSuperclass(currentType);
    }

    @Override
    public IType[] getTSuperTypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.replacePhantomType(this.getTSuperTypes0(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getTSuperTypes0(IType type) {
        TypeVector result = this._typeToTSuperTypes.get(type);
        return result != null ? result.elements() : NO_TYPE;
    }

    @Override
    public IType getSuperclass(IType type) {
        IOTType otType = OTModelManager.getOTElement(type);
        if (otType != null && otType.isRole()) {
            throw new UnsupportedOperationException("OT types have no single supertype");
        }
        return super.getSuperclass(OTTypeHierarchyHelper.getJavaModelIType(type));
    }

    public IType[] getSuperclasses(IType type) {
        if (this.isInterface(type)) {
            return NO_TYPE;
        }
        return OTTypeHierarchy.filterDuplicates(this.replacePhantomType(this.getSuperclasses0(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getSuperclasses0(IType type) {
        IType[] result = this.getTSuperTypes0(type);
        IType explicitSuperclass = this.getExplicitSuperclass0(type);
        if (explicitSuperclass != null) {
            result = this.growAndAddToArray(result, explicitSuperclass);
        }
        return result;
    }

    @Override
    public IType[] getSuperInterfaces(IType type) {
        return this.replacePhantomType(this.getSuperInterfaces0(OTTypeHierarchyHelper.getJavaModelIType(type)));
    }

    private IType[] getSuperInterfaces0(IType type) {
        IType[] result = super.getSuperInterfaces(type);
        if (this.isInterface(type)) {
            result = this.growAndAddToArray(result, this.getTSuperTypes0(type));
        }
        return result;
    }

    @Override
    public IType[] getSupertypes(IType type) {
        return OTTypeHierarchy.filterDuplicates(this.replacePhantomType(this.getSupertypes0(OTTypeHierarchyHelper.getJavaModelIType(type))));
    }

    private IType[] getSupertypes0(IType type) {
        IType[] result = this.getSuperclasses0(type);
        result = this.growAndAddToArray(result, this.getSuperInterfaces0(type));
        return result;
    }

    @Override
    public IType[] getExtendingInterfaces(IType type) {
        return this.filterPhantomTypes(super.getExtendingInterfaces(OTTypeHierarchyHelper.getJavaModelIType(type)));
    }

    @Override
    public IType[] getImplementingClasses(IType type) {
        return this.filterPhantomTypes(super.getImplementingClasses(OTTypeHierarchyHelper.getJavaModelIType(type)));
    }

    @Override
    public boolean contains(IType type) {
        if (super.contains(OTTypeHierarchyHelper.getJavaModelIType(type))) {
            return true;
        }
        return this._typeToTSuperTypes.containsKey(OTTypeHierarchyHelper.getJavaModelIType(type));
    }

    @Override
    public int getCachedFlags(IType type) {
        int flags = super.getCachedFlags(type);
        if (flags == -1) {
            try {
                flags = type.getFlags();
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        return flags;
    }

    @Override
    public IType[] getRootClasses() {
        return super.getRootClasses();
    }

    @Override
    public IType[] getRootInterfaces() {
        return super.getRootInterfaces();
    }

    @Override
    protected void initialize(int size) {
        super.initialize(size);
        this._typeToTSuperTypes = new HashMap<IType, TypeVector>(size);
        this._typeToTSubTypes = new HashMap<IType, TypeVector>(size);
        this._copyInheritanceInfos = new HashMap<IType, CopyInheritanceInfo>(size);
    }

    @Override
    protected void cacheSuperclass(IType type, IType superclass) {
        super.cacheSuperclass(type, superclass);
    }

    @Override
    protected void cacheSuperInterfaces(IType type, IType[] superinterfaces) {
        super.cacheSuperInterfaces(type, superinterfaces);
    }

    public boolean hasSubtypes() {
        return this.computeSubtypes;
    }

    @Override
    public void setPhantomMode(boolean flag) {
        this._phantomMode = flag;
    }

    @Override
    public boolean isPhantomMode() {
        return this._phantomMode;
    }

    public boolean isDefaultMode() {
        return !this._phantomMode;
    }

    @Override
    public IType getFocusType() {
        return this.focusType;
    }

    protected void addTSupertype(IType type, IType tsuperType) {
        TypeVector tsuperTypes = this._typeToTSuperTypes.get(type);
        if (tsuperTypes == null) {
            tsuperTypes = new TypeVector();
            this._typeToTSuperTypes.put(type, tsuperTypes);
        }
        if (!tsuperTypes.contains(tsuperType)) {
            tsuperTypes.add(tsuperType);
            this.addTSubtype(tsuperType, type);
        }
    }

    protected void addTSubtype(IType type, IType subtype) {
        TypeVector tsubTypes = this._typeToTSubTypes.get(type);
        if (tsubTypes == null) {
            tsubTypes = new TypeVector();
            this._typeToTSubTypes.put(type, tsubTypes);
        }
        if (!tsubTypes.contains(subtype)) {
            tsubTypes.add(subtype);
        }
    }

    @Override
    protected void addSubtype(IType type, IType subtype) {
        super.addSubtype(type, subtype);
        if (type instanceof PhantomType) {
            this.addSubtype(((PhantomType)type).getRealType(), subtype);
        }
    }

    @Override
    protected void addRootClass(IType type) {
        super.addRootClass(type);
    }

    protected CopyInheritanceInfo getCopyInheritanceInfo(IType teamType) {
        return this._copyInheritanceInfos.get(teamType);
    }

    protected void setCopyInheritanceInfo(IType teamType, CopyInheritanceInfo info) {
        this._copyInheritanceInfos.put(teamType, info);
    }

    void integrate(OTTypeHierarchy hierarchy) {
        this.classToSuperclass.putAll(hierarchy.classToSuperclass);
        this.typeToSuperInterfaces.putAll(hierarchy.typeToSuperInterfaces);
        this._typeToTSuperTypes.putAll(hierarchy._typeToTSuperTypes);
        OTTypeHierarchyHelper.addAllCheckingDuplicates(this.typeToSubtypes, hierarchy.typeToSubtypes);
        OTTypeHierarchyHelper.addAllCheckingDuplicates(this._typeToTSubTypes, hierarchy._typeToTSubTypes);
        this.typeFlags.putAll(hierarchy.typeFlags);
    }

    protected void connect(TypeHierarchyConnector connector) {
        this.typeToSuperInterfaces.putAll(connector.getTypeToSuperInterfaces());
        this.classToSuperclass.putAll(connector.getClasstoSuperclass());
        this.typeToSubtypes.putAll(connector.getTypeToSubtypes());
        this.interfaces = new ArrayList<IType>(Arrays.asList(connector.getAllInterfaces()));
        this.rootClasses = new TypeVector(connector.getRootClasses());
        this.typeFlags.putAll(connector.getTypeFlags());
    }

    protected IJavaProject getProject() {
        return this.project;
    }

    @Override
    protected void compute() throws JavaModelException, CoreException {
        if (this.focusType != null) {
            OTTypeHierarchyBuilder builder = new OTTypeHierarchyBuilder(this);
            builder.build(this.computeSubtypes);
        }
    }

    @Override
    public IOTTypeHierarchy getOTSuperTypeHierarchy(IType type) throws JavaModelException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        OTTypeHierarchy otHierarchy = this._hierarchyCache.getOTTypeHierarchy(OTTypeHierarchyHelper.getJavaModelIType(type));
        if (otHierarchy == null) {
            otHierarchy = new OTTypeHierarchy(type, type.getJavaProject(), false, this._hierarchyCache);
            otHierarchy.refresh((IProgressMonitor)new NullProgressMonitor());
            this._hierarchyCache.cacheOTTypeHierarchy(otHierarchy);
        }
        return otHierarchy;
    }

    protected TypeHierarchyConnector getTypeHierarchyConnector(IType type) throws JavaModelException {
        TypeHierarchyConnector connector;
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this._hierarchyCache == null) {
            this._hierarchyCache = new OTTypeHierarchyCache();
        }
        if ((connector = this._hierarchyCache.getTypeHierachyQuery(type)) == null) {
            connector = new TypeHierarchyConnector(type, type.getJavaProject(), false);
            connector.refresh((IProgressMonitor)new NullProgressMonitor());
            this._hierarchyCache.cacheTypeHierarchyQuery(connector);
        }
        return connector;
    }

    private IType replacePhantomType(IType type) {
        if (type != null && !this.isPhantomMode() && type instanceof PhantomType) {
            return ((PhantomType)type).getRealType();
        }
        return type;
    }

    private IType[] replacePhantomType(IType[] types) {
        if (types == null || this.isPhantomMode()) {
            return types;
        }
        IType[] result = new IType[types.length];
        int idx = 0;
        while (idx < types.length) {
            result[idx] = types[idx] instanceof PhantomType ? ((PhantomType)types[idx]).getRealType() : types[idx];
            ++idx;
        }
        return result;
    }

    private IType[] filterPhantomTypes(IType[] types) {
        if (types == null | this.isPhantomMode()) {
            return types;
        }
        ArrayList<IType> result = new ArrayList<IType>(types.length);
        int idx = 0;
        while (idx < types.length) {
            if (!(types[idx] instanceof PhantomType)) {
                result.add(types[idx]);
            }
            ++idx;
        }
        IType[] r = result.toArray(new IType[result.size()]);
        return r;
    }

    private static IType[] filterDuplicates(IType[] types) {
        HashSet<IType> uniques = new HashSet<IType>();
        IType[] tmp = new IType[types.length];
        int j = 0;
        int idx = 0;
        while (idx < types.length) {
            if (!uniques.contains(types[idx])) {
                tmp[j++] = types[idx];
            }
            uniques.add(types[idx]);
            ++idx;
        }
        if (j == types.length) {
            return types;
        }
        IType[] result = new IType[j];
        System.arraycopy(tmp, 0, result, 0, j);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("=== OT Type Hierarchy ===\n");
        buffer.append("Focus type: " + this.focusType.getFullyQualifiedName('.') + "\n");
        buffer.append("Subtypes:" + this.computeSubtypes + "\n");
        buffer.append("=== class to superclass ===\n");
        buffer.append(OTTypeHierarchyHelper.toString(this.classToSuperclass));
        buffer.append("\n");
        buffer.append("=== type to tsuper types ===\n");
        buffer.append(OTTypeHierarchyHelper.toString(this._typeToTSuperTypes));
        buffer.append("\n");
        buffer.append("=== type to super interfaces ===\n");
        buffer.append(OTTypeHierarchyHelper.toString(this.typeToSuperInterfaces));
        buffer.append("\n");
        buffer.append("=== type to subtypes ===\n");
        buffer.append(OTTypeHierarchyHelper.toString(this.typeToSubtypes));
        buffer.append("\n");
        buffer.append("=== type to tsubtypes ===\n");
        buffer.append(OTTypeHierarchyHelper.toString(this._typeToTSubTypes));
        buffer.append("\n");
        return buffer.toString();
    }

    private boolean isInterface(IType type) {
        int flags = this.getCachedFlags(type);
        if (flags == -1) {
            try {
                return type.isInterface();
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return Flags.isInterface(flags);
    }

    private void addAllCheckingDuplicates(ArrayList<IType> list, IType[] collection) {
        int i = 0;
        while (i < collection.length) {
            IType element = collection[i];
            if (!list.contains(element)) {
                list.add(element);
            }
            ++i;
        }
    }
}

