/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.PhantomType;
import org.eclipse.objectteams.otdt.internal.core.CopyInheritanceInfo;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchy;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchyHelper;
import org.eclipse.objectteams.otdt.internal.core.TypeHierarchyConnector;

public class OTTypeHierarchyBuilder {
    public static final int INIT_SIZE = 23;
    protected OTTypeHierarchy _hierarchy;
    protected OTTypeHierarchy _enclosingTeamHierarchy;
    protected IType _focusType;

    public OTTypeHierarchyBuilder(OTTypeHierarchy hierarchy) {
        this._hierarchy = hierarchy;
        this._focusType = this._hierarchy.getType();
    }

    public void build(boolean computeSubTypes) throws JavaModelException {
        this._hierarchy.initialize(23);
        if (OTTypeHierarchyHelper.isRole(this._focusType)) {
            this.buildOTTypeHierarchy(computeSubTypes);
            if (computeSubTypes) {
                this.buildOTSubtypeHierarchyForRoleType();
            }
        } else {
            this.buildTypeHierarchy(computeSubTypes);
            if (computeSubTypes) {
                this.buildOTSubtypeHierarchy(this._focusType);
            }
        }
        this._hierarchy._hierarchyCache.cacheOTTypeHierarchy(this._hierarchy);
    }

    protected void buildOTTypeHierarchy(boolean computeSubtypes) throws JavaModelException {
        IType enclosingType = ((IRoleType)OTModelManager.getOTElement(this._focusType)).getTeamJavaType();
        if (enclosingType == null) {
            throw new JavaModelException(new JavaModelStatus(4, "Enclosing team not found for " + this._focusType.getElementName() + " perhaps this element is not on the build path?"));
        }
        this._enclosingTeamHierarchy = new OTTypeHierarchy(enclosingType, enclosingType.getJavaProject(), computeSubtypes);
        this._enclosingTeamHierarchy.refresh((IProgressMonitor)new NullProgressMonitor());
        this.traverseEnclosingTeamHierarchy(enclosingType);
    }

    protected void buildTypeHierarchy(boolean computeSubtypes) throws JavaModelException {
        TypeHierarchyConnector connector = this._hierarchy.getProject() != null ? new TypeHierarchyConnector(this._hierarchy.getType(), this._hierarchy.getProject(), computeSubtypes) : new TypeHierarchyConnector(this._hierarchy.getType(), this._hierarchy.scope, computeSubtypes);
        connector.refresh((IProgressMonitor)new NullProgressMonitor());
        this._hierarchy.connect(connector);
    }

    protected CopyInheritanceInfo traverseEnclosingTeamHierarchy(IType teamType) throws JavaModelException {
        if (teamType.equals(this._enclosingTeamHierarchy.ORG_OBJECTTEAMS_TEAM) || teamType.equals(this._enclosingTeamHierarchy.JAVA_LANG_OBJECT) || !Flags.isTeam(teamType.getFlags())) {
            return null;
        }
        CopyInheritanceInfo info = new CopyInheritanceInfo(this._hierarchy, teamType);
        IType[] roles = OTTypeHierarchyBuilder.getDeclaredRoles(teamType);
        if (roles != null) {
            info.addDeclaredRoles(roles);
        }
        IType[] tsuperTypes = this._enclosingTeamHierarchy.getTSuperTypes(teamType);
        int idx = 0;
        while (idx < tsuperTypes.length) {
            IType tsuperType = tsuperTypes[idx];
            CopyInheritanceInfo superInfo = this.traverseEnclosingTeamHierarchy(tsuperType);
            info.inherit(superInfo);
            ++idx;
        }
        IType superclass = this._enclosingTeamHierarchy.getExplicitSuperclass(teamType);
        if (superclass != null) {
            CopyInheritanceInfo superInfo = this.traverseEnclosingTeamHierarchy(superclass);
            info.inherit(superInfo);
        }
        if (roles != null) {
            info.addDeclaredInheritance(roles);
        }
        info.updateHierarchy();
        this._enclosingTeamHierarchy.setCopyInheritanceInfo(teamType, info);
        return info;
    }

    protected void buildOTSubtypeHierarchy(IType type) throws JavaModelException {
        IType[] subtypes = this._hierarchy.getSubtypes(type);
        int idx = 0;
        while (idx < subtypes.length) {
            IType subtype = subtypes[idx];
            if (OTTypeHierarchyHelper.isRole(subtype)) {
                OTTypeHierarchy additional = new OTTypeHierarchy(subtype, subtype.getJavaProject(), true);
                additional.refresh((IProgressMonitor)new NullProgressMonitor());
                this._hierarchy.integrate(additional);
            } else {
                this.buildOTSubtypeHierarchy(subtype);
            }
            ++idx;
        }
    }

    protected void buildOTSubtypeHierarchyForRoleType() throws JavaModelException {
        IType encTeam = this._enclosingTeamHierarchy.getFocusType();
        this.traverseDown(null, encTeam);
    }

    protected void traverseDown(IType encSuper, IType encType) throws JavaModelException {
        if (encSuper != null) {
            CopyInheritanceInfo superInfo = this._enclosingTeamHierarchy.getCopyInheritanceInfo(encSuper);
            CopyInheritanceInfo typeInfo = this._enclosingTeamHierarchy.getCopyInheritanceInfo(encType);
            if (typeInfo == null) {
                typeInfo = new CopyInheritanceInfo(this._hierarchy, encType);
                IType[] roles = OTTypeHierarchyBuilder.getDeclaredRoles(encType);
                if (roles != null) {
                    typeInfo.addDeclaredRoles(roles);
                }
                typeInfo.inherit(superInfo);
                if (roles != null) {
                    typeInfo.addDeclaredInheritance(roles);
                }
                typeInfo.updateHierarchy();
                this._enclosingTeamHierarchy.setCopyInheritanceInfo(encType, typeInfo);
            }
        }
        IType[] subtypes = this._enclosingTeamHierarchy.getSubtypes(encType);
        int idx = 0;
        while (idx < subtypes.length) {
            IType encSub = subtypes[idx];
            this.traverseDown(encType, encSub);
            ++idx;
        }
    }

    private static IType[] getDeclaredRoles(IType teamType) throws JavaModelException {
        if (teamType instanceof PhantomType) {
            return null;
        }
        IOTType iot = OTModelManager.getOTElement(teamType);
        assert (iot != null && iot.isTeam());
        return iot.getRoleTypes();
    }
}

