/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchy;
import org.eclipse.objectteams.otdt.internal.core.TypeHierarchyConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OTTypeHierarchyCache {
    Map<IType, ITypeHierarchy> _otHierarchies = new HashMap<IType, ITypeHierarchy>();
    Map<IType, ITypeHierarchy> _typeHierarchyConnectors = new HashMap<IType, ITypeHierarchy>();

    OTTypeHierarchyCache() {
    }

    private static boolean cacheHierarchy(ITypeHierarchy hierarchy, Map<IType, ITypeHierarchy> hierarchies) {
        if (hierarchy == null) {
            throw new IllegalArgumentException();
        }
        IType focus = hierarchy.getType();
        if (focus != null) {
            hierarchies.put(focus, hierarchy);
            return true;
        }
        return false;
    }

    public boolean cacheOTTypeHierarchy(OTTypeHierarchy hierarchy) {
        return OTTypeHierarchyCache.cacheHierarchy(hierarchy, this._otHierarchies);
    }

    public boolean cacheTypeHierarchyQuery(TypeHierarchyConnector hierarchy) {
        return OTTypeHierarchyCache.cacheHierarchy(hierarchy, this._typeHierarchyConnectors);
    }

    public OTTypeHierarchy getOTTypeHierarchy(IType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        ITypeHierarchy result = this._otHierarchies.get(type);
        return result != null ? (OTTypeHierarchy)result : null;
    }

    public TypeHierarchyConnector getTypeHierachyQuery(IType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        ITypeHierarchy result = this._typeHierarchyConnectors.get(type);
        return result != null ? (TypeHierarchyConnector)result : null;
    }

    public void clear() {
        this._otHierarchies.clear();
        this._typeHierarchyConnectors.clear();
    }

    public void remove(IType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this._otHierarchies.remove(type);
        this._typeHierarchyConnectors.remove(type);
    }
}

