/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.core.TypeVector;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.PhantomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTTypeHierarchyHelper {
    protected static boolean isTeam(IType type) {
        IOTType possibleTeam = OTModelManager.getOTElement(type);
        return possibleTeam != null && possibleTeam.isTeam();
    }

    protected static IType getJavaModelIType(IType type) {
        IType rawType = type;
        if (type instanceof IOTType) {
            rawType = (IType)((IOTType)type).getCorrespondingJavaElement();
        }
        return rawType;
    }

    protected static boolean isRole(IType type) {
        if (type instanceof PhantomType) {
            return true;
        }
        IOTType possibleRole = OTModelManager.getOTElement(type);
        return possibleRole != null && possibleRole.isRole();
    }

    protected static String toString(Map<IType, ?> map) {
        StringBuffer buffer = new StringBuffer();
        for (IType keyType : map.keySet()) {
            Object obj = map.get(keyType);
            buffer.append(OTTypeHierarchyHelper.toString(keyType));
            buffer.append(" -> ");
            if (obj instanceof IType[]) {
                buffer.append(OTTypeHierarchyHelper.toString((IType[])obj));
            } else if (obj instanceof TypeVector) {
                buffer.append(OTTypeHierarchyHelper.toString((TypeVector)obj));
            } else if (obj instanceof IType) {
                buffer.append(OTTypeHierarchyHelper.toString((IType)obj));
            } else {
                buffer.append(obj);
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected static String toString(IType type) {
        if (type instanceof PhantomType) {
            return type.toString();
        }
        return type.getFullyQualifiedName('.');
    }

    protected static String toString(TypeVector types) {
        return OTTypeHierarchyHelper.toString(types.elements());
    }

    protected static String toString(IType[] types) {
        StringBuffer buffer = new StringBuffer();
        int idx = 0;
        while (idx < types.length) {
            IType type = types[idx];
            if (idx != 0) {
                buffer.append(", ");
            }
            buffer.append(OTTypeHierarchyHelper.toString(type));
            ++idx;
        }
        return buffer.toString();
    }

    protected static void addAllCheckingDuplicates(Map<IType, TypeVector> typesMap, Map<IType, ?> addTypesMap) {
        for (IType keyType : addTypesMap.keySet()) {
            TypeVector types = typesMap.get(keyType);
            TypeVector addTypes = (TypeVector)addTypesMap.get(keyType);
            if (types == null) {
                typesMap.put(keyType, addTypes);
                continue;
            }
            OTTypeHierarchyHelper.addAllCheckingDuplicates(types, addTypes);
        }
    }

    protected static void addAllCheckingDuplicates(TypeVector types, TypeVector addTypes) {
        IType[] newTypes = addTypes.elements();
        int idx = 0;
        while (idx < newTypes.length) {
            IType newType = newTypes[idx];
            if (!types.contains(newType)) {
                types.add(newType);
            }
            ++idx;
        }
    }
}

