/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.ICalloutMapping;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.AdditionalTypeInfo;
import org.eclipse.objectteams.otdt.internal.core.OTTypeHierarchy;
import org.eclipse.objectteams.otdt.internal.core.ObjectQueue;
import org.eclipse.objectteams.otdt.internal.core.TraverseRequestor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTTypeHierarchyTraverser {
    public static final int SUB_HIERARCHY = 0;
    public static final int SUPER_HIERARCHY = 1;
    public static final int TRAVERSE_IMPLICIT_FIRST = 2;
    public static final int TRAVERSE_EXPLICIT_FIRST = 3;
    public static final String IS_FOCUS_TYPE = "isFocusType";
    public static final String IS_EXPLICIT_SUPERCLASS = "isExplicitSuperclass";
    public static final String IS_BEHIND_EXPLICIT_INHERITANCE = "isBehindExplicitInheritance";
    private int _hierarchyToTraverse;
    private int _traverseFirst;
    private boolean _includeFocusType;
    private boolean _includeRootClass;
    private IType _focusType;
    private OTTypeHierarchy _hierarchy;
    private IProgressMonitor _progressMonitor;
    private TraverseRequestor _requestor;

    public OTTypeHierarchyTraverser(TraverseRequestor requestor, int hierarchyToTraverse, int traverseFirst, boolean includeFocusType, boolean includeRootClass, IProgressMonitor progressMonitor) {
        this._requestor = requestor;
        this._hierarchyToTraverse = hierarchyToTraverse;
        this._traverseFirst = traverseFirst;
        this._includeFocusType = includeFocusType;
        this._includeRootClass = includeRootClass;
        this._progressMonitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
    }

    private void initializeHierarchy() throws JavaModelException {
        this._hierarchy = new OTTypeHierarchy(this._focusType, this._focusType.getJavaProject(), this._hierarchyToTraverse == 0);
        this._hierarchy.refresh(this._progressMonitor);
    }

    public void traverse() throws JavaModelException {
        assert (this._requestor != null) : "Use only with valid requestor!";
        this._focusType = this._requestor.getFocusType();
        if (this._focusType instanceof IOTType) {
            this._focusType = (IType)((IOTType)this._focusType).getCorrespondingJavaElement();
        }
        this.initializeHierarchy();
        if (this._includeFocusType) {
            this.report(this._focusType, this.createContext(true, false, false));
        }
        IType explicitSuperclass = null;
        IType[] implicitSuperclasses = null;
        IType[] superInterface = null;
        AdditionalTypeInfo currentTypeInfo = null;
        IType currentType = this._focusType;
        ObjectQueue queue = new ObjectQueue();
        do {
            explicitSuperclass = this._hierarchy.getExplicitSuperclass(currentType);
            implicitSuperclasses = this._hierarchy.getTSuperTypes(currentType);
            superInterface = this._hierarchy.getSuperInterfaces(currentType);
            if (explicitSuperclass != null && this._traverseFirst == 3) {
                queue.put(new AdditionalTypeInfo(explicitSuperclass, true, true));
            }
            int idx = 0;
            while (idx < implicitSuperclasses.length) {
                queue.put(new AdditionalTypeInfo(implicitSuperclasses[idx], false, currentTypeInfo == null ? false : currentTypeInfo.isBehindExplicitInheritance()));
                ++idx;
            }
            if (explicitSuperclass != null && this._traverseFirst == 2) {
                queue.put(new AdditionalTypeInfo(explicitSuperclass, true, true));
            }
            idx = 0;
            while (idx < superInterface.length) {
                queue.put(new AdditionalTypeInfo(superInterface[idx], false, currentTypeInfo == null ? false : currentTypeInfo.isBehindExplicitInheritance()));
                ++idx;
            }
            currentTypeInfo = (AdditionalTypeInfo)queue.take();
            if (currentTypeInfo == null) continue;
            currentType = currentTypeInfo.getType();
            if (!this._includeRootClass && (currentType.getFullyQualifiedName().equals("java.lang.Object") || currentType.getFullyQualifiedName().equals(TypeHelper.ORG_OBJECTTEAMS_TEAM))) continue;
            this.report(currentType, this.createContext(false, currentTypeInfo.isExplicitSuperclass(), currentTypeInfo.isBehindExplicitInheritance()));
        } while (currentTypeInfo != null);
    }

    private HashMap<String, Boolean> createContext(boolean isFocusType, boolean isExplicitSuperclass, boolean isBehindExplicitSuperclass) {
        HashMap<String, Boolean> context = new HashMap<String, Boolean>();
        context.put(IS_FOCUS_TYPE, new Boolean(isFocusType));
        context.put(IS_EXPLICIT_SUPERCLASS, new Boolean(isExplicitSuperclass));
        context.put(IS_BEHIND_EXPLICIT_INHERITANCE, new Boolean(isBehindExplicitSuperclass));
        return context;
    }

    private void report(IType type, HashMap<String, Boolean> context) throws JavaModelException {
        IOTType otType = OTModelManager.getOTElement(type);
        this._requestor.report(type, context);
        int idx = 0;
        while (idx < type.getMethods().length) {
            this._requestor.report(type.getMethods()[idx], context);
            ++idx;
        }
        idx = 0;
        while (idx < type.getFields().length) {
            this._requestor.report(type.getFields()[idx], context);
            ++idx;
        }
        if (otType != null && otType instanceof IRoleType) {
            IRoleType roleType = (IRoleType)otType;
            int idx2 = 0;
            while (idx2 < roleType.getMethodMappings(1).length) {
                this._requestor.report((ICallinMapping)roleType.getMethodMappings(1)[idx2], context);
                ++idx2;
            }
            idx2 = 0;
            while (idx2 < roleType.getMethodMappings(2).length) {
                IMethodMapping mapping = roleType.getMethodMappings(2)[idx2];
                if (mapping instanceof ICalloutToFieldMapping) {
                    this._requestor.report((ICalloutToFieldMapping)mapping, context);
                } else {
                    this._requestor.report((ICalloutMapping)mapping, context);
                }
                ++idx2;
            }
        }
    }
}

