/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PotentialLowerExpression;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.lifting.Lifting;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.RoleTypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.MethodModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;

public class BaseAllocationExpression
extends Assignment {
    public Expression[] arguments;
    public Expression enclosingInstance;
    private boolean isAstCreated = false;
    private Boolean checkResult = null;

    public BaseAllocationExpression(int start, int end) {
        super(new SingleNameReference(IOTConstants._OT_BASE, 0L), null, end);
        this.sourceStart = start;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (((AbstractMethodDeclaration)currentScope.methodScope().referenceContext).ignoreFurtherInvestigation) {
            return flowInfo;
        }
        return super.analyseCode(currentScope, flowContext, flowInfo);
    }

    private void createAst(BlockScope scope) {
        Expression allocation;
        if (this.isAstCreated) {
            return;
        }
        this.isAstCreated = true;
        ReferenceBinding baseclass = null;
        SourceTypeBinding enclType = scope.enclosingSourceType();
        AbstractMethodDeclaration enclMethodDecl = (AbstractMethodDeclaration)scope.methodScope().referenceContext;
        if (enclType.isDirectRole()) {
            baseclass = ((MemberTypeBinding)enclType).baseclass();
        }
        if (baseclass == null || !enclMethodDecl.isConstructor()) {
            scope.problemReporter().baseConstructorCallInWrongMethod(this, scope.methodScope().referenceContext);
            return;
        }
        ConstructorDeclaration enclCtor = (ConstructorDeclaration)enclMethodDecl;
        if (enclCtor.statements[0] != this) {
            scope.problemReporter().baseConstructorCallIsNotFirst(this);
        }
        AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
        if (this.enclosingInstance != null) {
            this.enclosingInstance = new PotentialLowerExpression(this.enclosingInstance, baseclass.enclosingType());
        }
        if (baseclass.isDirectRole()) {
            Expression receiver;
            if (RoleTypeBinding.isRoleWithExplicitAnchor(baseclass)) {
                RoleTypeBinding baseRole = (RoleTypeBinding)baseclass;
                ITeamAnchor anchor = baseRole._teamAnchor;
                ReferenceBinding startClass = anchor.getFirstDeclaringClass();
                char[][] tokens = anchor.tokens();
                if (startClass != null) {
                    TypeReference startReference = gen.typeReference(startClass);
                    startReference.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
                    receiver = gen.qualifiedThisReference(startReference);
                    int i = 0;
                    while (i < tokens.length) {
                        receiver = gen.fieldReference(receiver, tokens[i]);
                        ++i;
                    }
                } else {
                    receiver = gen.qualifiedNameReference(tokens);
                }
            } else {
                receiver = this.enclosingInstance != null ? this.enclosingInstance : gen.thisReference();
            }
            char[] selector = CharOperation.concat(IOTConstants.CREATOR_PREFIX_NAME, baseclass.sourceName());
            MessageSend allocSend = new MessageSend(){

                protected boolean isDecapsulationAllowed(Scope scope2) {
                    return true;
                }

                public Expression.DecapsulationState getBaseclassDecapsulation() {
                    return Expression.DecapsulationState.ALLOWED;
                }
            };
            gen.setPositions(allocSend);
            allocSend.receiver = receiver;
            allocSend.selector = selector;
            allocSend.arguments = this.arguments;
            allocation = allocSend;
        } else {
            AllocationExpression alloc = this.newAllocation(baseclass, gen);
            alloc.type.setBaseclassDecapsulation(Expression.DecapsulationState.ALLOWED);
            alloc.arguments = this.arguments;
            alloc.sourceStart = this.sourceStart;
            alloc.sourceEnd = this.sourceEnd;
            alloc.statementEnd = this.statementEnd;
            allocation = alloc;
        }
        this.arguments = null;
        ExplicitConstructorCall selfcall = enclCtor.constructorCall;
        if (selfcall.isImplicitSuper() && ((ReferenceBinding)enclType).superclass().isDirectRole() && ((ReferenceBinding)enclType).superclass().baseclass() != null) {
            enclCtor.constructorCall = this.genLiftCtorCall(allocation);
            enclCtor.statements[0] = new AstGenerator(this.sourceStart, this.sourceEnd).emptyStatement();
        } else if (!enclType.roleModel.hasBaseclassProblem() && !scope.referenceType().ignoreFurtherInvestigation) {
            this.expression = allocation;
            MethodModel.setCallsBaseCtor(enclCtor);
            RoleModel boundRootRoleModel = enclType.roleModel.getBoundRootRole();
            if (boundRootRoleModel == null) {
                throw new InternalCompilerError("Unexpected: role has neither baseclassProblem nor boundRootRole");
            }
            Statement[] regStats = Lifting.genRoleRegistrationStatements(scope, boundRootRoleModel, baseclass, enclCtor, gen);
            int len = enclCtor.statements.length;
            Statement[] newStats = new Statement[len + regStats.length];
            newStats[0] = this;
            System.arraycopy(regStats, 0, newStats, 1, regStats.length);
            System.arraycopy(enclCtor.statements, 1, newStats, regStats.length + 1, len - 1);
            enclCtor.setStatements(newStats);
        }
    }

    private AllocationExpression newAllocation(ReferenceBinding baseclass, AstGenerator gen) {
        if (this.enclosingInstance == null) {
            AllocationExpression alloc = new AllocationExpression();
            alloc.type = gen.typeReference(baseclass);
            return alloc;
        }
        QualifiedAllocationExpression alloc = new QualifiedAllocationExpression();
        alloc.enclosingInstance = this.enclosingInstance;
        alloc.type = gen.singleTypeReference(baseclass.sourceName);
        return alloc;
    }

    private ExplicitConstructorCall genLiftCtorCall(Expression baseExpr) {
        ExplicitConstructorCall constructorCall = new ExplicitConstructorCall(2);
        constructorCall.arguments = new Expression[]{baseExpr};
        constructorCall.sourceStart = this.sourceStart;
        constructorCall.sourceEnd = this.sourceEnd;
        return constructorCall;
    }

    public boolean checkGenerate(BlockScope scope) {
        if (this.checkResult != null) {
            return this.checkResult;
        }
        this.checkResult = this.internalCheckGenerate(scope);
        return this.checkResult;
    }

    private boolean internalCheckGenerate(BlockScope scope) {
        if (scope == null) {
            return false;
        }
        ReferenceContext referenceContext = scope.methodScope().referenceContext;
        if (!(referenceContext instanceof AbstractMethodDeclaration)) {
            scope.problemReporter().baseConstructorCallInWrongMethod(this, referenceContext);
            return false;
        }
        AbstractMethodDeclaration enclosingMethodDeclaration = (AbstractMethodDeclaration)referenceContext;
        if (!enclosingMethodDeclaration.ignoreFurtherInvestigation) {
            this.createAst(scope);
            return this.expression != null;
        }
        return false;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        TypeDeclaration enclType;
        TypeDeclaration typeDeclaration = enclType = scope != null ? scope.referenceType() : null;
        if (enclType != null && enclType.isDirectRole() && StateHelper.hasState(enclType.binding, 7)) {
            if (this.checkGenerate(scope)) {
                super.traverse(visitor, scope);
            }
        } else if (this.expression != null) {
            super.traverse(visitor, scope);
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        if (!this.checkGenerate(scope)) {
            return null;
        }
        if (!scope.methodScope().referenceContext.hasErrors()) {
            return super.resolveType(scope);
        }
        return null;
    }

    public String toString() {
        if (this.expression == null) {
            return "unresolved base() call";
        }
        return this.expression.toString();
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.expression != null) {
            return super.printExpression(indent, output);
        }
        return output.append("<no expression yet>");
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        if (this.expression != null) {
            return super.printExpressionNoParenthesis(indent, output);
        }
        return output.append("<no expression yet>");
    }
}

